/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.jmx.Mbeans;
import org.opennms.netmgt.dao.AbstractJaxbConfigDao;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class JMXDataCollectionConfigDao
extends AbstractJaxbConfigDao<JmxDatacollectionConfig, JmxDatacollectionConfig> {
    public JMXDataCollectionConfigDao() {
        super(JmxDatacollectionConfig.class, "jmx-data-collection");
    }

    public JmxDatacollectionConfig translateConfig(JmxDatacollectionConfig config) {
        for (JmxCollection collection : config.getJmxCollection()) {
            if (collection.getMbeans() == null) {
                collection.setMbeans(new Mbeans());
            }
            if (!collection.hasImportMbeans()) continue;
            for (String importMbeans : collection.getImportGroupsList()) {
                File file = new File(ConfigFileConstants.getHome(), "/etc/" + importMbeans);
                this.log().debug("parseJmxMbeans: parsing " + file);
                Mbeans mbeans = (Mbeans)JaxbUtils.unmarshal(Mbeans.class, (Resource)new FileSystemResource(file));
                collection.getMbeans().getMbeanCollection().addAll(mbeans.getMbeanCollection());
            }
        }
        return config;
    }

    public JmxDatacollectionConfig getConfig() {
        return (JmxDatacollectionConfig)this.getContainer().getObject();
    }
}

