/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CapsdConfigManager;

public class DefaultCapsdConfigManager
extends CapsdConfigManager {
    private long m_currentVersion = -1L;

    public DefaultCapsdConfigManager() {
    }

    public DefaultCapsdConfigManager(InputStream is) throws MarshalException, ValidationException {
        super(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void update() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
        this.log().debug("Checking to see if capsd configuration should be reloaded from " + configFile);
        if (this.m_currentVersion < configFile.lastModified()) {
            this.log().debug("Reloading capsd configuration file");
            long lastModified = configFile.lastModified();
            FileInputStream is = null;
            try {
                is = new FileInputStream(configFile);
                this.loadXml(is);
            }
            finally {
                if (is != null) {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            this.m_currentVersion = lastModified;
            this.log().info("Reloaded capsd configuration file");
        }
    }

    @Override
    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

