/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionSetVisitor;
import org.opennms.netmgt.collectd.PersistenceSelectorStrategy;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class PersistRegexSelectorStrategy
implements PersistenceSelectorStrategy {
    public static final String MATCH_EXPRESSION = "match-expression";
    public static final String MATCH_STRATEGY = "match-strategy";
    public static final String MATCH_BEHAVIOR = "match-behavior";
    private List<Parameter> m_parameterCollection;

    @Override
    public boolean shouldPersist(CollectionResource resource) {
        this.log().debug("shouldPersist: checking resource " + resource);
        if (this.m_parameterCollection == null) {
            this.log().warn("shouldPersist: no parameters defined; the resource will be persisted.");
            return true;
        }
        EvaluatorContextVisitor visitor = new EvaluatorContextVisitor();
        resource.visit((CollectionSetVisitor)visitor);
        SpelExpressionParser parser = new SpelExpressionParser();
        for (Parameter param : this.m_parameterCollection) {
            if (!param.getKey().equals(MATCH_EXPRESSION)) continue;
            Expression exp = parser.parseExpression(param.getValue());
            boolean shouldPersist = false;
            try {
                shouldPersist = (Boolean)exp.getValue((EvaluationContext)visitor.getEvaluationContext(), Boolean.class);
            }
            catch (Exception e) {
                this.log().warn("shouldPersist: can't evaluate expression " + param.getValue() + " for resource " + resource + " because: " + e.getMessage());
            }
            this.log().debug("shouldPersist: checking " + param.getValue() + " ? " + shouldPersist);
            if (!shouldPersist) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setParameters(List<Parameter> parameterCollection) {
        this.m_parameterCollection = parameterCollection;
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected class EvaluatorContextVisitor
    extends AbstractCollectionSetVisitor {
        private StandardEvaluationContext context = new StandardEvaluationContext();

        @Override
        public void visitAttribute(CollectionAttribute attribute) {
            if (StringAttributeType.supportsType(attribute.getType())) {
                this.context.setVariable(attribute.getName(), (Object)attribute.getStringValue());
            }
        }

        public StandardEvaluationContext getEvaluationContext() {
            return this.context;
        }
    }
}

