/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.snmp.SnmpInstId;

public class IfAliasResourceType
extends ResourceType {
    private IfResourceType m_ifResourceType;
    private Map<Integer, AliasedResource> m_aliasedIfs = new HashMap<Integer, AliasedResource>();
    private ServiceParameters m_params;

    public IfAliasResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection, ServiceParameters params, IfResourceType ifResourceType) {
        super(agent, snmpCollection);
        this.m_ifResourceType = ifResourceType;
        this.m_params = params;
    }

    @Override
    public SnmpCollectionResource findResource(SnmpInstId inst) {
        this.log().debug("findResource: Should not get called from IfAliasResourceType");
        return null;
    }

    @Override
    public SnmpCollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        Integer key = inst.toInt();
        AliasedResource resource = this.m_aliasedIfs.get(key);
        if (resource == null) {
            IfInfo ifInfo = (IfInfo)this.m_ifResourceType.findResource(inst);
            if (ifInfo == null) {
                this.log().info("Not creating an aliased resource for ifInfo = null");
            } else {
                this.log().info("Creating an aliased resource for " + ifInfo);
                resource = new AliasedResource(this, this.m_params.getDomain(), ifInfo, this.m_params.getIfAliasComment(), ifAlias);
                this.m_aliasedIfs.put(key, resource);
            }
        }
        return resource;
    }

    @Override
    public SnmpInstId[] getCollectionInstances() {
        return this.m_ifResourceType.getCollectionInstances();
    }

    @Override
    public Collection<SnmpAttributeType> loadAttributeTypes() {
        return this.getCollection().getAliasAttributeTypes(this.getAgent());
    }

    public Collection<AliasedResource> getResources() {
        return this.m_aliasedIfs.values();
    }
}

