/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.GenericIndexResource;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.PersistenceSelectorStrategy;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.config.StorageStrategyService;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;

public class GenericIndexResourceType
extends ResourceType {
    private String m_name;
    private PersistenceSelectorStrategy m_persistenceSelectorStrategy;
    private StorageStrategy m_storageStrategy;
    private Map<SnmpInstId, GenericIndexResource> m_resourceMap = new HashMap<SnmpInstId, GenericIndexResource>();

    public GenericIndexResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection, org.opennms.netmgt.config.datacollection.ResourceType resourceType) throws IllegalArgumentException {
        super(agent, snmpCollection);
        Assert.notNull((Object)resourceType, (String)"resourceType argument must not be null");
        this.m_name = resourceType.getName();
        this.instantiatePersistenceSelectorStrategy(resourceType.getPersistenceSelectorStrategy().getClazz());
        this.instantiateStorageStrategy(resourceType.getStorageStrategy().getClazz());
        this.m_storageStrategy.setParameters(resourceType.getStorageStrategy().getParameterCollection());
        this.m_persistenceSelectorStrategy.setParameters(resourceType.getPersistenceSelectorStrategy().getParameterCollection());
    }

    private void instantiatePersistenceSelectorStrategy(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            this.m_persistenceSelectorStrategy = (PersistenceSelectorStrategy)cinst.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
    }

    private void instantiateStorageStrategy(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            this.m_storageStrategy = (StorageStrategy)cinst.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        this.m_storageStrategy.setResourceTypeName(this.m_name);
        if (this.getAgent() != null) {
            this.m_storageStrategy.setStorageStrategyService((StorageStrategyService)this.getAgent());
        }
    }

    @Override
    public SnmpCollectionResource findResource(SnmpInstId inst) {
        if (!this.m_resourceMap.containsKey(inst)) {
            this.m_resourceMap.put(inst, new GenericIndexResource(this, this.getName(), inst));
        }
        return this.m_resourceMap.get(inst);
    }

    @Override
    public SnmpCollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        this.log().debug("findAliasedResource: Should not get called from GenericIndexResourceType");
        return null;
    }

    @Override
    public Collection<SnmpAttributeType> loadAttributeTypes() {
        return this.getCollection().getIndexedAttributeTypesForResourceType(this.getAgent(), this);
    }

    public Collection<GenericIndexResource> getResources() {
        return this.m_resourceMap.values();
    }

    public String getName() {
        return this.m_name;
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }

    public PersistenceSelectorStrategy getPersistenceSelectorStrategy() {
        return this.m_persistenceSelectorStrategy;
    }
}

