/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AliasedAttribute;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.config.collector.AttributeGroup;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.config.collector.ServiceParameters;

public class AliasedGroup
extends AttributeGroup {
    AttributeGroup m_group;

    public AliasedGroup(CollectionResource resource, AttributeGroup group) {
        super(resource, group.getGroupType());
        this.m_group = group;
    }

    public void addAttribute(SnmpAttribute attr) {
        this.m_group.addAttribute((CollectionAttribute)attr);
    }

    public boolean equals(Object obj) {
        return this.m_group.equals(obj);
    }

    public Collection<CollectionAttribute> getAttributes() {
        return this.m_group.getAttributes();
    }

    public AttributeGroupType getGroupType() {
        return this.m_group.getGroupType();
    }

    public String getName() {
        return this.m_group.getName();
    }

    public int hashCode() {
        return this.m_group.hashCode();
    }

    public boolean shouldPersist(ServiceParameters params) {
        return this.m_group.shouldPersist(params);
    }

    public String toString() {
        return this.m_group.toString();
    }

    ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitGroup((AttributeGroup)this);
        for (CollectionAttribute attr : this.getAttributes()) {
            AliasedAttribute aliased = new AliasedAttribute(this.getResource(), (SnmpAttribute)attr);
            this.log().debug("visiting at aliased  = " + aliased);
            aliased.visit(visitor);
        }
        visitor.completeGroup((AttributeGroup)this);
    }
}

