/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpStore;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;

public abstract class SnmpTable<T extends SnmpStore>
extends AggregateTracker
implements Collection<T> {
    private final Map<SnmpInstId, T> m_results = new TreeMap<SnmpInstId, T>();
    private InetAddress m_address;
    private String m_tableName;

    protected SnmpTable(InetAddress address, String tableName, NamedSnmpVar[] columns) {
        super((Collectable[])NamedSnmpVar.getTrackersFor(columns));
        this.m_address = address;
        this.m_tableName = tableName;
    }

    protected void storeResult(SnmpResult res) {
        SnmpStore entry = (SnmpStore)((Object)this.m_results.get(res.getInstance()));
        if (entry == null) {
            entry = this.createTableEntry(res.getBase(), res.getInstance(), res.getValue());
            this.m_results.put(res.getInstance(), (T)((Object)entry));
        }
        entry.storeResult(res);
    }

    protected abstract T createTableEntry(SnmpObjId var1, SnmpInstId var2, Object var3);

    public Collection<T> getEntries() {
        return new ArrayList<T>(this.m_results.values());
    }

    @Override
    public Iterator<T> iterator() {
        return this.m_results.values().iterator();
    }

    protected void reportGenErr(String msg) {
        this.log().warn("Error retrieving " + this.m_tableName + " from " + this.m_address + ". " + msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info("Error retrieving " + this.m_tableName + " from " + this.m_address + ". " + msg);
    }

    private final ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_results.values().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_results.values().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.m_results.values().isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.m_results.values().size();
    }

    @Override
    public Object[] toArray() {
        return this.m_results.values().toArray();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return this.m_results.values().toArray(a);
    }
}

