/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;

public abstract class JMXPlugin
extends AbstractPlugin {
    private String protocolName = null;

    public abstract String getProtocolName(Map<String, Object> var1);

    public abstract ConnectionWrapper getMBeanServerConnection(Map<String, Object> var1, InetAddress var2);

    @Override
    public String getProtocolName() {
        return this.protocolName.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> map) {
        if (this.protocolName == null) {
            this.protocolName = this.getProtocolName(map);
        }
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean res = false;
        ConnectionWrapper connection = null;
        try {
            connection = this.getMBeanServerConnection(map, address);
            Integer result = connection.getMBeanServer().getMBeanCount();
            log.debug("isProtocolSupported? " + this.getProtocolName() + " " + result + " " + connection);
            if (result != null) {
                res = true;
            }
        }
        catch (Throwable e) {
            log.debug(this.getProtocolName(map) + " - isProtocolSupported - failed! " + InetAddressUtils.str((InetAddress)address));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return res;
    }
}

