/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.DbSnmpInterfaceEntry;
import org.opennms.netmgt.capsd.IfCollector;
import org.opennms.netmgt.capsd.IfSmbCollector;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.capsd.PluginManager;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.snmp.IfTable;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.capsd.snmp.IfXTableEntry;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.capsd.snmp.SystemGroup;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;

public final class RescanProcessor
implements Runnable {
    private static final InetAddress ZERO_ZERO_ZERO_ZERO = InetAddressUtils.addr((String)"0.0.0.0");
    static final String SQL_DB_RETRIEVE_NODE_TYPE = "SELECT nodetype FROM node WHERE nodeID=?";
    static final String SQL_DB_RETRIEVE_OTHER_NODES = "SELECT ipinterface.nodeid FROM ipinterface, node WHERE ipinterface.ismanaged != 'D' AND ipinterface.ipaddr = ? AND ipinterface.nodeid = node.nodeid AND node.foreignsource IS NULL AND ipinterface.nodeid !=? ";
    static final String SQL_DB_REPARENT_IP_INTERFACE_LOOKUP = "SELECT ipaddr, ifindex FROM ipinterface WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    static final String SQL_DB_REPARENT_IP_INTERFACE_DELETE = "DELETE FROM ipinterface WHERE nodeID=? AND ipaddr=?";
    static final String SQL_DB_REPARENT_IP_INTERFACE = "UPDATE ipinterface SET nodeID=? WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    static final String SQL_DB_REPARENT_SNMP_IF_LOOKUP = "SELECT id FROM snmpinterface WHERE nodeID=? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_SNMP_IF_DELETE = "DELETE FROM snmpinterface WHERE nodeID=? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_SNMP_INTERFACE = "UPDATE snmpinterface SET nodeID=? WHERE nodeID=? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_IF_SERVICES_LOOKUP = "SELECT serviceid FROM ifservices WHERE nodeID=? AND ipaddr=? AND ifindex = ? AND status!='D'";
    static final String SQL_DB_REPARENT_IF_SERVICES_DELETE = "DELETE FROM ifservices WHERE nodeID=? AND ipaddr=? ";
    static final String SQL_DB_REPARENT_IF_SERVICES = "UPDATE ifservices SET nodeID=? WHERE nodeID=? AND ipaddr=? AND status!='D'";
    static final String SQL_DB_DELETE_DUP_INTERFACE = "DELETE FROM ipinterface WHERE nodeID=?";
    static final String SQL_DB_DELETE_DUP_SERVICES = "DELETE FROM ifservices WHERE nodeid=?";
    static final String SQL_DB_DELETE_DUP_SNMPINTERFACE = "DELETE FROM snmpinterface WHERE nodeid =?";
    private static final String SQL_RETRIEVE_SERVICE_IDS = "SELECT serviceid,servicename  FROM service";
    private static final String SQL_DB_UPDATE_ISMANAGED = "UPDATE ipinterface SET ismanaged=? WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    private boolean m_forceRescan;
    private final List<Event> m_eventList = new ArrayList<Event>();
    private boolean m_ifIndexOnNodeChangedFlag;
    private boolean m_snmpIfTableChangedFlag;
    private CapsdDbSyncer m_capsdDbSyncer;
    private PluginManager m_pluginManager;
    private int m_nodeId;
    private static Set<Integer> m_queuedRescanTracker;

    RescanProcessor(Scheduler.NodeInfo nodeInfo, boolean forceRescan, CapsdDbSyncer capsdDbSyncer, PluginManager pluginManager) {
        this(nodeInfo.getNodeId(), forceRescan, capsdDbSyncer, pluginManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RescanProcessor(int nodeId, boolean forceRescan, CapsdDbSyncer capsdDbSyncer, PluginManager pluginManager) {
        this.m_nodeId = nodeId;
        this.m_forceRescan = forceRescan;
        this.m_capsdDbSyncer = capsdDbSyncer;
        this.m_pluginManager = pluginManager;
        Set<Integer> set = m_queuedRescanTracker;
        synchronized (set) {
            m_queuedRescanTracker.add(nodeId);
        }
    }

    private DbNodeEntry updateNode(Connection dbc, Date now, DbNodeEntry dbNodeEntry, InetAddress currPrimarySnmpIf, DbIpInterfaceEntry[] dbIpInterfaces, Map<String, IfCollector> collectorMap) throws SQLException {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateNode: updating node id " + dbNodeEntry.getNodeId());
        }
        DbNodeEntry originalDbNodeEntry = DbNodeEntry.clone(dbNodeEntry);
        DbNodeEntry currNodeEntry = DbNodeEntry.create();
        currNodeEntry.setNodeType('A');
        RescanProcessor.setNodeLabelAndSmbInfo(collectorMap, dbNodeEntry, currNodeEntry, currPrimarySnmpIf);
        if (currPrimarySnmpIf != null) {
            IfCollector primaryIfc;
            String addr = InetAddressUtils.str((InetAddress)currPrimarySnmpIf);
            IfCollector ifCollector = primaryIfc = addr == null ? null : collectorMap.get(addr);
            if (primaryIfc == null) {
                for (IfCollector tmp : collectorMap.values()) {
                    if (tmp.getSnmpCollector() == null) continue;
                    primaryIfc = tmp;
                    break;
                }
            }
            if (primaryIfc == null) {
                RescanProcessor.log().error("updateNode: failed to determine primary interface collector for node " + dbNodeEntry.getNodeId());
                throw new RuntimeException("Update node failed for node " + dbNodeEntry.getNodeId() + ", unable to determine primary interface collector.");
            }
            IfSnmpCollector snmpc = primaryIfc.getSnmpCollector();
            if (snmpc != null && snmpc.hasSystemGroup()) {
                String sysContact;
                String sysLocation;
                String sysDescr;
                SystemGroup sysgrp = snmpc.getSystemGroup();
                currNodeEntry.setSystemOID(sysgrp.getSysObjectID());
                String sysName = sysgrp.getSysName();
                if (sysName != null && sysName.length() > 0) {
                    currNodeEntry.setSystemName(sysName);
                }
                if ((sysDescr = sysgrp.getSysDescr()) != null && sysDescr.length() > 0) {
                    currNodeEntry.setSystemDescription(sysDescr);
                }
                if ((sysLocation = sysgrp.getSysLocation()) != null && sysLocation.length() > 0) {
                    currNodeEntry.setSystemLocation(sysLocation);
                }
                if ((sysContact = sysgrp.getSysContact()) != null && sysContact.length() > 0) {
                    currNodeEntry.setSystemContact(sysContact);
                }
            }
        }
        currNodeEntry.updateParentId(dbNodeEntry.getParentId());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateNode: -------dumping old node-------: " + dbNodeEntry);
            RescanProcessor.log().debug("updateNode: -------dumping new node-------: " + currNodeEntry);
        }
        dbNodeEntry.updateParentId(currNodeEntry.getParentId());
        dbNodeEntry.updateNodeType(currNodeEntry.getNodeType());
        dbNodeEntry.updateSystemOID(currNodeEntry.getSystemOID());
        dbNodeEntry.updateSystemName(currNodeEntry.getSystemName());
        dbNodeEntry.updateSystemDescription(currNodeEntry.getSystemDescription());
        dbNodeEntry.updateSystemLocation(currNodeEntry.getSystemLocation());
        dbNodeEntry.updateSystemContact(currNodeEntry.getSystemContact());
        dbNodeEntry.updateNetBIOSName(currNodeEntry.getNetBIOSName());
        dbNodeEntry.updateDomainName(currNodeEntry.getDomainName());
        dbNodeEntry.updateOS(currNodeEntry.getOS());
        dbNodeEntry.setLastPoll(now);
        if (dbNodeEntry.getLabelSource() != 'U') {
            dbNodeEntry.updateLabel(currNodeEntry.getLabel());
            dbNodeEntry.updateLabelSource(currNodeEntry.getLabelSource());
        }
        boolean nodeLabelChangedFlag = false;
        boolean nodeInfoChangedFlag = false;
        if (dbNodeEntry.hasLabelChanged() || dbNodeEntry.hasLabelSourceChanged()) {
            nodeLabelChangedFlag = true;
        }
        if (dbNodeEntry.hasSystemOIDChanged() || dbNodeEntry.hasSystemNameChanged() || dbNodeEntry.hasSystemDescriptionChanged() || dbNodeEntry.hasSystemLocationChanged() || dbNodeEntry.hasSystemContactChanged() || dbNodeEntry.hasNetBIOSNameChanged() || dbNodeEntry.hasDomainNameChanged() || dbNodeEntry.hasOSChanged()) {
            nodeInfoChangedFlag = true;
        }
        dbNodeEntry.store(dbc);
        if (nodeLabelChangedFlag) {
            this.m_eventList.add(RescanProcessor.createNodeLabelChangedEvent(dbNodeEntry, originalDbNodeEntry));
        }
        if (nodeInfoChangedFlag) {
            this.m_eventList.add(RescanProcessor.createNodeInfoChangedEvent(dbNodeEntry, originalDbNodeEntry));
        }
        return dbNodeEntry;
    }

    private void updateInterfaces(Connection dbc, Date now, DbNodeEntry node, Map<String, IfCollector> collectorMap, boolean doesSnmp) throws SQLException {
        RescanProcessor.log().debug("updateInterfaces: Rebuilding PackageIpListMap");
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        pollerCfgFactory.rebuildPackageIpListMap();
        ArrayList<InetAddress> updatedIfList = new ArrayList<InetAddress>();
        IfSnmpCollector snmpCollector = null;
        if (doesSnmp) {
            this.m_ifIndexOnNodeChangedFlag = false;
            this.m_snmpIfTableChangedFlag = false;
            IfCollector collectorWithSnmp = null;
            for (IfCollector tmp : collectorMap.values()) {
                if (tmp.getSnmpCollector() == null) continue;
                collectorWithSnmp = tmp;
                break;
            }
            if (collectorWithSnmp != null) {
                snmpCollector = collectorWithSnmp.getSnmpCollector();
                this.updateInterface(dbc, now, node, collectorWithSnmp.getTarget(), collectorWithSnmp.getTarget(), collectorWithSnmp.getSupportedProtocols(), snmpCollector, doesSnmp);
                updatedIfList.add(collectorWithSnmp.getTarget());
                if (collectorWithSnmp.hasAdditionalTargets()) {
                    Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = collectorWithSnmp.getAdditionalTargets();
                    for (InetAddress subIf : subTargets.keySet()) {
                        this.updateInterface(dbc, now, node, collectorWithSnmp.getTarget(), subIf, subTargets.get(subIf), snmpCollector, doesSnmp);
                        updatedIfList.add(subIf);
                    }
                }
                if (collectorWithSnmp.hasNonIpInterfaces()) {
                    for (Integer ifIndex : collectorWithSnmp.getNonIpInterfaces()) {
                        this.updateNonIpInterface(dbc, now, node, ifIndex, snmpCollector);
                    }
                }
            }
        }
        for (IfCollector ifc : collectorMap.values()) {
            InetAddress ifaddr = ifc.getTarget();
            if (!updatedIfList.contains(ifaddr)) {
                this.updateInterface(dbc, now, node, ifc.getTarget(), ifaddr, ifc.getSupportedProtocols(), snmpCollector, doesSnmp);
                updatedIfList.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (InetAddress subIf : subTargets.keySet()) {
                if (updatedIfList.contains(subIf)) continue;
                this.updateInterface(dbc, now, node, ifc.getTarget(), subIf, subTargets.get(subIf), snmpCollector, doesSnmp);
                updatedIfList.add(subIf);
            }
        }
    }

    private void updateNonIpInterface(Connection dbc, Date now, DbNodeEntry node, int ifIndex, IfSnmpCollector snmpc) throws SQLException {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateNonIpInterface: node= " + node.getNodeId() + " ifIndex= " + ifIndex);
        }
        if (snmpc == null || snmpc.failed()) {
            return;
        }
        InetAddress ifAddr = null;
        ifAddr = ZERO_ZERO_ZERO_ZERO;
        if (ifAddr == null) {
            return;
        }
        this.updateSnmpInfoForNonIpInterface(dbc, node, ifIndex, snmpc, ifAddr);
    }

    private void updateSnmpInfoForNonIpInterface(Connection dbc, DbNodeEntry node, int ifIndex, IfSnmpCollector snmpc, InetAddress ifAddr) throws SQLException {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateNonIpInterface: updating non-IP SNMP interface with nodeId=" + node.getNodeId() + " and ifIndex=" + ifIndex);
        }
        boolean newSnmpIfTableEntry = false;
        DbSnmpInterfaceEntry dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex);
        if (dbSnmpIfEntry == null) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateNonIpInterface: non-IP SNMP interface with ifIndex " + ifIndex + " not in database, creating " + "new snmpInterface object.");
            }
            dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            newSnmpIfTableEntry = true;
        }
        IfTableEntry ifte = RescanProcessor.findEntryByIfIndex(ifIndex, snmpc);
        IfXTableEntry ifxte = RescanProcessor.findXEntryByIfIndex(ifIndex, snmpc);
        if (ifte != null) {
            RescanProcessor.updateType(ifte, dbSnmpIfEntry);
            RescanProcessor.updateDescription(ifIndex, ifte, dbSnmpIfEntry);
            RescanProcessor.updatePhysicalAddress(ifIndex, ifte, dbSnmpIfEntry);
            RescanProcessor.updateSpeed(ifIndex, ifte, ifxte, dbSnmpIfEntry);
            RescanProcessor.updateAdminStatus(ifte, dbSnmpIfEntry);
            RescanProcessor.updateOperationalStatus(ifte, dbSnmpIfEntry);
            RescanProcessor.updateName(ifIndex, snmpc, dbSnmpIfEntry);
            RescanProcessor.updateAlias(ifIndex, snmpc, dbSnmpIfEntry);
        }
        if (!this.m_snmpIfTableChangedFlag && newSnmpIfTableEntry || dbSnmpIfEntry.hasTypeChanged() || dbSnmpIfEntry.hasNameChanged() || dbSnmpIfEntry.hasDescriptionChanged() || dbSnmpIfEntry.hasPhysicalAddressChanged() || dbSnmpIfEntry.hasAliasChanged()) {
            this.m_snmpIfTableChangedFlag = true;
        }
        dbSnmpIfEntry.store(dbc);
    }

    private static IfTableEntry findEntryByIfIndex(int ifIndex, IfSnmpCollector snmpc) {
        if (snmpc.hasIfTable()) {
            return snmpc.getIfTable().getEntry(ifIndex);
        }
        return null;
    }

    private static IfXTableEntry findXEntryByIfIndex(int ifIndex, IfSnmpCollector snmpc) {
        if (snmpc.hasIfXTable()) {
            return snmpc.getIfXTable().getEntry(ifIndex);
        }
        return null;
    }

    private static void updateAlias(int ifIndex, IfSnmpCollector snmpc, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String ifAlias = snmpc.getIfAlias(ifIndex);
        if (ifAlias != null) {
            dbSnmpIfEntry.updateAlias(ifAlias);
        } else {
            dbSnmpIfEntry.updateAlias("");
        }
    }

    private static void updateName(int ifIndex, IfSnmpCollector snmpc, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String ifName = snmpc.getIfName(ifIndex);
        if (ifName != null && ifName.length() > 0) {
            dbSnmpIfEntry.updateName(ifName);
        }
    }

    private static void updateOperationalStatus(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfOperStatus();
        if (sint == null) {
            dbSnmpIfEntry.updateOperationalStatus(0);
        } else {
            dbSnmpIfEntry.updateOperationalStatus(sint);
        }
    }

    private static void updateAdminStatus(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfAdminStatus();
        if (sint == null) {
            dbSnmpIfEntry.updateAdminStatus(0);
        } else {
            dbSnmpIfEntry.updateAdminStatus(sint);
        }
    }

    private static void updateType(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfType();
        if (sint == null) {
            dbSnmpIfEntry.updateType(0);
        } else {
            dbSnmpIfEntry.updateType(sint);
        }
    }

    private static void updateDescription(int ifIndex, IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String str = ifte.getIfDescr();
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateNonIpInterface: ifIndex: " + ifIndex + " has ifDescription: " + str);
        }
        if (str != null && str.length() > 0) {
            dbSnmpIfEntry.updateDescription(str);
        }
    }

    private static void updatePhysicalAddress(int ifIndex, IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String physAddr = ifte.getPhysAddr();
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateNonIpInterface: ifIndex: " + ifIndex + " has physical address '" + physAddr + "'");
        }
        if (physAddr != null && physAddr.length() == 12) {
            dbSnmpIfEntry.updatePhysicalAddress(physAddr);
        }
    }

    static void updateSpeed(int ifIndex, IfTableEntry ifte, IfXTableEntry ifxte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        long speed = 0L;
        try {
            speed = RescanProcessor.getInterfaceSpeed(ifte, ifxte);
        }
        catch (Throwable e) {
            RescanProcessor.log().warn("updateNonIpInterface: ifSpeed '" + ifte.getDisplayString("ifSpeed") + "' for ifIndex " + ifIndex + " is invalid, inserting 0: " + e, e);
            speed = 0L;
        }
        dbSnmpIfEntry.updateSpeed(speed);
    }

    private static long getInterfaceSpeed(IfTableEntry ifte, IfXTableEntry ifxte) {
        if (ifxte != null && ifxte.getIfHighSpeed() != null && ifxte.getIfHighSpeed() > 4294L) {
            return ifxte.getIfHighSpeed() * 1000000L;
        }
        if (ifte != null && ifte.getIfSpeed() != null) {
            return ifte.getIfSpeed();
        }
        return 0L;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(RescanProcessor.class);
    }

    private void updateInterface(Connection dbc, Date now, DbNodeEntry node, InetAddress target, InetAddress ifaddr, List<IfCollector.SupportedProtocol> protocols, IfSnmpCollector snmpc, boolean doesSnmp) throws SQLException {
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateInterface: updating interface " + ifaddrString + "(targetIf=" + InetAddressUtils.str((InetAddress)target) + ")");
            if (doesSnmp) {
                RescanProcessor.log().debug("updateInterface: the SNMP collection passed in is collected via" + (snmpc == null ? "No SnmpCollection passed in (snmpc == null)" : InetAddressUtils.str((InetAddress)snmpc.getCollectorTargetAddress())));
            }
        }
        boolean reparentFlag = false;
        boolean newIpIfEntry = false;
        int ifIndex = -1;
        DbIpInterfaceEntry dbIpIfEntry = DbIpInterfaceEntry.get(dbc, node.getNodeId(), ifaddr);
        if (doesSnmp && snmpc != null && snmpc.hasIpAddrTable()) {
            ifIndex = snmpc.getIfIndex(ifaddr);
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateInterface: interface = " + ifaddrString + " ifIndex = " + ifIndex + ". Checking for this address on other nodes.");
            }
            IpAddrTable ipAddrTable = null;
            ipAddrTable = snmpc.getIpAddrTable();
            if (ipAddrTable == null) {
                RescanProcessor.log().error("updateInterface: null ipAddrTable in the SNMP collection");
            } else if (ifaddrString.equals("0.0.0.0") || ifaddr.isLoopbackAddress()) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateInterface: Skipping address from snmpc ipAddrTable " + ifaddrString);
                }
            } else {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateInterface: Checking address from snmpc ipAddrTable " + ifaddrString);
                }
                PreparedStatement stmt = null;
                DBUtils d = new DBUtils(RescanProcessor.class);
                try {
                    stmt = dbc.prepareStatement(SQL_DB_RETRIEVE_OTHER_NODES);
                    d.watch((Object)stmt);
                    stmt.setString(1, ifaddrString);
                    stmt.setInt(2, node.getNodeId());
                    ResultSet rs = stmt.executeQuery();
                    d.watch((Object)rs);
                    while (rs.next()) {
                        DbIpInterfaceEntry[] tmpIfArray;
                        DbNodeEntry suspectNodeEntry;
                        int existingNodeId = rs.getInt(1);
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug("updateInterface: ckecking for " + ifaddrString + " on existing nodeid  " + existingNodeId);
                        }
                        if ((suspectNodeEntry = DbNodeEntry.get(dbc, existingNodeId)) == null || !RescanProcessor.areDbInterfacesInSnmpCollection(tmpIfArray = suspectNodeEntry.getInterfaces(dbc), snmpc)) continue;
                        for (int i = 0; i < tmpIfArray.length; ++i) {
                            InetAddress addr = tmpIfArray[i].getIfAddress();
                            int index = snmpc.getIfIndex(addr);
                            String addrString = InetAddressUtils.str((InetAddress)addr);
                            if (addrString == null || addrString.equals("0.0.0.0") || addr.isLoopbackAddress()) continue;
                            if (RescanProcessor.log().isDebugEnabled()) {
                                RescanProcessor.log().debug("updateInterface: reparenting interface " + addrString + " under node: " + node.getNodeId() + " from existing node: " + existingNodeId);
                            }
                            RescanProcessor.reparentInterface(dbc, addr, index, node.getNodeId(), existingNodeId);
                            RescanProcessor.createInterfaceReparentedEvent(node, existingNodeId, addr);
                        }
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug("updateInterface: interface " + ifaddrString + " is added to node: " + node.getNodeId() + " by reparenting from existing " + "node: " + existingNodeId);
                        }
                        dbIpIfEntry = DbIpInterfaceEntry.get(dbc, node.getNodeId(), ifaddr);
                        reparentFlag = true;
                        RescanProcessor.deleteDuplicateNode(dbc, suspectNodeEntry);
                        RescanProcessor.createDuplicateNodeDeletedEvent(suspectNodeEntry);
                    }
                }
                catch (SQLException e) {
                    RescanProcessor.log().error("SQLException while updating interface: " + ifaddrString + " on nodeid: " + node.getNodeId());
                    throw e;
                }
                finally {
                    d.cleanUp();
                }
            }
        }
        if (dbIpIfEntry == null) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateInterface: interface " + ifaddr + " ifIndex " + ifIndex + " not in database under nodeid " + node.getNodeId() + ", creating new interface object.");
            }
            if (ifIndex == -1 && !doesSnmp) {
                dbIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr);
            } else {
                dbIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr, ifIndex);
                dbIpIfEntry.setIfIndex(ifIndex);
            }
            if (RescanProcessor.isDuplicateInterface(dbc, ifaddr, node.getNodeId())) {
                this.m_eventList.add(RescanProcessor.createDuplicateIpAddressEvent(dbIpIfEntry));
            }
            newIpIfEntry = true;
        }
        DbIpInterfaceEntry currIpIfEntry = RescanProcessor.getNewDbIpInterfaceEntry(node, snmpc, doesSnmp, ifaddr);
        if (doesSnmp && snmpc != null) {
            this.updateSnmpInfo(dbc, node, snmpc, currIpIfEntry.getIfAddress(), currIpIfEntry.getIfIndex());
        }
        this.updateInterfaceInfo(dbc, now, node, dbIpIfEntry, currIpIfEntry, newIpIfEntry, reparentFlag);
        this.updateServiceInfo(dbc, node, dbIpIfEntry, newIpIfEntry, protocols);
    }

    private static void deleteDuplicateNode(Connection dbc, DbNodeEntry duplicateNode) throws SQLException {
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            PreparedStatement ifStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_INTERFACE);
            d.watch((Object)ifStmt);
            PreparedStatement svcStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_SERVICES);
            d.watch((Object)svcStmt);
            PreparedStatement snmpStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_SNMPINTERFACE);
            d.watch((Object)snmpStmt);
            ifStmt.setInt(1, duplicateNode.getNodeId());
            svcStmt.setInt(1, duplicateNode.getNodeId());
            snmpStmt.setInt(1, duplicateNode.getNodeId());
            ifStmt.executeUpdate();
            svcStmt.executeUpdate();
            snmpStmt.executeUpdate();
            duplicateNode.setNodeType('D');
            duplicateNode.store(dbc);
        }
        catch (SQLException sqlE) {
            RescanProcessor.log().error("deleteDuplicateNode  SQLException while deleting duplicate node: " + duplicateNode.getNodeId());
            throw sqlE;
        }
        finally {
            d.cleanUp();
        }
    }

    private static boolean isDuplicateInterface(Connection dbc, InetAddress ifaddr, int nodeId) throws SQLException {
        boolean duplicate = false;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            stmt = dbc.prepareStatement(SQL_DB_RETRIEVE_OTHER_NODES);
            d.watch((Object)stmt);
            stmt.setString(1, InetAddressUtils.str((InetAddress)ifaddr));
            stmt.setInt(2, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                duplicate = true;
            }
            boolean bl = duplicate;
            return bl;
        }
        catch (SQLException sqlE) {
            RescanProcessor.log().error("isDuplicateInterface: SQLException while updating interface: " + InetAddressUtils.str((InetAddress)ifaddr) + " on nodeid: " + nodeId);
            throw sqlE;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInterfaceInfo(Connection dbc, Date now, DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, DbIpInterfaceEntry currIpIfEntry, boolean isNewIpEntry, boolean isReparented) throws SQLException {
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        DbIpInterfaceEntry originalIpIfEntry = DbIpInterfaceEntry.clone(dbIpIfEntry);
        dbIpIfEntry.setLastPoll(now);
        dbIpIfEntry.updateHostname(currIpIfEntry.getHostname());
        dbIpIfEntry.updateManagedState(currIpIfEntry.getManagedState());
        dbIpIfEntry.updateStatus(currIpIfEntry.getStatus());
        dbIpIfEntry.updatePrimaryState(currIpIfEntry.getPrimaryState());
        dbIpIfEntry.updateIfIndex(currIpIfEntry.getIfIndex());
        boolean ifIndexChangedFlag = false;
        boolean ipHostnameChangedFlag = false;
        if (dbIpIfEntry.hasIfIndexChanged()) {
            ifIndexChangedFlag = true;
        }
        if (dbIpIfEntry.hasHostnameChanged()) {
            ipHostnameChangedFlag = true;
        }
        dbIpIfEntry.store(dbc);
        if (isNewIpEntry && !isReparented) {
            RescanProcessor.createNodeGainedInterfaceEvent(dbIpIfEntry);
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateInterfaceInfo: ifIndex changed: " + ifIndexChangedFlag);
        }
        if (ifIndexChangedFlag) {
            this.m_eventList.add(RescanProcessor.createInterfaceIndexChangedEvent(dbIpIfEntry, originalIpIfEntry));
            this.m_ifIndexOnNodeChangedFlag = true;
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateInterfaceInfo: hostname changed: " + ipHostnameChangedFlag);
        }
        if (ipHostnameChangedFlag) {
            this.m_eventList.add(RescanProcessor.createIpHostNameChangedEvent(dbIpIfEntry, originalIpIfEntry));
        }
        if (isNewIpEntry) {
            Package ipPkg;
            boolean ipToBePolled = false;
            String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
            RescanProcessor.log().debug("updateInterfaceInfo: rebuilding PackageIpListMap for new interface " + ifaddrString);
            PollerConfigFactory.getInstance().rebuildPackageIpListMap();
            Package package_ = ipPkg = ifaddrString == null ? null : pollerCfgFactory.getFirstPackageMatch(ifaddrString);
            if (ipPkg != null) {
                ipToBePolled = true;
            }
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateInterfaceInfo: interface " + ifaddrString + " to be polled: " + ipToBePolled);
            }
            if (ipToBePolled) {
                DBUtils d = new DBUtils(RescanProcessor.class);
                try {
                    PreparedStatement stmt = dbc.prepareStatement(SQL_DB_UPDATE_ISMANAGED);
                    d.watch((Object)stmt);
                    stmt.setString(1, new String(new char[]{'M'}));
                    stmt.setLong(2, dbIpIfEntry.getNodeId());
                    stmt.setString(3, ifaddrString);
                    stmt.executeUpdate();
                    if (RescanProcessor.log().isDebugEnabled()) {
                        RescanProcessor.log().debug("updateInterfaceInfo: updated managed state for new interface " + ifaddrString + " on node " + dbIpIfEntry.getNodeId() + " to managed");
                    }
                }
                finally {
                    d.cleanUp();
                }
            }
        }
    }

    private static DbIpInterfaceEntry getNewDbIpInterfaceEntry(DbNodeEntry node, IfSnmpCollector snmpc, boolean doesSnmp, InetAddress ifaddr) {
        DbIpInterfaceEntry currIpIfEntry;
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        int ifIndex = -1;
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        if (doesSnmp) {
            if (snmpc != null && snmpc.hasIpAddrTable()) {
                ifIndex = snmpc.getIfIndex(ifaddr);
            }
            if (ifIndex == -1) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateInterfaceInfo: interface " + ifaddrString + " has no valid ifIndex. Assuming this is a " + "lame SNMP host with no ipAddrTable");
                }
                ifIndex = -100;
            }
            currIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr, ifIndex);
        } else {
            currIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr);
        }
        currIpIfEntry.setHostname(ifaddr.getHostName());
        Package ipPkg = null;
        if (cFactory.isAddressUnmanaged(ifaddr)) {
            currIpIfEntry.setManagedState('U');
        } else {
            boolean ipToBePolled = false;
            Package package_ = ipPkg = ifaddrString == null ? null : pollerCfgFactory.getFirstPackageMatch(ifaddrString);
            if (ipPkg != null) {
                ipToBePolled = true;
            }
            if (ipToBePolled) {
                currIpIfEntry.setManagedState('M');
            } else {
                currIpIfEntry.setManagedState('N');
            }
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateInterfaceInfo: interface " + ifaddrString + " to be polled = " + ipToBePolled);
            }
        }
        if (doesSnmp && snmpc != null && snmpc.hasIpAddrTable()) {
            if (ifIndex != -1) {
                if (snmpc.hasIfTable()) {
                    int status = snmpc.getAdminStatus(ifIndex);
                    currIpIfEntry.setStatus(status);
                }
            } else {
                RescanProcessor.log().debug("updateInterfaceInfo:  No ifIndex found for " + ifaddrString + ". Not eligible for primary SNMP interface");
            }
            currIpIfEntry.setPrimaryState('N');
        } else if (doesSnmp) {
            currIpIfEntry.setPrimaryState('N');
        }
        return currIpIfEntry;
    }

    private void updateServiceInfo(Connection dbc, DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, boolean isNewIpEntry, List<IfCollector.SupportedProtocol> protocols) throws SQLException {
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        Package ipPkg = null;
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        DbIfServiceEntry[] dbSupportedServices = dbIpIfEntry.getServices(dbc);
        int ifIndex = dbIpIfEntry.getIfIndex();
        if (RescanProcessor.log().isDebugEnabled()) {
            if (ifIndex == -1) {
                RescanProcessor.log().debug("updateServiceInfo: Retrieving interface's service list from database for host " + dbIpIfEntry.getHostname());
            } else {
                RescanProcessor.log().debug("updateServiceInfo: Retrieving interface's service list from database for host " + dbIpIfEntry.getHostname() + " ifindex " + ifIndex);
            }
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateServiceInfo: Checking for new services on host " + dbIpIfEntry.getHostname());
        }
        for (IfCollector.SupportedProtocol p : protocols) {
            Integer sid = this.m_capsdDbSyncer.getServiceId(p.getProtocolName());
            boolean found = false;
            for (int i = 0; i < dbSupportedServices.length && !found; ++i) {
                if (dbSupportedServices[i].getServiceId() != ((Number)sid).intValue()) continue;
                found = true;
            }
            if (!found) {
                DbIfServiceEntry ifSvcEntry = DbIfServiceEntry.create(node.getNodeId(), ifaddr, sid);
                String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
                if (cFactory.isAddressUnmanaged(ifaddr)) {
                    ifSvcEntry.setStatus('U');
                } else {
                    Package package_ = ipPkg = ifaddrString == null ? null : pollerCfgFactory.getFirstPackageMatch(ifaddrString);
                    if (ipPkg == null) {
                        ifSvcEntry.setStatus('N');
                    } else if (RescanProcessor.isServicePolledLocally(ifaddrString, p.getProtocolName(), ipPkg)) {
                        ifSvcEntry.setStatus('A');
                    } else if (RescanProcessor.isServicePolled(ifaddrString, p.getProtocolName(), ipPkg)) {
                        ifSvcEntry.setStatus('X');
                    } else {
                        ifSvcEntry.setStatus('N');
                    }
                }
                if (p.getQualifiers() != null && p.getQualifiers().get("port") != null) {
                    try {
                        Integer port = (Integer)p.getQualifiers().get("port");
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug("updateServiceInfo: got a port qualifier: " + port + " for service: " + p.getProtocolName());
                        }
                        ifSvcEntry.setQualifier(port.toString());
                    }
                    catch (ClassCastException ccE) {
                        // empty catch block
                    }
                }
                ifSvcEntry.setSource('P');
                ifSvcEntry.setNotify('Y');
                if (ifIndex != -1) {
                    ifSvcEntry.setIfIndex(ifIndex);
                }
                ifSvcEntry.store();
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateIfServices: update service: " + p.getProtocolName() + " for interface:" + ifaddrString + " on node:" + node.getNodeId());
                }
                this.m_eventList.add(RescanProcessor.createNodeGainedServiceEvent(node, dbIpIfEntry, p.getProtocolName()));
                if (!isNewIpEntry && p.getProtocolName().equalsIgnoreCase("SNMP")) {
                    this.m_eventList.add(RescanProcessor.createInterfaceSupportsSNMPEvent(dbIpIfEntry));
                }
            }
            dbSupportedServices = dbIpIfEntry.getServices(dbc);
        }
        if (this.m_forceRescan) {
            this.updateServicesOnForcedRescan(node, dbIpIfEntry, dbSupportedServices);
        }
    }

    private static boolean isServicePolled(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !(svcToBePolled = PollerConfigFactory.getInstance().isPolled(svcName, ipPkg))) {
            svcToBePolled = PollerConfigFactory.getInstance().isPolled(ifAddr, svcName);
        }
        return svcToBePolled;
    }

    private static boolean isServicePolledLocally(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !ipPkg.getRemote() && !(svcToBePolled = PollerConfigFactory.getInstance().isPolled(svcName, ipPkg))) {
            svcToBePolled = PollerConfigFactory.getInstance().isPolledLocally(ifAddr, svcName);
        }
        return svcToBePolled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServicesOnForcedRescan(DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, DbIfServiceEntry[] dbSupportedServices) throws SQLException {
        Integer id;
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        Package ipPkg = null;
        boolean ipToBePolled = false;
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        Package package_ = ipPkg = ifaddrString == null ? null : pollerCfgFactory.getFirstPackageMatch(ifaddrString);
        if (ipPkg != null) {
            ipToBePolled = true;
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("updateServicesOnForcedRescan: Checking status of existing services on host " + ifaddr);
        }
        Connection ctest = null;
        ResultSet rs = null;
        HashMap<Integer, String> serviceNames = new HashMap<Integer, String>();
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            ctest = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)ctest);
            PreparedStatement loadStmt = ctest.prepareStatement(SQL_RETRIEVE_SERVICE_IDS);
            d.watch((Object)loadStmt);
            rs = loadStmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                id = new Integer(rs.getInt(1));
                String name = rs.getString(2);
                serviceNames.put(id, name);
            }
        }
        catch (Throwable t) {
            RescanProcessor.log().error("Error reading services table", t);
        }
        finally {
            d.cleanUp();
        }
        for (int i = 0; i < dbSupportedServices.length; ++i) {
            id = dbSupportedServices[i].getServiceId();
            String sn = ((String)serviceNames.get(id)).toString();
            DbIfServiceEntry ifSvcEntry = DbIfServiceEntry.get(node.getNodeId(), ifaddr, dbSupportedServices[i].getServiceId());
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateServicesOnForcedRescan: old status for nodeId " + node.getNodeId() + ", ifaddr " + ifaddr + ", serviceId " + dbSupportedServices[i].getServiceId() + " = " + ifSvcEntry.getStatus());
            }
            boolean svcChangeToActive = false;
            boolean svcChangeToNotPolled = false;
            boolean svcChangeToForced = false;
            if (!cFactory.isAddressUnmanaged(ifaddr)) {
                boolean svcToBePolled = false;
                if (ipToBePolled) {
                    if (ipPkg == null) {
                        ipPkg = pollerCfgFactory.getFirstPackageMatch(ifaddrString);
                    }
                    if (ipPkg != null) {
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug("updateServicesOnForcedRescan: Is service to be polled for package = " + ipPkg.getName() + ", service = " + sn);
                        }
                        if (!(svcToBePolled = pollerCfgFactory.isPolled(sn, ipPkg))) {
                            if (RescanProcessor.log().isDebugEnabled()) {
                                RescanProcessor.log().debug("updateServicesOnForcedRescan: Is service to be polled for ifaddr = " + ifaddrString + ", service = " + sn);
                            }
                            svcToBePolled = pollerCfgFactory.isPolled(ifaddrString, sn);
                        }
                        if (!svcToBePolled) {
                            RescanProcessor.log().debug("updateServicesOnForcedRescan: Service not to be polled");
                        }
                    } else {
                        RescanProcessor.log().debug("updateServicesOnForcedRescan: No poller package found");
                    }
                } else {
                    RescanProcessor.log().debug("updateServicesOnForcedRescan: Service not polled because interface is not polled");
                }
                if (ifSvcEntry.getStatus() == 'F') {
                    if (svcToBePolled) {
                        RescanProcessor.log().debug("updateServicesOnForcedRescan: status = FORCED. No action taken.");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        RescanProcessor.log().debug("updateServicesOnForcedRescan: status = FORCED. Changed to NOT_POLLED");
                    }
                } else if (ifSvcEntry.getStatus() == 'S') {
                    if (svcToBePolled) {
                        ifSvcEntry.updateStatus('F');
                        svcChangeToForced = true;
                        RescanProcessor.log().debug("updateServicesOnForcedRescan: status = SUSPEND. Changed to FORCED");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        RescanProcessor.log().debug("updateServicesOnForcedRescan: status = SUSPEND. Changed to NOT_POLLED");
                    }
                } else if (ifSvcEntry.getStatus() == 'R') {
                    if (svcToBePolled) {
                        ifSvcEntry.updateStatus('A');
                        svcChangeToActive = true;
                        RescanProcessor.log().debug("updateServicesOnForcedRescan: status = RESUME. Changed to ACTIVE");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        RescanProcessor.log().debug("updateServicesOnForcedRescan: status = RESUME. Changed to NOT_POLLED");
                    }
                } else if (svcToBePolled && ifSvcEntry.getStatus() != 'A') {
                    ifSvcEntry.updateStatus('A');
                    svcChangeToActive = true;
                    RescanProcessor.log().debug("updateServicesOnForcedRescan: New status = ACTIVE");
                } else if (!svcToBePolled && ifSvcEntry.getStatus() == 'A') {
                    ifSvcEntry.updateStatus('N');
                    svcChangeToNotPolled = true;
                    RescanProcessor.log().debug("updateServicesOnForcedRescan: New status = NOT_POLLED");
                } else {
                    RescanProcessor.log().debug("updateServicesOnForcedRescan: Status Unchanged");
                }
            }
            if (svcChangeToActive) {
                ifSvcEntry.store();
                this.m_eventList.add(RescanProcessor.createResumePollingServiceEvent(node, dbIpIfEntry, sn));
                continue;
            }
            if (!svcChangeToNotPolled && !svcChangeToForced) continue;
            ifSvcEntry.store();
            this.m_eventList.add(RescanProcessor.createSuspendPollingServiceEvent(node, dbIpIfEntry, sn));
        }
    }

    private void updateSnmpInfo(Connection dbc, DbNodeEntry node, IfSnmpCollector snmpc, InetAddress ifaddr, int ifIndex) throws SQLException {
        if (snmpc != null && !snmpc.failed() && ifIndex != -1) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateSnmpInfo: updating SNMP interface for nodeId/ifIndex=" + node.getNodeId() + "/" + ifIndex);
            }
            boolean newSnmpIfTableEntry = false;
            DbSnmpInterfaceEntry dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex);
            if (dbSnmpIfEntry == null) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateSnmpInfo: SNMP interface index " + ifIndex + " not in database, creating new interface " + "object.");
                }
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
                newSnmpIfTableEntry = true;
            }
            DbSnmpInterfaceEntry currSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            IfTable ift = snmpc.getIfTable();
            IfTableEntry ifte = null;
            for (IfTableEntry current : ift) {
                Integer sint = current.getIfIndex();
                if (sint == null || ifIndex != sint) continue;
                ifte = current;
                break;
            }
            if (ifte == null && ifIndex == -100) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateSnmpInfo: interface " + InetAddressUtils.str((InetAddress)snmpc.getCollectorTargetAddress()) + " appears to be a lame SNMP host");
                }
            } else if (ifte != null) {
                String ifAlias;
                Long speed;
                InetAddress[] aaddrs = snmpc.getIfAddressAndMask(ifIndex);
                if (aaddrs == null) {
                    currSnmpIfEntry.setCollect("N");
                } else {
                    currSnmpIfEntry.setCollect("C");
                    if (aaddrs[1] != null) {
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug("updateSnmpInfo: interface " + InetAddressUtils.str((InetAddress)aaddrs[0]) + " has netmask: " + InetAddressUtils.str((InetAddress)aaddrs[1]));
                        }
                        currSnmpIfEntry.setNetmask(aaddrs[1]);
                    }
                }
                Integer sint = ifte.getIfType();
                currSnmpIfEntry.setType(sint);
                String str = ifte.getIfDescr();
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateSnmpInfo: " + ifaddr + " has ifDescription: " + str);
                }
                if (str != null && str.length() > 0) {
                    currSnmpIfEntry.setDescription(str);
                }
                String physAddr = ifte.getPhysAddr();
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateSnmpInfo: " + ifaddr + " has phys address: -" + physAddr + "-");
                }
                if (physAddr != null && physAddr.length() == 12) {
                    currSnmpIfEntry.setPhysicalAddress(physAddr);
                }
                currSnmpIfEntry.setSpeed((speed = snmpc.getInterfaceSpeed(ifIndex)) == null ? 10000000L : speed);
                sint = ifte.getIfAdminStatus();
                currSnmpIfEntry.setAdminStatus(sint == null ? 0 : sint);
                sint = ifte.getIfOperStatus();
                currSnmpIfEntry.setOperationalStatus(sint == null ? 0 : sint);
                String ifName = snmpc.getIfName(ifIndex);
                if (ifName != null && ifName.length() > 0) {
                    currSnmpIfEntry.setName(ifName);
                }
                if ((ifAlias = snmpc.getIfAlias(ifIndex)) != null) {
                    currSnmpIfEntry.setAlias(ifAlias);
                } else {
                    currSnmpIfEntry.setAlias("");
                }
            }
            dbSnmpIfEntry.updateNetmask(currSnmpIfEntry.getNetmask());
            dbSnmpIfEntry.updatePhysicalAddress(currSnmpIfEntry.getPhysicalAddress());
            dbSnmpIfEntry.updateDescription(currSnmpIfEntry.getDescription());
            dbSnmpIfEntry.updateName(currSnmpIfEntry.getName());
            dbSnmpIfEntry.updateType(currSnmpIfEntry.getType());
            dbSnmpIfEntry.updateSpeed(currSnmpIfEntry.getSpeed());
            dbSnmpIfEntry.updateAdminStatus(currSnmpIfEntry.getAdminStatus());
            dbSnmpIfEntry.updateOperationalStatus(currSnmpIfEntry.getOperationalStatus());
            dbSnmpIfEntry.updateAlias(currSnmpIfEntry.getAlias());
            dbSnmpIfEntry.updateCollect(currSnmpIfEntry.getCollect());
            if (!this.m_snmpIfTableChangedFlag && newSnmpIfTableEntry || dbSnmpIfEntry.hasTypeChanged() || dbSnmpIfEntry.hasNameChanged() || dbSnmpIfEntry.hasDescriptionChanged() || dbSnmpIfEntry.hasPhysicalAddressChanged() || dbSnmpIfEntry.hasAliasChanged()) {
                this.m_snmpIfTableChangedFlag = true;
            }
            dbSnmpIfEntry.store(dbc);
        } else if (snmpc != null && snmpc.hasIpAddrTable() && ifIndex != -1) {
            DbSnmpInterfaceEntry dbSnmpIfEntry;
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateSnmpInfo: updating SNMP interface for nodeId/ifIndex/ipAddr=" + node.getNodeId() + "/" + ifIndex + "/" + ifaddr + " based on ipAddrTable only - No ifTable " + "available");
            }
            if ((dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex)) == null) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateSnmpInfo: SNMP interface index " + ifIndex + " not in database, creating new interface " + "object.");
                }
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            }
            DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            dbSnmpIfEntry.store(dbc);
        } else if (snmpc != null) {
            DbSnmpInterfaceEntry dbSnmpIfEntry;
            ifIndex = -100;
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updateSnmpInfo: updating SNMP interface for nodeId/ipAddr=" + node.getNodeId() + "/" + ifaddr + " based on ip address only - No ipAddrTable " + "available");
            }
            if ((dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex)) == null) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("updateSnmpInfo: SNMP interface index " + ifIndex + " not in database, creating new interface " + "object.");
                }
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            }
            DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            dbSnmpIfEntry.store(dbc);
        }
    }

    private static void reparentInterface(Connection dbc, InetAddress ifAddr, int ifIndex, int newNodeId, int oldNodeId) throws SQLException {
        String ipaddr = InetAddressUtils.str((InetAddress)ifAddr);
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            ResultSet rs;
            PreparedStatement ifLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE_LOOKUP);
            d.watch((Object)ifLookupStmt);
            PreparedStatement ifDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE_DELETE);
            d.watch((Object)ifDeleteStmt);
            PreparedStatement ipInterfaceStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE);
            d.watch((Object)ipInterfaceStmt);
            PreparedStatement snmpIfLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_IF_LOOKUP);
            d.watch((Object)snmpIfLookupStmt);
            PreparedStatement snmpIfDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_IF_DELETE);
            d.watch((Object)snmpIfDeleteStmt);
            PreparedStatement snmpInterfaceStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_INTERFACE);
            d.watch((Object)snmpInterfaceStmt);
            PreparedStatement ifServicesLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES_LOOKUP);
            d.watch((Object)ifServicesLookupStmt);
            PreparedStatement ifServicesDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES_DELETE);
            d.watch((Object)ifServicesDeleteStmt);
            PreparedStatement ifServicesStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES);
            d.watch((Object)ifServicesStmt);
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("reparentInterface: reparenting address/ifIndex/nodeID: " + ipaddr + "/" + ifIndex + "/" + newNodeId);
            }
            if (ifIndex < 1) {
                RescanProcessor.log().debug("reparentInterface: don't have a valid ifIndex, skipping snmpInterface table reparenting.");
            } else {
                boolean alreadyExists = false;
                snmpIfLookupStmt.setInt(1, newNodeId);
                snmpIfLookupStmt.setInt(2, ifIndex);
                rs = snmpIfLookupStmt.executeQuery();
                d.watch((Object)rs);
                if (rs.next()) {
                    if (RescanProcessor.log().isDebugEnabled()) {
                        RescanProcessor.log().debug("reparentInterface: interface with ifindex " + ifIndex + " already exists under new node " + newNodeId + " in snmpinterface table, deleting from under old node " + oldNodeId);
                    }
                    alreadyExists = true;
                    snmpIfDeleteStmt.setInt(1, oldNodeId);
                    snmpIfDeleteStmt.setInt(2, ifIndex);
                    snmpIfDeleteStmt.executeUpdate();
                }
                if (!alreadyExists) {
                    if (RescanProcessor.log().isDebugEnabled()) {
                        RescanProcessor.log().debug("reparentInterface: interface with ifindex " + ifIndex + " does not yet exist under new node " + newNodeId + " in snmpinterface table, reparenting.");
                    }
                    snmpInterfaceStmt.setInt(1, newNodeId);
                    snmpInterfaceStmt.setInt(2, oldNodeId);
                    snmpInterfaceStmt.setInt(3, ifIndex);
                    snmpInterfaceStmt.executeUpdate();
                }
            }
            boolean ifAlreadyExists = false;
            ifLookupStmt.setInt(1, newNodeId);
            ifLookupStmt.setString(2, ipaddr);
            rs = ifLookupStmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("reparentInterface: interface with ifindex " + ifIndex + " already exists under new node " + newNodeId + " in ipinterface table, deleting from under old node " + oldNodeId);
                }
                ifAlreadyExists = true;
                ifDeleteStmt.setInt(1, oldNodeId);
                ifDeleteStmt.setString(2, ipaddr);
                ifDeleteStmt.executeUpdate();
            }
            if (!ifAlreadyExists) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("reparentInterface: interface with ifindex " + ifIndex + " does not yet exist under new node " + newNodeId + " in ipinterface table, reparenting.");
                }
                ipInterfaceStmt.setInt(1, newNodeId);
                ipInterfaceStmt.setInt(2, oldNodeId);
                ipInterfaceStmt.setString(3, ipaddr);
                ipInterfaceStmt.executeUpdate();
            }
            boolean ifsAlreadyExists = false;
            ifServicesLookupStmt.setInt(1, newNodeId);
            ifServicesLookupStmt.setString(2, ipaddr);
            ifServicesLookupStmt.setInt(3, ifIndex);
            rs = ifServicesLookupStmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("reparentInterface: interface with ifindex " + ifIndex + " already exists under new node " + newNodeId + " in ifservices table, deleting from under old node " + oldNodeId);
                }
                ifsAlreadyExists = true;
                ifServicesDeleteStmt.setInt(1, oldNodeId);
                ifServicesDeleteStmt.setString(2, ipaddr);
                ifServicesDeleteStmt.executeUpdate();
            }
            if (!ifsAlreadyExists) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("reparentInterface: interface with ifindex " + ifIndex + " does not yet exist under new node " + newNodeId + " in ifservices table, reparenting.");
                }
                ifServicesStmt.setInt(1, newNodeId);
                ifServicesStmt.setInt(2, oldNodeId);
                ifServicesStmt.setString(3, ipaddr);
                ifServicesStmt.executeUpdate();
            }
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("reparentInterface: reparented " + ipaddr + " : ifIndex: " + ifIndex + " : oldNodeID: " + oldNodeId + " newNodeID: " + newNodeId);
            }
        }
        catch (SQLException sqlE) {
            RescanProcessor.log().error("SQLException while reparenting addr/ifindex/nodeid " + ipaddr + "/" + ifIndex + "/" + oldNodeId);
            throw sqlE;
        }
        finally {
            d.cleanUp();
        }
    }

    private static List<InetAddress> buildLBSnmpAddressList(Map<String, IfCollector> collectorMap, IfSnmpCollector snmpc) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (snmpc == null) {
            RescanProcessor.log().debug("buildLBSnmpAddressList: no SNMP info available...");
            return addresses;
        }
        if (!snmpc.hasIfTable()) {
            RescanProcessor.log().debug("buildLBSnmpAddressList: no SNMP ifTable available...");
            return addresses;
        }
        Collection<IfCollector> values = collectorMap.values();
        for (IfCollector ifc : values) {
            InetAddress ifaddr = ifc.getTarget();
            if (!addresses.contains(ifaddr) && SuspectEventProcessor.supportsSnmp(ifc.getSupportedProtocols()) && SuspectEventProcessor.hasIfIndex(ifaddr, snmpc) && SuspectEventProcessor.getIfType(ifaddr, snmpc) == 24) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("buildLBSnmpAddressList: adding target interface " + InetAddressUtils.str((InetAddress)ifaddr) + " temporarily marked as primary!");
                }
                addresses.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (InetAddress xifaddr : subTargets.keySet()) {
                if (addresses.contains(xifaddr) || !SuspectEventProcessor.supportsSnmp(subTargets.get(xifaddr)) || !SuspectEventProcessor.hasIfIndex(xifaddr, snmpc) || SuspectEventProcessor.getIfType(xifaddr, snmpc) != 24) continue;
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("buildLBSnmpAddressList: adding subtarget interface " + InetAddressUtils.str((InetAddress)xifaddr) + " temporarily marked as primary!");
                }
                addresses.add(xifaddr);
            }
        }
        return addresses;
    }

    private static List<InetAddress> buildSnmpAddressList(Map<String, IfCollector> collectorMap, IfSnmpCollector snmpc) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (snmpc == null) {
            RescanProcessor.log().debug("buildSnmpAddressList: no SNMP info available...");
            return addresses;
        }
        Collection<IfCollector> values = collectorMap.values();
        for (IfCollector ifc : values) {
            InetAddress ifaddr = ifc.getTarget();
            if (!addresses.contains(ifaddr) && SuspectEventProcessor.supportsSnmp(ifc.getSupportedProtocols()) && SuspectEventProcessor.hasIfIndex(ifaddr, snmpc)) {
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("buildSnmpAddressList: adding target interface " + InetAddressUtils.str((InetAddress)ifaddr) + " temporarily marked as primary!");
                }
                addresses.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (InetAddress xifaddr : subTargets.keySet()) {
                if (addresses.contains(xifaddr) || !SuspectEventProcessor.supportsSnmp(subTargets.get(xifaddr)) || !SuspectEventProcessor.hasIfIndex(xifaddr, snmpc)) continue;
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("buildSnmpAddressList: adding subtarget interface " + InetAddressUtils.str((InetAddress)xifaddr) + " temporarily marked as primary!");
                }
                addresses.add(xifaddr);
            }
        }
        return addresses;
    }

    private static InetAddress determinePrimaryIpInterface(Map<String, IfCollector> collectorMap) {
        Collection<IfCollector> values = collectorMap.values();
        Iterator<IfCollector> iter = values.iterator();
        InetAddress primaryIf = null;
        while (iter.hasNext()) {
            IfCollector ifc = iter.next();
            InetAddress currIf2 = ifc.getTarget();
            if (primaryIf == null) {
                primaryIf = currIf2;
                continue;
            }
            primaryIf = SuspectEventProcessor.compareAndSelectPrimary(currIf2, primaryIf);
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (InetAddress currIf2 : subTargets.keySet()) {
                primaryIf = SuspectEventProcessor.compareAndSelectPrimary(currIf2, primaryIf);
            }
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            if (primaryIf != null) {
                RescanProcessor.log().debug("determinePrimaryIpInterface: selected primary interface: " + InetAddressUtils.str((InetAddress)primaryIf));
            } else {
                RescanProcessor.log().debug("determinePrimaryIpInterface: no primary interface found");
            }
        }
        return primaryIf;
    }

    private static void setNodeLabelAndSmbInfo(Map<String, IfCollector> collectorMap, DbNodeEntry dbNodeEntry, DbNodeEntry currNodeEntry, InetAddress currPrimarySnmpIf) {
        IfSmbCollector smbc;
        Collection<IfCollector> values;
        boolean labelSet = false;
        InetAddress primaryIf = null;
        if (!labelSet) {
            primaryIf = currPrimarySnmpIf != null ? currPrimarySnmpIf : RescanProcessor.determinePrimaryIpInterface(collectorMap);
            if (primaryIf == null) {
                RescanProcessor.log().error("setNodeLabelAndSmbInfo: failed to find primary interface...");
            } else {
                String hostName = primaryIf.getHostName();
                if (!hostName.equals(InetAddressUtils.str((InetAddress)primaryIf))) {
                    labelSet = true;
                    currNodeEntry.setLabel(hostName);
                    currNodeEntry.setLabelSource('H');
                }
            }
        }
        IfSmbCollector savedSmbcRef = null;
        if (dbNodeEntry.getNetBIOSName() != null) {
            values = collectorMap.values();
            Iterator<IfCollector> iter = values.iterator();
            while (iter.hasNext() && !labelSet) {
                IfCollector ifc = iter.next();
                smbc = ifc.getSmbCollector();
                if (smbc == null || smbc.getNbtName() == null) continue;
                savedSmbcRef = smbc;
                String netbiosName = smbc.getNbtName().toUpperCase();
                if (!netbiosName.equals(dbNodeEntry.getNetBIOSName())) continue;
                labelSet = true;
                currNodeEntry.setLabel(netbiosName);
                currNodeEntry.setLabelSource('N');
                currNodeEntry.setNetBIOSName(netbiosName);
                if (smbc.getDomainName() == null) continue;
                currNodeEntry.setDomainName(smbc.getDomainName());
            }
        } else {
            values = collectorMap.values();
            for (IfCollector ifc : values) {
                smbc = ifc.getSmbCollector();
                if (smbc == null || smbc.getNbtName() == null) continue;
                savedSmbcRef = smbc;
            }
        }
        if (!labelSet && savedSmbcRef != null) {
            labelSet = true;
            currNodeEntry.setLabel(savedSmbcRef.getNbtName());
            currNodeEntry.setLabelSource('N');
            currNodeEntry.setNetBIOSName(currNodeEntry.getLabel());
            if (savedSmbcRef.getDomainName() != null) {
                currNodeEntry.setDomainName(savedSmbcRef.getDomainName());
            }
        }
        if (!labelSet && currPrimarySnmpIf != null) {
            IfCollector ifc2;
            String currPrimarySnmpAddress = InetAddressUtils.str((InetAddress)currPrimarySnmpIf);
            IfCollector ifCollector = ifc2 = currPrimarySnmpAddress == null ? null : collectorMap.get(currPrimarySnmpAddress);
            if (ifc2 == null) {
                Collection<IfCollector> collectors = collectorMap.values();
                for (IfCollector ifc2 : collectors) {
                    if (ifc2.getSnmpCollector() != null) break;
                }
            }
            if (ifc2 == null || ifc2.getSnmpCollector() == null) {
                RescanProcessor.log().warn("setNodeLabelAndSmbInfo: primary SNMP interface set to " + currPrimarySnmpAddress + " but no SNMP collector found.");
            } else {
                IfSnmpCollector snmpc = ifc2.getSnmpCollector();
                SystemGroup sysgrp = snmpc.getSystemGroup();
                String str = sysgrp.getSysName();
                if (str != null && str.length() > 0) {
                    labelSet = true;
                    currNodeEntry.setLabel(str);
                    currNodeEntry.setLabelSource('S');
                }
            }
        }
        if (!labelSet) {
            if (primaryIf != null) {
                currNodeEntry.setLabel(InetAddressUtils.str((InetAddress)primaryIf));
                currNodeEntry.setLabelSource('A');
            } else {
                currNodeEntry.setLabel(dbNodeEntry.getLabel());
                currNodeEntry.setLabelSource(dbNodeEntry.getLabelSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNodeDeleted(Connection dbc, int nodeId) throws SQLException {
        boolean nodeDeleted = false;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            char nodeType;
            stmt = dbc.prepareStatement(SQL_DB_RETRIEVE_NODE_TYPE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            rs.next();
            String nodeTypeStr = rs.getString(1);
            if (!rs.wasNull() && (nodeType = nodeTypeStr.charAt(0)) == 'D') {
                nodeDeleted = true;
            }
        }
        finally {
            d.cleanUp();
        }
        return nodeDeleted;
    }

    private static boolean areDbInterfacesInSnmpCollection(DbIpInterfaceEntry[] dbInterfaces, IfSnmpCollector snmpc) {
        if (dbInterfaces == null || snmpc == null) {
            RescanProcessor.log().error("areDbInterfacesInSnmpCollection: empty dbInterfaces or IfSnmpCollector.");
            return false;
        }
        if (!snmpc.hasIpAddrTable()) {
            RescanProcessor.log().error("areDbInterfacesInSnmpCollection: SNMP Collector failed.");
            return false;
        }
        IpAddrTable ipAddrTable = null;
        if (snmpc.hasIpAddrTable()) {
            ipAddrTable = snmpc.getIpAddrTable();
        }
        if (ipAddrTable == null) {
            RescanProcessor.log().error("areDbInterfacesInSnmpCollection: null ipAddrTable in the SNMP collection");
            return false;
        }
        List<InetAddress> ipAddrList = ipAddrTable.getIpAddresses();
        for (DbIpInterfaceEntry dbInterface : dbInterfaces) {
            InetAddress ipaddr = dbInterface.getIfAddress();
            String ipaddrString = InetAddressUtils.str((InetAddress)ipaddr);
            if (ipaddrString == null || ipaddrString.equals("0.0.0.0") || ipaddr.isLoopbackAddress()) continue;
            boolean found = false;
            for (InetAddress addr : ipAddrList) {
                String addrString = InetAddressUtils.str((InetAddress)addr);
                if (addrString == null || addrString.equals("0.0.0.0") || addr.isLoopbackAddress() || !ipaddrString.equals(addrString)) continue;
                found = true;
                if (!RescanProcessor.log().isDebugEnabled()) break;
                RescanProcessor.log().debug("areDbInterfacesInSnmpCollection: found match for ipaddress: " + ipaddrString);
                break;
            }
            if (found) continue;
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("areDbInterfacesInSnmpCollection: ipaddress : " + ipaddrString + " not in the SNMP collection. SNMP collection may not be usable.");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object collector;
        DbIpInterfaceEntry[] dbInterfaces;
        DbNodeEntry dbNodeEntry = this.getNode();
        if (dbNodeEntry == null) {
            return;
        }
        if (dbNodeEntry.getForeignSource() != null) {
            RescanProcessor.log().info("Skipping rescan of node " + this.getNodeId() + " since it was imported with foreign source " + dbNodeEntry.getForeignSource());
            return;
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("start rescanning node: " + this.getNodeId());
        }
        if ((dbInterfaces = this.getInterfaces(dbNodeEntry)) == null) {
            RescanProcessor.log().debug("no interfaces found in the database to rescan for node: " + this.getNodeId());
            return;
        }
        boolean doesSnmp = true;
        IpAddrTable ipAddTable = null;
        List<InetAddress> prevAddrList = null;
        boolean snmpcAgree = false;
        boolean gotSnmpc = false;
        HashMap<String, IfCollector> collectorMap = new HashMap<String, IfCollector>();
        HashMap<String, Object> nonSnmpCollectorMap = new HashMap<String, Object>();
        HashSet<InetAddress> probedAddrs = new HashSet<InetAddress>();
        boolean gotSnmpCollection = false;
        DbIpInterfaceEntry oldPrimarySnmpInterface = DbNodeEntry.getPrimarySnmpInterface(dbInterfaces);
        if (oldPrimarySnmpInterface != null) {
            gotSnmpCollection = this.scanPrimarySnmpInterface(oldPrimarySnmpInterface, collectorMap, probedAddrs);
        }
        if (!gotSnmpCollection) {
            for (int i = 0; i < dbInterfaces.length; ++i) {
                RescanProcessor.log().info("run: Running collector for interface " + i + " of " + dbInterfaces.length);
                InetAddress ifaddr = dbInterfaces[i].getIfAddress();
                String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
                if (!RescanProcessor.scannableInterface(dbInterfaces, ifaddr)) {
                    RescanProcessor.log().debug("run: skipping scan of address: " + ifaddrString);
                    continue;
                }
                if (ifaddrString == null) {
                    RescanProcessor.log().debug("run: unable to scan inet address: " + ifaddr);
                    continue;
                }
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("running collection for " + ifaddrString);
                }
                collector = new IfCollector(this.m_pluginManager, ifaddr, true, probedAddrs);
                ((IfCollector)collector).run();
                IfSnmpCollector snmpc = ((IfCollector)collector).getSnmpCollector();
                if (snmpc != null) {
                    gotSnmpc = true;
                }
                if (snmpc != null && snmpc.hasIpAddrTable() && snmpc.getIfIndex(snmpc.getCollectorTargetAddress()) != -1) {
                    if (RescanProcessor.areDbInterfacesInSnmpCollection(dbInterfaces, snmpc)) {
                        collectorMap.put(ifaddrString, (IfCollector)collector);
                        gotSnmpCollection = true;
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug("SNMP data collected via " + ifaddrString);
                            RescanProcessor.log().debug("Adding " + ifaddrString + " to collectorMap for node: " + this.getNodeId());
                        }
                        snmpcAgree = false;
                        break;
                    }
                    if (ipAddTable == null) {
                        snmpcAgree = true;
                        collectorMap.put(ifaddrString, (IfCollector)collector);
                        ipAddTable = snmpc.getIpAddrTable();
                        prevAddrList = ipAddTable.getIpAddresses();
                        if (RescanProcessor.log().isDebugEnabled()) {
                            RescanProcessor.log().debug("SNMP data collected via " + ifaddrString + " does not agree with database.  " + "Tentatively adding to the " + "collectorMap and continuing");
                            for (InetAddress a : prevAddrList) {
                                RescanProcessor.log().debug("IP address in list = " + a);
                            }
                        }
                    } else if (ipAddTable != null && snmpcAgree) {
                        ipAddTable = snmpc.getIpAddrTable();
                        List<InetAddress> addrList = ipAddTable.getIpAddresses();
                        boolean listMatch = true;
                        String jstring = null;
                        String kstring = null;
                        Iterator<InetAddress> j = prevAddrList.iterator();
                        Iterator<InetAddress> k = addrList.iterator();
                        while (j.hasNext()) {
                            jstring = j.next().toString();
                            if (k.hasNext()) {
                                kstring = k.next().toString();
                                if (jstring.equals(kstring)) {
                                    if (!RescanProcessor.log().isDebugEnabled()) continue;
                                    RescanProcessor.log().debug(jstring + " = " + kstring);
                                    continue;
                                }
                                if (RescanProcessor.log().isDebugEnabled()) {
                                    RescanProcessor.log().debug(jstring + " != " + kstring);
                                }
                                listMatch = false;
                                continue;
                            }
                            listMatch = false;
                        }
                        if (k.hasNext()) {
                            listMatch = false;
                        }
                        if (listMatch) {
                            RescanProcessor.log().debug("Current and previous address lists match");
                        } else {
                            RescanProcessor.log().debug("Current and previous address lists DO NOT match");
                            snmpcAgree = false;
                        }
                        ((IfCollector)collector).deleteSnmpCollector();
                    }
                    if (snmpcAgree || !RescanProcessor.log().isDebugEnabled()) continue;
                    RescanProcessor.log().debug("SNMP data collected via " + ifaddrString + " does not agree with database or with " + "other interface(s) on this node.");
                    continue;
                }
                nonSnmpCollectorMap.put(ifaddrString, collector);
                if (!RescanProcessor.log().isDebugEnabled()) continue;
                RescanProcessor.log().debug("Adding " + ifaddrString + " to nonSnmpCollectorMap for node: " + this.getNodeId());
            }
        }
        if (!gotSnmpCollection && !snmpcAgree) {
            collectorMap = nonSnmpCollectorMap;
            if (nonSnmpCollectorMap.size() == 1 && gotSnmpc) {
                doesSnmp = true;
                if (RescanProcessor.log().isDebugEnabled()) {
                    RescanProcessor.log().debug("node " + this.getNodeId() + " appears to be a lame SNMP host... " + "Proceeding");
                }
            } else {
                doesSnmp = false;
                if (RescanProcessor.log().isDebugEnabled()) {
                    if (!gotSnmpc) {
                        RescanProcessor.log().debug("Could not collect SNMP data for node: " + this.getNodeId());
                    } else {
                        RescanProcessor.log().debug("Not using SNMP data for node: " + this.getNodeId() + ".  " + "Collection does not agree with database.");
                    }
                }
            }
        } else if (snmpcAgree) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("SNMP collection for node: " + this.getNodeId() + " does not agree with database, but there is no " + "conflict among the interfaces on this node which " + "respond to SNMP. Proceeding...");
            }
            this.m_eventList.add(RescanProcessor.createSnmpConflictsWithDbEvent(dbNodeEntry));
        }
        Date now = null;
        Connection dbc = null;
        boolean updateCompleted = false;
        try {
            RescanProcessor.log().debug("Waiting for capsd dbLock to process " + this.getNodeId());
            collector = Capsd.getDbSyncLock();
            synchronized (collector) {
                RescanProcessor.log().debug("Got capsd dbLock. processing " + this.getNodeId());
                dbc = DataSourceFactory.getInstance().getConnection();
                if (!RescanProcessor.isNodeDeleted(dbc, this.getNodeId())) {
                    now = new Date();
                    this.updateInterfaces(dbc, now, dbNodeEntry, collectorMap, doesSnmp);
                    if (doesSnmp) {
                        InetAddress oldPriIf = null;
                        if (oldPrimarySnmpInterface != null) {
                            oldPriIf = oldPrimarySnmpInterface.getIfAddress();
                        }
                        InetAddress newSnmpPrimaryIf = this.updatePrimarySnmpInterface(dbc, dbNodeEntry, collectorMap, oldPriIf);
                        this.updateNode(dbc, now, dbNodeEntry, newSnmpPrimaryIf, dbInterfaces, collectorMap);
                    }
                    updateCompleted = true;
                    this.m_eventList.add(RescanProcessor.createRescanCompletedEvent(dbNodeEntry));
                }
            }
        }
        catch (Throwable t) {
            RescanProcessor.log().error("Error updating records for node ID " + this.getNodeId() + ": " + t, t);
        }
        finally {
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (SQLException e) {
                RescanProcessor.log().error("Error closing connection: " + e, (Throwable)e);
            }
            Set<Integer> e = m_queuedRescanTracker;
            synchronized (e) {
                m_queuedRescanTracker.remove(this.getNodeId());
            }
        }
        if (updateCompleted) {
            for (Event event : this.m_eventList) {
                try {
                    EventIpcManagerFactory.getIpcManager().sendNow(event);
                }
                catch (Throwable t) {
                    RescanProcessor.log().warn("run: unexpected throwable exception caught while sending event: " + t, t);
                }
            }
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug((this.m_forceRescan ? "Forced r" : "R") + "escan " + "for node w/ nodeid " + this.getNodeId() + " completed.");
        }
    }

    protected static boolean scannableInterface(DbIpInterfaceEntry[] dbInterfaces, InetAddress ifaddr) {
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        if (ifaddrString == null) {
            return false;
        }
        boolean localHostAddress = ifaddr.isLoopbackAddress() && dbInterfaces.length > 1;
        boolean nonIpAddress = ifaddrString.equals("0.0.0.0");
        boolean scannable = !localHostAddress && !nonIpAddress;
        return scannable;
    }

    private int getNodeId() {
        return this.m_nodeId;
    }

    private boolean scanPrimarySnmpInterface(DbIpInterfaceEntry oldPrimarySnmpInterface, Map<String, IfCollector> collectorMap, Set<InetAddress> probedAddrs) {
        boolean gotSnmpCollection = false;
        InetAddress ifaddr = oldPrimarySnmpInterface.getIfAddress();
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        if (ifaddrString == null) {
            RescanProcessor.log().info("old primary SNMP interface has an invalid address: " + ifaddr);
            return false;
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("running collection for DB primary SNMP interface " + ifaddrString);
        }
        IfCollector collector = new IfCollector(this.m_pluginManager, ifaddr, true, probedAddrs);
        collector.run();
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        if (snmpc == null) {
            RescanProcessor.log().debug("SNMP Collector from DB primary SNMP interface is null");
        } else {
            gotSnmpCollection = true;
            collectorMap.put(ifaddrString, collector);
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("SNMP data collected from DB primary SNMP interface" + ifaddrString);
            }
            if (!snmpc.hasIfTable()) {
                RescanProcessor.log().debug("SNMP Collector has no IfTable");
            }
            if (!snmpc.hasIpAddrTable() || snmpc.getIfIndex(snmpc.getCollectorTargetAddress()) == -1) {
                RescanProcessor.log().debug("SNMP Collector has no IpAddrTable. Assume its a lame SNMP host.");
            }
        }
        return gotSnmpCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress updatePrimarySnmpInterface(Connection dbc, DbNodeEntry dbNodeEntry, Map<String, IfCollector> collectorMap, InetAddress oldPriIf) throws SQLException {
        boolean strict = true;
        CollectdConfigFactory.getInstance().rebuildPackageIpListMap();
        IfSnmpCollector snmpc = RescanProcessor.findSnmpCollector(collectorMap);
        List<InetAddress> snmpLBAddresses = RescanProcessor.buildLBSnmpAddressList(collectorMap, snmpc);
        List<InetAddress> snmpAddresses = RescanProcessor.buildSnmpAddressList(collectorMap, snmpc);
        for (InetAddress addr : snmpAddresses) {
            String addrString = InetAddressUtils.str((InetAddress)addr);
            if (!CollectdConfigFactory.getInstance().isServiceCollectionEnabled(addrString, "SNMP")) continue;
            DBUtils d = new DBUtils(RescanProcessor.class);
            try {
                PreparedStatement stmt = dbc.prepareStatement("UPDATE ipInterface SET isSnmpPrimary='S' WHERE nodeId=? AND ipAddr=? AND isManaged!='D'");
                d.watch((Object)stmt);
                stmt.setInt(1, dbNodeEntry.getNodeId());
                stmt.setString(2, addrString);
                stmt.executeUpdate();
                RescanProcessor.log().debug("updatePrimarySnmpInterface: updated " + addrString + " to secondary.");
            }
            finally {
                d.cleanUp();
            }
        }
        InetAddress newSnmpPrimaryIf = CapsdConfigFactory.getInstance().determinePrimarySnmpInterface(snmpLBAddresses, strict);
        String psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " loopback addresses";
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = CapsdConfigFactory.getInstance().determinePrimarySnmpInterface(snmpAddresses, strict);
            psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " addresses";
        }
        strict = false;
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = CapsdConfigFactory.getInstance().determinePrimarySnmpInterface(snmpLBAddresses, strict);
            psiType = "DB loopback addresses";
        }
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = CapsdConfigFactory.getInstance().determinePrimarySnmpInterface(snmpAddresses, strict);
            psiType = "DB addresses";
        }
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = snmpc.getCollectorTargetAddress();
            psiType = "SNMP collector target address";
        }
        if (newSnmpPrimaryIf != null) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("updatePrimarySnmpInterface: primary SNMP interface is: " + newSnmpPrimaryIf + ", selected from " + psiType);
            }
            SuspectEventProcessor.setPrimarySnmpInterface(dbc, dbNodeEntry, newSnmpPrimaryIf, oldPriIf);
        } else {
            RescanProcessor.log().debug("SuspectEventProcessor: Unable to determine a primary SNMP interface");
        }
        this.generateSnmpDataCollectionEvents(dbNodeEntry, oldPriIf, newSnmpPrimaryIf);
        return newSnmpPrimaryIf;
    }

    private static IfSnmpCollector findSnmpCollector(Map<String, IfCollector> collectorMap) {
        for (IfCollector collector : collectorMap.values()) {
            if (!collector.hasSnmpCollection()) continue;
            return collector.getSnmpCollector();
        }
        return null;
    }

    private DbIpInterfaceEntry[] getInterfaces(DbNodeEntry dbNodeEntry) {
        DbIpInterfaceEntry[] dbInterfaces = null;
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("retrieving managed interfaces for node: " + this.getNodeId());
        }
        try {
            dbInterfaces = this.m_forceRescan ? dbNodeEntry.getInterfaces() : dbNodeEntry.getManagedInterfaces();
        }
        catch (NullPointerException npE) {
            RescanProcessor.log().error("RescanProcessor: Null pointer when retrieving " + (this.m_forceRescan ? "" : "managed") + " interfaces for node " + this.getNodeId(), (Throwable)npE);
            RescanProcessor.log().error("Rescan failed for node w/ nodeid " + this.getNodeId());
        }
        catch (SQLException sqlE) {
            RescanProcessor.log().error("RescanProcessor: unable to load interface info for nodeId " + this.getNodeId() + " from the database.", (Throwable)sqlE);
            RescanProcessor.log().error("Rescan failed for node w/ nodeid " + this.getNodeId());
        }
        return dbInterfaces;
    }

    private DbNodeEntry getNode() {
        DbNodeEntry dbNodeEntry = null;
        try {
            dbNodeEntry = DbNodeEntry.get(this.getNodeId());
        }
        catch (SQLException e) {
            RescanProcessor.log().error("RescanProcessor: unable to load node info for nodeId " + this.getNodeId() + " from the database.", (Throwable)e);
            RescanProcessor.log().error("Rescan failed for node w/ nodeid " + this.getNodeId());
        }
        return dbNodeEntry;
    }

    private void generateSnmpDataCollectionEvents(DbNodeEntry nodeEntry, InetAddress oldPriIf, InetAddress primarySnmpIf) {
        boolean reInit = true;
        if (oldPriIf == null && primarySnmpIf != null) {
            reInit = false;
            RescanProcessor.log().debug("generateSnmpDataCollectionEvents: Either SNMP support was recently enabled on this node, or node doesn't support ipAddrTable MIB.");
            this.m_eventList.add(RescanProcessor.createPrimarySnmpInterfaceChangedEvent(nodeEntry.getNodeId(), primarySnmpIf, null));
        } else if (primarySnmpIf != null && !oldPriIf.equals(primarySnmpIf)) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("generateSnmpDataCollectionEvents: primary SNMP interface has changed.  Was: " + InetAddressUtils.str((InetAddress)oldPriIf) + " Is: " + InetAddressUtils.str((InetAddress)primarySnmpIf));
            }
            this.m_eventList.add(RescanProcessor.createPrimarySnmpInterfaceChangedEvent(nodeEntry.getNodeId(), primarySnmpIf, oldPriIf));
            reInit = false;
        }
        if (reInit && (this.m_ifIndexOnNodeChangedFlag || this.m_snmpIfTableChangedFlag)) {
            if (RescanProcessor.log().isDebugEnabled()) {
                RescanProcessor.log().debug("generateSnmpDataCollectionEvents: Generating reinitializeSnmpInterface event for interface " + InetAddressUtils.str((InetAddress)primarySnmpIf));
            }
            this.m_eventList.add(RescanProcessor.createReinitializePrimarySnmpInterfaceEvent(nodeEntry.getNodeId(), primarySnmpIf));
        }
    }

    private static EventBuilder eventBuilder(String uei) {
        return new EventBuilder(uei, "OpenNMS.Capsd").setHost(Capsd.getLocalHostAddress());
    }

    private static EventBuilder nodeEventBuilder(String uei, long nodeId) {
        return RescanProcessor.eventBuilder(uei).setNodeid(nodeId);
    }

    private static EventBuilder interfaceEventBuilder(String uei, long nodeId, String ipAddr) {
        return RescanProcessor.eventBuilder(uei).setNodeid(nodeId).setInterface(InetAddressUtils.addr((String)ipAddr));
    }

    private static EventBuilder serviceEventBuilder(String uei, long nodeId, String ipAddr, String svc) {
        return RescanProcessor.eventBuilder(uei).setNodeid(nodeId).setInterface(InetAddressUtils.addr((String)ipAddr)).setService(svc);
    }

    private static Event createNodeLabelChangedEvent(DbNodeEntry updatedEntry, DbNodeEntry originalEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createNodeLabelChangedEvent: nodeId: " + updatedEntry.getNodeId() + " oldLabel: '" + originalEntry.getLabel() + "' oldSource: '" + originalEntry.getLabelSource() + "' newLabel: '" + updatedEntry.getLabel() + "' newLabelSource: '" + updatedEntry.getLabelSource() + "'");
        }
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/nodes/nodeLabelChanged", updatedEntry.getNodeId());
        if (originalEntry.getLabel() != null) {
            bldr.addParam("oldNodeLabel", originalEntry.getLabel());
            bldr.addParam("oldNodeLabelSource", originalEntry.getLabelSource());
        }
        if (updatedEntry.getLabel() != null) {
            bldr.addParam("newNodeLabel", updatedEntry.getLabel());
            bldr.addParam("newNodeLabelSource", updatedEntry.getLabelSource());
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createNodeLabelChangedEvent: successfully created nodeLabelChanged event for nodeid: " + updatedEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createNodeInfoChangedEvent(DbNodeEntry updatedEntry, DbNodeEntry originalEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createNodeInfoChangedEvent: nodeId: " + updatedEntry.getNodeId());
        }
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/nodes/nodeInfoChanged", updatedEntry.getNodeId());
        if (updatedEntry.getSystemOID() != null) {
            bldr.addParam("nodesysoid", updatedEntry.getSystemOID());
        }
        if (updatedEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", updatedEntry.getSystemName());
        }
        if (updatedEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", updatedEntry.getSystemDescription());
        }
        if (updatedEntry.getSystemLocation() != null) {
            bldr.addParam("nodesyslocation", updatedEntry.getSystemLocation());
        }
        if (updatedEntry.getSystemContact() != null) {
            bldr.addParam("nodesyscontact", updatedEntry.getSystemContact());
        }
        if (updatedEntry.getNetBIOSName() != null) {
            bldr.addParam("nodenetbiosname", updatedEntry.getNetBIOSName());
        }
        if (updatedEntry.getDomainName() != null) {
            bldr.addParam("nodedomainname", updatedEntry.getDomainName());
        }
        if (updatedEntry.getOS() != null) {
            bldr.addParam("nodeoperatingsystem", updatedEntry.getOS());
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createNodeInfoChangedEvent: successfully created nodeInfoChanged event for nodeid: " + updatedEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createPrimarySnmpInterfaceChangedEvent(int nodeId, InetAddress newPrimaryIf, InetAddress oldPrimaryIf) {
        String oldPrimaryAddr = null;
        if (oldPrimaryIf != null) {
            oldPrimaryAddr = InetAddressUtils.str((InetAddress)oldPrimaryIf);
        }
        String newPrimaryAddr = null;
        if (newPrimaryIf != null) {
            newPrimaryAddr = InetAddressUtils.str((InetAddress)newPrimaryIf);
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createPrimarySnmpInterfaceChangedEvent: nodeId: " + nodeId + "oldPrimarySnmpIf: '" + oldPrimaryAddr + "' newPrimarySnmpIf: '" + newPrimaryAddr + "'");
        }
        EventBuilder bldr = RescanProcessor.serviceEventBuilder("uei.opennms.org/nodes/primarySnmpInterfaceChanged", nodeId, newPrimaryAddr, "SNMP");
        if (oldPrimaryAddr != null) {
            bldr.addParam("oldPrimarySnmpAddress", oldPrimaryAddr);
        }
        if (newPrimaryAddr != null) {
            bldr.addParam("newPrimarySnmpAddress", newPrimaryAddr);
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createPrimarySnmpInterfaceChangedEvent: successfully created primarySnmpInterfaceChanged event for nodeid: " + nodeId);
        }
        return bldr.getEvent();
    }

    private static Event createInterfaceIndexChangedEvent(DbIpInterfaceEntry updatedEntry, DbIpInterfaceEntry originalEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createInterfaceIndexChangedEvent: nodeId: " + updatedEntry.getNodeId() + " oldIfIndex: " + originalEntry.getIfIndex() + " newIfIndex: " + updatedEntry.getIfIndex());
        }
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/interfaceIndexChanged", updatedEntry.getNodeId(), InetAddressUtils.str((InetAddress)updatedEntry.getIfAddress()));
        bldr.addParam("oldIfIndex", originalEntry.getIfIndex());
        bldr.addParam("newIfIndex", updatedEntry.getIfIndex());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createInterfaceIndexChangedEvent: successfully created interfaceIndexChanged event for nodeid: " + updatedEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createIpHostNameChangedEvent(DbIpInterfaceEntry updatedEntry, DbIpInterfaceEntry originalEntry) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createIpHostNameChangedEvent: nodeId: " + updatedEntry.getNodeId() + " oldHostName: " + originalEntry.getHostname() + " newHostName: " + updatedEntry.getHostname());
        }
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/interfaceIPHostNameChanged", updatedEntry.getNodeId(), InetAddressUtils.str((InetAddress)updatedEntry.getIfAddress()));
        if (originalEntry.getHostname() != null) {
            bldr.addParam("oldiphostname", originalEntry.getHostname());
        }
        if (updatedEntry.getHostname() != null) {
            bldr.addParam("iphostname", updatedEntry.getHostname());
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createIpHostNameChangedEvent: successfully created ipHostNameChanged event for nodeid: " + updatedEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createInterfaceReparentedEvent(DbNodeEntry newNode, int oldNodeId, InetAddress reparentedIf) {
        String reparentedAddress = InetAddressUtils.str((InetAddress)reparentedIf);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createInterfaceReparentedEvent: ifAddr: " + reparentedAddress + " oldNodeId: " + oldNodeId + " newNodeId: " + newNode.getNodeId());
        }
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/interfaceReparented", newNode.getNodeId(), reparentedAddress);
        bldr.addParam("oldNodeID", oldNodeId);
        bldr.addParam("newNodeID", newNode.getNodeId());
        bldr.addParam("iphostname", reparentedIf.getHostName());
        if (newNode.getLabel() != null) {
            bldr.addParam("nodelabel", newNode.getLabel());
            bldr.addParam("nodelabelsource", newNode.getLabelSource());
        }
        if (newNode.getSystemName() != null) {
            bldr.addParam("nodesysname", newNode.getSystemName());
        }
        if (newNode.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", newNode.getSystemDescription());
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createInterfaceReparentedEvent: successfully created interfaceReparented event for nodeid/interface: " + newNode.getNodeId() + "/" + reparentedAddress);
        }
        return bldr.getEvent();
    }

    private static Event createDuplicateNodeDeletedEvent(DbNodeEntry deletedNode) {
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createDuplicateNodeDeletedEvent: delete nodeid: " + deletedNode.getNodeId());
        }
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/nodes/duplicateNodeDeleted", deletedNode.getNodeId());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createDuplicateNodeDeletedEvent: successfully created duplicateNodeDeleted event for nodeid: " + deletedNode.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createNodeGainedInterfaceEvent(DbIpInterfaceEntry ifEntry) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createNodeGainedInterfaceEvent: nodeId: " + ifEntry.getNodeId() + " interface: " + ifAddress);
        }
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/nodeGainedInterface", ifEntry.getNodeId(), ifAddress);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        bldr.addParam("method", "icmp");
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createNodeGainedInterfaceEvent: successfully created nodeGainedInterface event for nodeid: " + ifEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createDuplicateIpAddressEvent(DbIpInterfaceEntry ifEntry) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createDuplicateIpAddressEvent: nodeId: " + ifEntry.getNodeId() + " interface: " + ifAddress);
        }
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/internal/capsd/duplicateIPAddress", ifEntry.getNodeId(), ifAddress);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        bldr.addParam("method", "icmp");
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createDuplicateIpAddressEvent: successfully created duplicateIpAddress event for nodeid: " + ifEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createNodeGainedServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createNodeGainedServiceEvent: nodeId: " + ifEntry.getNodeId() + " interface: " + ifAddress + " service: " + svcName);
        }
        EventBuilder bldr = RescanProcessor.serviceEventBuilder("uei.opennms.org/nodes/nodeGainedService", ifEntry.getNodeId(), ifAddress, svcName);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createNodeGainedServiceEvent: successfully created nodeGainedService event for nodeid: " + ifEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createSuspendPollingServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        EventBuilder bldr = RescanProcessor.serviceEventBuilder("uei.opennms.org/internal/poller/suspendPollingService", ifEntry.getNodeId(), ifAddress, svcName);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("suspendPollingServiceEvent: Created suspendPollingService event for nodeid: " + ifEntry.getNodeId() + " interface: " + ifAddress + " service: " + svcName);
        }
        return bldr.getEvent();
    }

    private static Event createResumePollingServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        EventBuilder bldr = RescanProcessor.serviceEventBuilder("uei.opennms.org/internal/poller/resumePollingService", ifEntry.getNodeId(), ifAddress, svcName);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("resumePollingServiceEvent: Created resumePollingService event for nodeid: " + ifEntry.getNodeId() + " interface: " + ifAddress + " service: " + svcName);
        }
        return bldr.getEvent();
    }

    private static Event createSnmpConflictsWithDbEvent(DbNodeEntry nodeEntry) {
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/internal/capsd/snmpConflictsWithDb", nodeEntry.getNodeId());
        bldr.addParam("nodelabel", nodeEntry.getLabel() == null ? "" : nodeEntry.getLabel());
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("snmpConflictsWithDbEvent: Created snmpConflictsWithDbEvent for nodeid: " + nodeEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createRescanCompletedEvent(DbNodeEntry nodeEntry) {
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/internal/capsd/rescanCompleted", nodeEntry.getNodeId());
        bldr.addParam("nodelabel", nodeEntry.getLabel() == null ? "" : nodeEntry.getLabel());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("rescanCompletedEvent: Created rescanCompletedEvent for nodeid: " + nodeEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createInterfaceSupportsSNMPEvent(DbIpInterfaceEntry ifEntry) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createInterfaceSupportsSNMPEvent: nodeId: " + ifEntry.getNodeId() + " interface: " + ifAddress);
        }
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/internal/capsd/interfaceSupportsSNMP", ifEntry.getNodeId(), ifAddress);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("interfaceSupportsSNMPEvent: successfully created interfaceSupportsSNMPEvent event for nodeid: " + ifEntry.getNodeId());
        }
        return bldr.getEvent();
    }

    private static Event createReinitializePrimarySnmpInterfaceEvent(int nodeId, InetAddress primarySnmpIf) {
        String primaryAddress = InetAddressUtils.str((InetAddress)primarySnmpIf);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("reinitializePrimarySnmpInterface: nodeId: " + nodeId + " interface: " + primaryAddress);
        }
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", nodeId, primaryAddress);
        if (RescanProcessor.log().isDebugEnabled()) {
            RescanProcessor.log().debug("createReinitializePrimarySnmpInterfaceEvent: successfully created reinitializePrimarySnmpInterface event for interface: " + primaryAddress);
        }
        return bldr.getEvent();
    }

    public static synchronized void setQueuedRescansTracker(Set<Integer> queuedRescanTracker) {
        m_queuedRescanTracker = Collections.synchronizedSet(queuedRescanTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRescanQueuedForNode(Integer nodeId) {
        Set<Integer> set = m_queuedRescanTracker;
        synchronized (set) {
            return m_queuedRescanTracker.contains(nodeId);
        }
    }
}

