/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.netbios.NbtAddress;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.SmbUtils;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.capsd.SmbAuth;

final class IfSmbCollector
implements Runnable {
    private static final String SAMBA_MAC = "00:00:00:00:00:00";
    private final InetAddress m_target;
    private boolean m_isSamba;
    private String m_mac;
    private String m_domain;
    private NbtAddress m_addr;
    private NbtAddress[] m_allAddrs;
    private String[] m_shares;
    private final boolean m_hasExchange;

    private String toMacString(byte[] mac) {
        StringBuffer mbuf = new StringBuffer();
        for (int i = 0; i < mac.length; ++i) {
            mbuf.append(mac[i] >> 4 & 0xF).append(mac[i] & 0xF);
            if (i == 5) continue;
            mbuf.append(':');
        }
        return mbuf.toString();
    }

    IfSmbCollector(InetAddress target) {
        this.m_target = target;
        this.m_isSamba = false;
        this.m_mac = null;
        this.m_addr = null;
        this.m_domain = null;
        this.m_allAddrs = null;
        this.m_shares = null;
        this.m_hasExchange = false;
    }

    IfSmbCollector(InetAddress target, boolean hasExchange) {
        this.m_target = target;
        this.m_isSamba = false;
        this.m_mac = null;
        this.m_addr = null;
        this.m_domain = null;
        this.m_allAddrs = null;
        this.m_shares = null;
        this.m_hasExchange = hasExchange;
    }

    InetAddress getTarget() {
        return this.m_target;
    }

    boolean isSamba() {
        return this.m_isSamba;
    }

    String getMAC() {
        return this.m_mac;
    }

    NbtAddress getNbtAddress() {
        return this.m_addr;
    }

    String getNbtName() {
        if (this.m_addr != null) {
            return this.m_addr.getHostName().trim();
        }
        return null;
    }

    String getDomainName() {
        return this.m_domain;
    }

    NbtAddress[] getAllNbtAddresses() {
        return this.m_allAddrs;
    }

    String[] getShares() {
        return this.m_shares;
    }

    boolean hasExchange() {
        return this.m_hasExchange;
    }

    boolean containsCtrlChars(String nbName) {
        byte[] bytes = nbName.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 20) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        block29: {
            ThreadCategory log = ThreadCategory.getInstance(this.getClass());
            try {
                this.m_addr = NbtAddress.getByName((String)InetAddressUtils.str((InetAddress)this.m_target));
                if (this.m_addr.getHostName().equals(InetAddressUtils.str((InetAddress)this.m_target))) {
                    if (log.isDebugEnabled()) {
                        log.debug("IfSmbCollector: failed to retrieve SMB name for " + InetAddressUtils.str((InetAddress)this.m_target));
                    }
                    this.m_addr = null;
                }
            }
            catch (UnknownHostException e) {
                if (log.isDebugEnabled()) {
                    log.debug("IfSmbCollector: UnknownHostException: failed to retrieve SMB name, reason:" + e.getMessage());
                }
                this.m_addr = null;
            }
            if (this.m_addr != null && this.containsCtrlChars(this.m_addr.getHostName())) {
                log.warn("IfSmbCollector: Retrieved SMB name for address " + InetAddressUtils.str((InetAddress)this.m_target) + " contains control chars: '" + this.m_addr.getHostName() + "', discarding.");
                this.m_addr = null;
            }
            if (this.m_addr != null) {
                block28: {
                    block27: {
                        if (log.isDebugEnabled()) {
                            log.debug("IfSmbCollector: SMB name of " + InetAddressUtils.str((InetAddress)this.m_target) + " is: " + this.m_addr.getHostName());
                        }
                        try {
                            byte[] mac = this.m_addr.getMacAddress();
                            this.m_mac = this.toMacString(mac);
                            if (this.m_mac.equals(SAMBA_MAC)) {
                                this.m_isSamba = true;
                                this.m_mac = null;
                            }
                        }
                        catch (UnknownHostException e) {
                            if (!log.isDebugEnabled()) break block27;
                            log.debug("IfSmbCollector: failed to get MAC for " + InetAddressUtils.str((InetAddress)this.m_target) + " due to address failure", (Throwable)e);
                        }
                    }
                    try {
                        this.m_allAddrs = NbtAddress.getAllByAddress((NbtAddress)this.m_addr);
                        this.m_domain = SmbUtils.getAuthenticationDomainName(this.m_allAddrs, this.m_addr.getHostName());
                        if (log.isDebugEnabled()) {
                            log.debug("IfSmbCollector: domain name: '" + this.m_domain + "'");
                        }
                    }
                    catch (UnknownHostException e) {
                        if (!log.isDebugEnabled()) break block28;
                        log.debug("IfSmbCollector: failed to get all the addresses for the interface " + InetAddressUtils.str((InetAddress)this.m_target), (Throwable)e);
                    }
                }
                SmbAuth authentication = null;
                if (this.m_domain != null) {
                    authentication = CapsdConfigFactory.getInstance().getSmbAuth(this.m_domain);
                }
                if (authentication == null) {
                    authentication = CapsdConfigFactory.getInstance().getSmbAuth(this.m_addr.getHostName());
                }
                if (log.isDebugEnabled()) {
                    log.debug("IfSmbCollector: SMB authenticator: " + authentication);
                }
                if (authentication == null) {
                    return;
                }
                try {
                    String smbUrl = SmbUtils.getSmbURL(authentication, this.m_addr.getHostName());
                    if (log.isDebugEnabled()) {
                        log.debug("IfSmbCollector: smbUrl = " + smbUrl);
                    }
                    SmbFile sfile = new SmbFile(smbUrl);
                    if (log.isDebugEnabled()) {
                        log.debug("IfSmbCollector: got SmbFile object, retrieving share list...");
                    }
                    this.m_shares = sfile.list();
                    if (log.isDebugEnabled()) {
                        log.debug("IfSmbCollector: shares list retrieved...");
                    }
                }
                catch (MalformedURLException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("IfSmbCollector: failed to get SMB resource and OS name for host " + InetAddressUtils.str((InetAddress)this.m_target), (Throwable)e);
                    }
                }
                catch (SmbAuthException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("IfSmbCollector: unable to list SMB shares, authentication failed, reason: " + e.getMessage());
                    }
                }
                catch (SmbException e) {
                    if (!log.isDebugEnabled()) break block29;
                    log.debug("IfSmbCollector: unable to list SMB shares, reason: " + e.getMessage());
                }
            }
        }
    }
}

