/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.actiond;

import java.util.Enumeration;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    private final FifoQueue<String> m_execQ;

    BroadcastEventProcessor(FifoQueue<String> execQ) {
        this.m_execQ = execQ;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener(this);
    }

    public synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    public void onEvent(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(BroadcastEventProcessor.class);
        if (event == null) {
            return;
        }
        Enumeration walker = event.enumerateAutoaction();
        while (walker.hasMoreElements()) {
            try {
                Autoaction aact = (Autoaction)walker.nextElement();
                if ("on".equalsIgnoreCase(aact.getState())) {
                    this.m_execQ.add((Object)aact.getContent());
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Added event '" + event.getUei() + "' to execute autoaction '" + aact.getContent() + "'");
            }
            catch (FifoQueueException ex) {
                log.error("Failed to add event to execution queue", (Throwable)ex);
                break;
            }
            catch (InterruptedException ex) {
                log.error("Failed to add event to execution queue", (Throwable)ex);
                break;
            }
        }
        if (event.getTticket() != null && event.getTticket().getState().equalsIgnoreCase("on")) {
            try {
                this.m_execQ.add((Object)event.getTticket().getContent());
                if (log.isDebugEnabled()) {
                    log.debug("Added event '" + event.getUei() + "' to execute tticket '" + event.getTticket().getContent() + "'");
                }
            }
            catch (FifoQueueException ex) {
                log.error("Failed to add event to execution queue", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                log.error("Failed to add event to execution queue", (Throwable)ex);
            }
        }
    }

    public String getName() {
        return "Actiond:BroadcastEventProcessor";
    }
}

