/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.prometheus;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hawkular.agent.prometheus.text.TextSample;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.Metric;
import org.hawkular.agent.prometheus.types.MetricVisitor;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.MetricCollectingWalker;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.prometheus.CamelCaseCompressor;
import org.opennms.netmgt.collectd.prometheus.PrometheusScraper;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.prometheus.Collection;
import org.opennms.netmgt.config.prometheus.Group;
import org.opennms.netmgt.config.prometheus.NumericAttribute;
import org.opennms.netmgt.config.prometheus.PrometheusCollectionRequest;
import org.opennms.netmgt.config.prometheus.PrometheusDatacollectionConfig;
import org.opennms.netmgt.config.prometheus.StringAttribute;
import org.opennms.netmgt.dao.prometheus.PrometheusDataCollectionConfigDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class PrometheusCollector
extends AbstractRemoteServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusCollector.class);
    private static final String INTERFACE_ADDRESS_PLACEHOLDER = "INTERFACE_ADDRESS";
    private static final String COLLECTION_REQUEST_KEY = "collection-request";
    private static final Map<String, Class<?>> TYPE_MAP = new ImmutableMap.Builder().put((Object)"collection-request", PrometheusCollectionRequest.class).build();
    private PrometheusDataCollectionConfigDao prometheusCollectionDao;

    public PrometheusCollector() {
        super(TYPE_MAP);
    }

    public void initialize() {
        if (this.prometheusCollectionDao == null) {
            this.prometheusCollectionDao = (PrometheusDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"prometheusDataCollectionConfigDao", PrometheusDataCollectionConfigDao.class);
        }
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)ServiceParameters.ParameterName.COLLECTION.toString(), null);
        Collection collection = this.prometheusCollectionDao.getCollectionByName(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException(String.format("PrometheusCollector: No collection found with name '%s'.", collectionName));
        }
        List<Group> groups = this.prometheusCollectionDao.getGroupsForCollection(collection);
        PrometheusCollectionRequest request = new PrometheusCollectionRequest();
        request.setGroups(groups);
        runtimeAttributes.put(COLLECTION_REQUEST_KEY, request);
        return runtimeAttributes;
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> map) throws CollectionException {
        URI parsedUri;
        PrometheusCollectionRequest request = (PrometheusCollectionRequest)map.get(COLLECTION_REQUEST_KEY);
        String url = ParameterMap.getKeyedString(map, (String)"url", null);
        if (Strings.isNullOrEmpty((String)url)) {
            throw new IllegalArgumentException("url parameter is required.");
        }
        url = url.replace(INTERFACE_ADDRESS_PLACEHOLDER, agent.getHostAddress());
        try {
            parsedUri = URI.create(url);
        }
        catch (IllegalArgumentException e) {
            throw new CollectionException("Invalid URL: " + url, (Throwable)e);
        }
        MetricCollectingWalker walker = new MetricCollectingWalker();
        try {
            PrometheusScraper.scrape(parsedUri, map, walker);
        }
        catch (IOException e) {
            throw new CollectionException("Failed to scrape metrics for: " + parsedUri, (Throwable)e);
        }
        return PrometheusCollector.toCollectionSet(agent, request, walker.getMetrics());
    }

    protected static CollectionSet toCollectionSet(CollectionAgent agent, PrometheusCollectionRequest request, List<Metric> metrics) {
        final CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        for (final Group group : request.getGroups()) {
            List<Metric> metricsForGroup = PrometheusCollector.filterMetrics(group.getFilterExp(), metrics);
            if (metricsForGroup.isEmpty()) {
                LOG.debug("No metrics found in group named '{}' on agent {}.", (Object)group.getName(), (Object)agent);
                continue;
            }
            Map<String, List<Metric>> metricsByInstance = PrometheusCollector.groupMetrics(group, metricsForGroup);
            NodeLevelResource nodeLevelResource = new NodeLevelResource(agent.getNodeId());
            Function<String, Resource> resourceMapper = instance -> nodeLevelResource;
            if (!"node".equalsIgnoreCase(group.getResourceType())) {
                resourceMapper = instance -> {
                    String sanitizedInstance = GenericTypeResource.sanitizeInstanceStrict((String)instance);
                    return new DeferredGenericTypeResource(nodeLevelResource, group.getResourceType(), sanitizedInstance);
                };
            }
            for (Map.Entry<String, List<Metric>> entry : metricsByInstance.entrySet()) {
                final Resource resource = resourceMapper.apply(entry.getKey());
                for (NumericAttribute numericAttribute : group.getNumericAttribute()) {
                    List<Metric> metricsForAttribute = PrometheusCollector.filterMetrics(numericAttribute.getFilterExp(), entry.getValue());
                    SpelExpressionParser parser = new SpelExpressionParser();
                    Expression exp = parser.parseExpression(numericAttribute.getAliasExp());
                    Function<Metric, String> attributeNameMapper = metric -> {
                        StandardEvaluationContext context = new StandardEvaluationContext(metric);
                        String name = (String)exp.getValue((EvaluationContext)context, String.class);
                        if (numericAttribute.isCompressAlias()) {
                            name = CamelCaseCompressor.compress(name, 19);
                        }
                        return name;
                    };
                    final Function<AttributeType, AttributeType> attributeTypeMapper = knownType -> {
                        if (numericAttribute.getType() != null) {
                            return numericAttribute.getType();
                        }
                        return knownType;
                    };
                    for (Metric metric2 : metricsForAttribute) {
                        final String attributeName = attributeNameMapper.apply(metric2);
                        if (attributeName == null) {
                            LOG.info("Skipping metric with null attribute name: {}", (Object)metric2);
                            continue;
                        }
                        metric2.visit(new MetricVisitor(){

                            @Override
                            public void visitCounter(Counter counter) {
                                builder.withNumericAttribute(resource, group.getName(), attributeName, (Number)counter.getValue(), (AttributeType)attributeTypeMapper.apply(AttributeType.COUNTER));
                            }

                            @Override
                            public void visitGauge(Gauge gauge) {
                                builder.withNumericAttribute(resource, group.getName(), attributeName, (Number)gauge.getValue(), (AttributeType)attributeTypeMapper.apply(AttributeType.GAUGE));
                            }

                            @Override
                            public void visitHistogram(Histogram histogram) {
                            }

                            @Override
                            public void visitSummary(Summary summary) {
                            }

                            @Override
                            public void visitTextSample(TextSample textSample) {
                            }
                        });
                    }
                }
                block4: for (StringAttribute stringAttribute : group.getStringAttribute()) {
                    SpelExpressionParser parser = new SpelExpressionParser();
                    Expression stringAttributeValueExp = parser.parseExpression(stringAttribute.getValueExp());
                    for (Metric metric3 : entry.getValue()) {
                        StandardEvaluationContext context = new StandardEvaluationContext((Object)metric3);
                        String stringValue = (String)stringAttributeValueExp.getValue((EvaluationContext)context, String.class);
                        if (stringValue == null) continue;
                        builder.withStringAttribute(resource, group.getName(), stringAttribute.getAlias(), stringValue);
                        continue block4;
                    }
                }
            }
        }
        return builder.build();
    }

    private static List<Metric> filterMetrics(String filterExpression, List<Metric> metrics) {
        if (filterExpression == null) {
            return metrics;
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(filterExpression);
        ArrayList<Metric> filteredMetrics = new ArrayList<Metric>();
        for (Metric metric : metrics) {
            StandardEvaluationContext context = new StandardEvaluationContext((Object)metric);
            boolean passed = false;
            try {
                passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
            }
            catch (Exception e) {
                LOG.warn("Failed to evaluate expression '{}'. The metric will not be included.", (Object)filterExpression, (Object)e);
            }
            LOG.trace("Rule '{}' on {} passed? {}", new Object[]{filterExpression, metric, passed});
            if (!passed) continue;
            filteredMetrics.add(metric);
        }
        return filteredMetrics;
    }

    private static Map<String, List<Metric>> groupMetrics(Group group, List<Metric> metrics) {
        LinkedHashMap<String, List<Metric>> metricsByInstance = new LinkedHashMap<String, List<Metric>>();
        if (group.getGroupByExp() == null) {
            metricsByInstance.put("node", metrics);
            return metricsByInstance;
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(group.getGroupByExp());
        for (Metric metric : metrics) {
            StandardEvaluationContext context = new StandardEvaluationContext((Object)metric);
            try {
                String instance = (String)exp.getValue((EvaluationContext)context, String.class);
                LOG.trace("Rule '{}' on {} returned instance: {}", new Object[]{group.getGroupByExp(), metric, instance});
                if (instance == null) {
                    LOG.info("Rule '{}' on {} did not produce an instance. Result will be ignored.", (Object)group.getGroupByExp(), (Object)metric);
                    continue;
                }
                List metricsInInstance = metricsByInstance.computeIfAbsent(instance, k -> new LinkedList());
                metricsInInstance.add(metric);
            }
            catch (Exception e) {
                LOG.warn("Failed to evaluate expression '{}' in the group named '{}'. The metric will not be included.", new Object[]{group.getGroupByExp(), group.getName(), e});
            }
        }
        return metricsByInstance;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        LOG.debug("getRrdRepository({})", (Object)collectionName);
        PrometheusDatacollectionConfig config = this.prometheusCollectionDao.getConfig();
        Collection collection = this.prometheusCollectionDao.getCollectionByName(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException("No configuration found for collection with name: " + collectionName);
        }
        RrdRepository rrdRepository = new RrdRepository();
        rrdRepository.setStep(collection.getRrd().getStep());
        rrdRepository.setHeartBeat(2 * rrdRepository.getStep());
        rrdRepository.setRraList(collection.getRrd().getRra());
        rrdRepository.setRrdBaseDir(new File(config.getRrdRepository()));
        LOG.debug("Using RRD repository: {} for collection: {}", (Object)rrdRepository, (Object)collectionName);
        return rrdRepository;
    }

    public void setPrometheusCollectionDao(PrometheusDataCollectionConfigDao prometheusCollectionDao) {
        this.prometheusCollectionDao = prometheusCollectionDao;
    }
}

