/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.prometheus;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CamelCaseCompressor {
    public static String compress(String input, int maxLen) {
        if (input == null) {
            return null;
        }
        int len = input.length();
        if (len <= maxLen) {
            return input;
        }
        String[] components = StringUtils.splitByCharacterTypeCamelCase((String)input);
        int numCharactersToRemove = Arrays.stream(components).mapToInt(String::length).sum() - maxLen;
        PriorityQueue<Component> q = new PriorityQueue<Component>();
        int i = 0;
        for (String component : components) {
            q.add(new Component(i++, component));
        }
        while (numCharactersToRemove > 0) {
            Component component = (Component)q.remove();
            if (!component.removeCharacter()) continue;
            q.add(component);
            --numCharactersToRemove;
        }
        return q.stream().sorted(Comparator.comparing(c -> c.index)).map(c -> c.value).collect(Collectors.joining());
    }

    private static class Component
    implements Comparable<Component> {
        int index;
        String value;

        public Component(int index, String value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(Component o) {
            return o.value.length() - this.value.length();
        }

        public boolean removeCharacter() {
            if (this.value == null || this.value.length() < 1) {
                return false;
            }
            this.value = this.value.substring(0, this.value.length() - 1);
            return true;
        }
    }
}

