/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.archive;

import java.net.URL;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.plugins.elasticsearch.rest.archive.OnmsHistoricEventsToEs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="opennms-elasticsearch", name="send-historic-events", description="Sends events in selected OpenNMS to Elasticsearch")
@Service
public class SendEventsToEsCommand
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(SendEventsToEsCommand.class);
    @Reference
    private EventForwarder eventForwarder;
    @Option(name="--limit", description="Limit number of events to send. Use 0 to send ALL events.")
    int limit = 1000;
    @Option(name="--offset", description="Offset for starting events")
    int offset = 0;
    @Option(name="--username", description="Password for OpenNMS ReST interface")
    String username = null;
    @Option(name="--password", description="Username for OpenNMS ReST interface")
    String password = null;
    @Option(name="--url", description="URL of OpenNMS ReST interface to retrieve events to send")
    String url = null;
    @Option(name="--use-node-label", description="If false local node cache will get nodelabel for nodeid. If true will use remote nodelabel")
    boolean useNodelabel = false;
    @Option(name="--log-size", description="The size of the number of events to dispatch at once to elastic.")
    int logSize = 200;

    public Object execute() {
        try {
            OnmsHistoricEventsToEs onmsHistoryEventsToEs = new OnmsHistoricEventsToEs();
            onmsHistoryEventsToEs.setEventForwarder(this.eventForwarder);
            onmsHistoryEventsToEs.setLimit(this.limit);
            if (this.limit > 0) {
                onmsHistoryEventsToEs.setOffset(this.offset);
            }
            if (this.password != null) {
                onmsHistoryEventsToEs.setOnmsPassWord(this.password);
            }
            if (this.username != null) {
                onmsHistoryEventsToEs.setOnmsUserName(this.username);
            }
            if (this.url != null) {
                new URL(this.url);
                onmsHistoryEventsToEs.setOnmsUrl(this.url);
            }
            if (this.useNodelabel) {
                onmsHistoryEventsToEs.setUseNodeLabel(this.useNodelabel);
            }
            if (this.logSize > 0) {
                onmsHistoryEventsToEs.setLogSize(this.logSize);
            }
            String msg = "Sending events to Elasticsearch. \n Limit: " + onmsHistoryEventsToEs.getLimit() + "\n Offset: " + onmsHistoryEventsToEs.getOffset() + "\n Retrieving events from OpenNMS URL: " + onmsHistoryEventsToEs.getOnmsUrl() + "\n OpenNMS Username: " + onmsHistoryEventsToEs.getOnmsUserName() + "\n OpenNMS Password: " + onmsHistoryEventsToEs.getOnmsPassWord() + "\n Use Node Label: " + onmsHistoryEventsToEs.getUseNodeLabel() + "\n Log Size: " + this.logSize;
            LOG.info(msg);
            System.out.println(msg);
            String response = onmsHistoryEventsToEs.sendEventsToEs();
            LOG.info(response);
            System.out.println(response);
        }
        catch (Exception e) {
            System.err.println("Error Sending Historical Events to ES (see karaf.log) " + ExceptionUtils.getStackTrace((Throwable)e));
            LOG.error("Error Sending Historical Events to ES ", (Throwable)e);
        }
        return null;
    }
}

