/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import java.util.Objects;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingEventListener
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingEventListener.class);
    private final EventForwarder eventForwarder;
    private final EventIpcManager eventIpcManager;

    public ForwardingEventListener(EventForwarder eventForwarder, EventIpcManager eventIpcManager) {
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.eventIpcManager = Objects.requireNonNull(eventIpcManager);
    }

    public void init() {
        this.eventIpcManager.addEventListener((EventListener)this);
        LOG.debug("Elasticsearch event forwarder initialized");
    }

    public void destroy() {
        if (this.eventIpcManager != null) {
            this.eventIpcManager.removeEventListener((EventListener)this);
        }
        LOG.debug("Elasticsearch event forwarder unregisted for events");
    }

    public void onEvent(Event event) {
        this.eventForwarder.sendNow(event);
    }

    public String getName() {
        return "ElasticsearchRestEventForwarder";
    }
}

