/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.archive;

import java.util.Date;
import java.util.List;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.plugins.elasticsearch.rest.archive.OnmsRestEventsClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsHistoricEventsToEs {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsHistoricEventsToEs.class);
    private String onmsUrl = "http://localhost:8980";
    private String onmsUserName = "admin";
    private String onmsPassWord = "admin";
    private Integer limit = 10;
    private Integer offset = 0;
    private EventForwarder eventForwarder = null;
    private boolean useNodeLabel = true;
    private int logSize = 100;

    public String getOnmsUrl() {
        return this.onmsUrl;
    }

    public void setOnmsUrl(String onmsUrl) {
        this.onmsUrl = onmsUrl;
    }

    public String getOnmsUserName() {
        return this.onmsUserName;
    }

    public void setOnmsUserName(String onmsUserName) {
        this.onmsUserName = onmsUserName;
    }

    public String getOnmsPassWord() {
        return this.onmsPassWord;
    }

    public void setOnmsPassWord(String onmsPassWord) {
        this.onmsPassWord = onmsPassWord;
    }

    public EventForwarder getEventForwarder() {
        return this.eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public boolean getUseNodeLabel() {
        return this.useNodeLabel;
    }

    public void setUseNodeLabel(boolean useCache) {
        this.useNodeLabel = useCache;
    }

    public void setLogSize(int logSize) {
        this.logSize = logSize;
    }

    public String sendEventsToEs() {
        OnmsRestEventsClient onmsRestEventsClient = new OnmsRestEventsClient(this.onmsUrl, this.onmsPassWord, this.onmsUserName);
        Event firstEvent = null;
        Event lastEvent = null;
        boolean endofEvents = false;
        int eventsSent = 0;
        int eventOffset = this.offset;
        while (!endofEvents && eventsSent <= this.limit) {
            List<Event> events = onmsRestEventsClient.getEvents(this.logSize, eventOffset);
            endofEvents = events.isEmpty();
            if (endofEvents) continue;
            if (firstEvent == null) {
                firstEvent = events.get(0);
            }
            if (!this.useNodeLabel) {
                events.forEach(event -> {
                    Parm parm = event.getParm("nodelabel");
                    if (parm != null) {
                        event.getParmCollection().remove(parm);
                    }
                });
            }
            if (LOG.isDebugEnabled()) {
                events.forEach(event -> LOG.debug("sending event to es: eventid={}", (Object)event.getDbid()));
            }
            lastEvent = events.get(events.size() - 1);
            Log log = this.createLog(events);
            this.getEventForwarder().sendNow(log);
            eventsSent += log.getEvents().getEventCount();
            eventOffset += events.size();
        }
        return "Dispatched " + eventsSent + " events to forward to Elasticsearch. First event id=" + (firstEvent != null ? firstEvent.getDbid() : "firstEvent null") + " last event id=" + (lastEvent != null ? lastEvent.getDbid() : "lastEvent null");
    }

    private Log createLog(List<Event> eventList) {
        Header header = new Header();
        header.setCreated(StringUtils.toStringEfficiently((Date)new Date()));
        Events events = new Events();
        events.setEvent(eventList);
        Log log = new Log();
        log.setEvents(events);
        log.setHeader(header);
        return log;
    }
}

