/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opennms.core.ipc.sink.aggregation.AggregatingMessageProducer;
import org.opennms.core.ipc.sink.aggregation.ArrayListAggregationPolicy;
import org.opennms.core.ipc.sink.api.AggregationPolicy;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.plugins.elasticsearch.rest.EventToIndex;
import org.opennms.plugins.elasticsearch.rest.template.TemplateInitializer;

public class EventForwarderQueueImpl
implements EventForwarder,
AutoCloseable {
    private final EventToIndex eventToIndex;
    private final TemplateInitializer elasticSearchInitializer;
    private AggregatingMessageProducer<Event, List<Event>> producer;

    public EventForwarderQueueImpl(EventToIndex eventToIndex, TemplateInitializer initializer, int batchSize, int batchInterval) {
        this.elasticSearchInitializer = Objects.requireNonNull(initializer);
        this.eventToIndex = Objects.requireNonNull(eventToIndex);
        this.producer = new EventIndexProducer(batchSize, batchInterval);
    }

    public void sendNow(Event event) {
        this.producer.send((Object)event);
    }

    public void sendNow(Log eventLog) {
        if (eventLog != null && eventLog.getEvents() != null) {
            for (Event event : eventLog.getEvents().getEvent()) {
                this.sendNow(event);
            }
        }
    }

    public void sendNowSync(Event event) {
        this.producer.dispatch(Collections.singletonList(event));
    }

    public void sendNowSync(Log eventLog) {
        if (eventLog != null && eventLog.getEvents() != null) {
            this.producer.dispatch(Arrays.asList(eventLog.getEvents().getEvent()));
        }
    }

    @Override
    public void close() throws Exception {
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }

    private class EventIndexProducer
    extends AggregatingMessageProducer<Event, List<Event>> {
        public EventIndexProducer(int batchSize, int batchInterval) {
            super(EventIndexProducer.class.getName(), (AggregationPolicy)new ArrayListAggregationPolicy(batchSize, batchInterval, e -> "event"));
        }

        public void dispatch(List<Event> events) {
            if (!EventForwarderQueueImpl.this.elasticSearchInitializer.isInitialized()) {
                EventForwarderQueueImpl.this.elasticSearchInitializer.initialize();
            }
            EventForwarderQueueImpl.this.eventToIndex.forwardEvents(events);
        }
    }
}

