/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.opennms.plugins.elasticsearch.rest.executors.RequestExecutor;

public class OnmsJestClient
implements JestClient {
    private final JestClient m_delegate;
    private final RequestExecutor m_requestExecutor;

    public OnmsJestClient(JestClient delegate, RequestExecutor requestExecutor) {
        this.m_delegate = Objects.requireNonNull(delegate);
        this.m_requestExecutor = Objects.requireNonNull(requestExecutor);
    }

    public <T extends JestResult> T execute(Action<T> clientRequest) throws IOException {
        JestResult result = this.m_requestExecutor.execute(this.m_delegate, clientRequest);
        return (T)result;
    }

    public <T extends JestResult> void executeAsync(Action<T> clientRequest, JestResultHandler<? super T> jestResultHandler) {
        this.m_delegate.executeAsync(clientRequest, jestResultHandler);
    }

    @Deprecated
    public void shutdownClient() {
        this.m_delegate.shutdownClient();
    }

    public void setServers(Set<String> servers) {
        this.m_delegate.setServers(servers);
    }

    public void close() throws IOException {
        this.m_delegate.close();
    }
}

