/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.archive;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsRestEventsClient {
    public static final String NODE_LABEL = "nodelabel";
    public static final String EVENTS_URI = "/opennms/rest/events";
    public static final String EVENT_COUNT_URI = "/opennms/rest/events/count";
    private static final Logger LOG = LoggerFactory.getLogger(OnmsRestEventsClient.class);
    private final String baseUrl;
    private final String username;
    private final String password;

    public OnmsRestEventsClient(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
    }

    /*
     * Exception decompiling
     */
    public Integer getEventCount() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Event> getEvents(Integer limit, Integer offset) {
        ArrayList<Event> retrievedEvents = new ArrayList<Event>();
        try (CloseableHttpClient httpclient = this.createHttpClient();){
            ArrayList<String> queryParts = new ArrayList<String>();
            if (limit != null) {
                queryParts.add("limit=" + limit);
            }
            if (offset != null) {
                queryParts.add("offset=" + offset);
            }
            String query = queryParts.isEmpty() ? "" : "?" + queryParts.stream().collect(Collectors.joining("&"));
            HttpGet request = new HttpGet(this.baseUrl + EVENTS_URI + query);
            request.addHeader("accept", "application/xml");
            LOG.debug("Executing request " + request.getRequestLine());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
                }
                String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
                LOG.debug("Response status: {}, entity: {}", (Object)response.getStatusLine(), (Object)responseStr);
                StringReader reader = new StringReader(responseStr);
                OnmsEventCollection eventCollection = (OnmsEventCollection)JaxbUtils.unmarshal(OnmsEventCollection.class, (Reader)reader);
                LOG.debug("Received event Collection:\u00b4with offset: {}, totalCount: {}, size: {}", new Object[]{eventCollection.getOffset(), eventCollection.getTotalCount(), eventCollection.size()});
                for (int i = 0; i < eventCollection.size(); ++i) {
                    Event event = OnmsRestEventsClient.toEvent((OnmsEvent)eventCollection.get(i));
                    retrievedEvents.add(event);
                }
            }
            ArrayList<Event> arrayList = retrievedEvents;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("exception when getting event list", e);
        }
    }

    private static Event toEvent(OnmsEvent onmsEvent) {
        Event event = new Event();
        if (onmsEvent.getId() != null) {
            event.setDbid(onmsEvent.getId());
        }
        if (onmsEvent.getEventUei() != null) {
            event.setUei(onmsEvent.getEventUei());
        }
        if (onmsEvent.getEventCreateTime() != null) {
            event.setCreationTime(onmsEvent.getEventCreateTime());
        }
        if (onmsEvent.getSeverityLabel() != null) {
            event.setSeverity(onmsEvent.getSeverityLabel());
        }
        if (onmsEvent.getEventDescr() != null) {
            event.setDescr(onmsEvent.getEventDescr());
        }
        if (onmsEvent.getEventHost() != null) {
            event.setHost(onmsEvent.getEventHost());
        }
        ArrayList<Parm> parmColl = new ArrayList<Parm>();
        if (onmsEvent.getEventParameters() != null) {
            List params = onmsEvent.getEventParameters();
            for (OnmsEventParameter onmsEventParameter : params) {
                Value parmvalue = new Value();
                parmvalue.setType(onmsEventParameter.getType());
                parmvalue.setContent(onmsEventParameter.getValue());
                Parm parm = new Parm();
                parm.setParmName(onmsEventParameter.getName());
                parm.setValue(parmvalue);
                parmColl.add(parm);
            }
        }
        if (onmsEvent.getNodeLabel() != null) {
            Value parmValue = new Value();
            parmValue.setType("string");
            parmValue.setEncoding("text");
            parmValue.setContent(onmsEvent.getNodeLabel());
            Parm parm = new Parm();
            parm.setParmName(NODE_LABEL);
            parm.setValue(parmValue);
            parmColl.add(parm);
        }
        event.setParmCollection(parmColl);
        if (onmsEvent.getEventLogMsg() != null) {
            Logmsg logmsg = new Logmsg();
            logmsg.setContent(onmsEvent.getEventLogMsg());
            event.setLogmsg(logmsg);
        }
        if (onmsEvent.getNodeId() != null) {
            event.setNodeid(Long.valueOf(onmsEvent.getNodeId().longValue()));
        }
        return event;
    }

    private CloseableHttpClient createHttpClient() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }
}

