/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import com.google.common.base.Strings;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.opennms.plugins.elasticsearch.rest.OnmsJestClient;
import org.opennms.plugins.elasticsearch.rest.RequestExecutorFactory;
import org.opennms.plugins.elasticsearch.rest.credentials.CredentialsParser;
import org.opennms.plugins.elasticsearch.rest.credentials.CredentialsProvider;
import org.opennms.plugins.elasticsearch.rest.executors.LimitedRetriesRequestExecutor;
import org.opennms.plugins.elasticsearch.rest.executors.RequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientFactory.class);
    private static final int DEFAULT_MAX_TOTAL_CONNECTION_PER_ROUTE = Runtime.getRuntime().availableProcessors() * 2;
    private static final int DEFAULT_MAX_TOTAL_CONNECTION = DEFAULT_MAX_TOTAL_CONNECTION_PER_ROUTE * 3;
    private final HttpClientConfig.Builder clientConfigBuilder;
    private int m_timeout = 0;
    private int m_retries = 0;
    private JestClient client;
    private Supplier<RequestExecutor> requestExecutorSupplier = () -> new LimitedRetriesRequestExecutor(this.m_timeout, this.m_retries);

    public RestClientFactory(String elasticSearchURL) throws MalformedURLException {
        this(elasticSearchURL, null, null);
    }

    public RestClientFactory(String elasticSearchURL, String globalElasticUser, String globalElasticPassword) throws MalformedURLException {
        String globalPassword;
        List<String> urls = this.parseUrl(elasticSearchURL);
        String globalUser = globalElasticUser != null && !globalElasticUser.isEmpty() ? globalElasticUser : null;
        String string = globalPassword = globalElasticPassword != null && !globalElasticPassword.isEmpty() ? globalElasticPassword : null;
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("No urls have been provided");
        }
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        this.clientConfigBuilder = (HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(urls).multiThreaded(true)).defaultMaxTotalConnectionPerRoute(DEFAULT_MAX_TOTAL_CONNECTION_PER_ROUTE).maxTotalConnection(DEFAULT_MAX_TOTAL_CONNECTION).gson(gson);
        if (globalUser != null && globalPassword != null) {
            this.clientConfigBuilder.defaultCredentials(globalUser, globalPassword);
            Set targetHosts = urls.stream().map(url -> {
                try {
                    return new URL((String)url);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }).map(url -> new HttpHost(url.getHost(), url.getPort(), url.getProtocol())).collect(Collectors.toSet());
            this.clientConfigBuilder.preemptiveAuthTargetHosts(targetHosts);
        }
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public void setSocketTimeout(int timeout) {
        this.setReadTimeout(timeout);
    }

    public void setTimeout(int timeout) {
        this.setConnTimeout(timeout);
    }

    public void setConnTimeout(int timeout) {
        this.m_timeout = timeout;
        this.clientConfigBuilder.connTimeout(timeout);
    }

    public void setReadTimeout(int timeout) {
        this.clientConfigBuilder.readTimeout(timeout);
    }

    public void setMultiThreaded(boolean multiThreaded) {
        this.clientConfigBuilder.multiThreaded(multiThreaded);
    }

    public void setDefaultMaxTotalConnectionPerRoute(int connections) {
        if (connections < 0) {
            return;
        }
        this.clientConfigBuilder.defaultMaxTotalConnectionPerRoute(connections);
    }

    public void setMaxTotalConnection(int connections) {
        if (connections < 0) {
            return;
        }
        this.clientConfigBuilder.maxTotalConnection(connections);
    }

    public void setDiscovery(boolean discovery) {
        this.clientConfigBuilder.discoveryEnabled(discovery);
    }

    public void setDiscoveryFrequency(int discoveryFrequencyInSeconds) {
        this.clientConfigBuilder.discoveryFrequency((long)discoveryFrequencyInSeconds, TimeUnit.SECONDS);
    }

    public void setMaxConnectionIdleTime(int timeout, TimeUnit unit) {
        this.clientConfigBuilder.maxConnectionIdleTime((long)timeout, unit);
    }

    public void setCredentials(CredentialsProvider credentialsProvider) throws IOException {
        if (credentialsProvider != null) {
            Map credentials = new CredentialsParser().parse(credentialsProvider.getCredentials());
            if (!credentials.isEmpty()) {
                BasicCredentialsProvider customCredentialsProvider = new BasicCredentialsProvider();
                this.clientConfigBuilder.credentialsProvider((org.apache.http.client.CredentialsProvider)customCredentialsProvider);
                credentials.forEach((key, value) -> customCredentialsProvider.setCredentials(key, value));
            } else {
                LOG.warn("setCredentials was invoked, but no credentials or no valid credentials were provided.");
            }
        }
    }

    public void setProxy(String proxy) throws MalformedURLException {
        if (!Strings.isNullOrEmpty((String)proxy)) {
            URL proxyURL = new URL(proxy);
            this.clientConfigBuilder.proxy(new HttpHost(proxyURL.getHost(), proxyURL.getPort(), proxyURL.getProtocol()));
        }
    }

    public void setRequestExecutorFactory(RequestExecutorFactory requestExecutorFactory) {
        this.requestExecutorSupplier = () -> requestExecutorFactory.createExecutor(this.m_timeout, this.m_retries);
    }

    public void setRequestExecutorSupplier(Supplier<RequestExecutor> requestExecutorSupplier) {
        this.requestExecutorSupplier = requestExecutorSupplier;
    }

    public JestClient createClient() {
        if (this.client == null) {
            JestClientFactory factory = new JestClientFactory();
            factory.setHttpClientConfig(this.clientConfigBuilder.build());
            RequestExecutor executor = this.requestExecutorSupplier.get();
            this.client = new OnmsJestClient(factory.getObject(), executor);
        }
        return this.client;
    }

    private List<String> parseUrl(String elasticURL) {
        if (elasticURL != null) {
            Set endpoints = Arrays.stream(elasticURL.split(",")).filter(url -> url != null && !url.trim().isEmpty()).map(url -> url.trim()).collect(Collectors.toSet());
            return new ArrayList<String>(endpoints);
        }
        return Collections.emptyList();
    }
}

