/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.nustaq.serialization.FSTConfiguration;
import org.opennms.netmgt.newts.support.SearchableResourceMetadataCache;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.cassandra.search.ResourceIdSplitter;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;

public class RedisResourceMetadataCache
implements SearchableResourceMetadataCache {
    private static final String METADATA_PREFIX = "_M";
    private static final String SEARCH_PREFIX = "_S";
    private static final FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
    private static final Joiner m_keyJoiner = Joiner.on((char)':');
    private final ResourceIdSplitter m_resourceIdSplitter;
    private final JedisPool m_pool;

    @Inject
    public RedisResourceMetadataCache(@Named(value="redis.hostname") String hostname, @Named(value="redis.port") Integer port, @Named(value="newts.writer_threads") Integer numWriterThreads, MetricRegistry registry, ResourceIdSplitter resourceIdSplitter) {
        Preconditions.checkNotNull((Object)hostname, (Object)" hostname argument");
        Preconditions.checkNotNull((Object)port, (Object)"port argument");
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMinIdle(numWriterThreads.intValue());
        poolConfig.setMaxTotal(numWriterThreads * 4);
        this.m_pool = new JedisPool((GenericObjectPoolConfig)poolConfig, hostname, port.intValue());
        Preconditions.checkNotNull((Object)registry, (Object)"registry argument");
        registry.register(MetricRegistry.name((String)"cache", (String[])new String[]{"size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                try (Jedis jedis = RedisResourceMetadataCache.this.m_pool.getResource();){
                    Long l = jedis.dbSize();
                    return l;
                }
            }
        });
        registry.register(MetricRegistry.name((String)"cache", (String[])new String[]{"max-size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return 0L;
            }
        });
        this.m_resourceIdSplitter = (ResourceIdSplitter)Preconditions.checkNotNull((Object)resourceIdSplitter, (Object)"resourceIdSplitter argument");
    }

    public void merge(Context context, Resource resource, ResourceMetadata metadata) {
        Optional<ResourceMetadata> o = this.get(context, resource);
        try (Jedis jedis = this.m_pool.getResource();){
            if (!o.isPresent()) {
                ResourceMetadata newMetadata = new ResourceMetadata();
                newMetadata.merge(metadata);
                Transaction t = jedis.multi();
                byte[] key = RedisResourceMetadataCache.key(METADATA_PREFIX, context.getId(), resource.getId());
                t.set(key, conf.asByteArray((Object)newMetadata));
                ArrayList elements = Lists.newArrayList((Object[])new String[]{SEARCH_PREFIX, context.getId()});
                for (String el : this.m_resourceIdSplitter.splitIdIntoElements(resource.getId())) {
                    elements.add(el);
                    t.lpush(this.m_resourceIdSplitter.joinElementsToId((List)elements).getBytes(), (byte[][])new byte[][]{key});
                }
                t.exec();
            } else if (((ResourceMetadata)o.get()).merge(metadata)) {
                jedis.set(RedisResourceMetadataCache.key(METADATA_PREFIX, context.getId(), resource.getId()), conf.asByteArray(o.get()));
            }
        }
    }

    public Optional<ResourceMetadata> get(Context context, Resource resource) {
        try (Jedis jedis = this.m_pool.getResource();){
            byte[] bytes = jedis.get(RedisResourceMetadataCache.key(METADATA_PREFIX, context.getId(), resource.getId()));
            Optional optional = bytes != null ? Optional.of((Object)((ResourceMetadata)conf.asObject(bytes))) : Optional.absent();
            return optional;
        }
    }

    public void delete(Context context, Resource resource) {
        try (Jedis jedis = this.m_pool.getResource();){
            jedis.del(RedisResourceMetadataCache.key(METADATA_PREFIX, context.getId(), resource.getId()));
        }
    }

    @Override
    public List<String> getResourceIdsWithPrefix(Context context, String resourceIdPrefix) {
        try (Jedis jedis = this.m_pool.getResource();){
            ArrayList elements = Lists.newArrayList((Object[])new String[]{SEARCH_PREFIX, context.getId()});
            elements.addAll(this.m_resourceIdSplitter.splitIdIntoElements(resourceIdPrefix));
            List<String> list = jedis.lrange(this.m_resourceIdSplitter.joinElementsToId((List)elements).getBytes(), 0L, -1L).stream().map(bytes -> this.resourceId(METADATA_PREFIX, context.getId(), (byte[])bytes)).collect(Collectors.toList());
            return list;
        }
    }

    private static byte[] key(String prefix, String contextId, String resourceId) {
        return m_keyJoiner.join((Object)prefix, (Object)contextId, new Object[]{resourceId}).getBytes();
    }

    private String resourceId(String prefix, String contextId, byte[] key) {
        return new String(key).substring(prefix.length() + contextId.length() + 2);
    }
}

