/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.opennms.netmgt.newts.NewtsWriter;
import org.opennms.netmgt.newts.support.NewtsUtils;
import org.opennms.netmgt.newts.support.SearchableResourceMetadataCache;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.search.Query;
import org.opennms.newts.api.search.SearchResults;
import org.opennms.newts.cassandra.search.CassandraIndexer;
import org.opennms.newts.cassandra.search.CassandraSearcher;
import org.opennms.newts.persistence.cassandra.CassandraSampleRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NewtsResourceStorageDao
implements ResourceStorageDao {
    private static final Logger LOG = LoggerFactory.getLogger(NewtsResourceStorageDao.class);
    @Autowired
    private Context m_context;
    @Autowired
    private CassandraSearcher m_searcher;
    @Autowired
    private CassandraSampleRepository m_sampleRepository;
    @Autowired
    private CassandraIndexer m_indexer;
    @Autowired
    private NewtsWriter m_newtsWriter;
    @Autowired
    private SearchableResourceMetadataCache m_searchableCache;

    public boolean exists(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        if (this.hasCachedEntry(path, depth, depth)) {
            return true;
        }
        return this.searchFor(path, depth, false).size() > 0;
    }

    public boolean existsWithin(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        if (this.hasCachedEntry(path, 0, depth)) {
            return true;
        }
        return IntStream.rangeClosed(0, depth).anyMatch(i -> this.searchFor(path, i, false).size() > 0);
    }

    public Set<ResourcePath> children(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        TreeSet matches = Sets.newTreeSet();
        SearchResults results = this.searchFor(path, depth, false);
        for (SearchResults.Result result : results) {
            ResourcePath child = NewtsResourceStorageDao.toChildResourcePath(path, result.getResource().getId());
            if (child == null) {
                LOG.warn("Encountered non-child resource {} when searching for {} with depth {}. Ignoring resource.", new Object[]{result.getResource(), path, depth});
                continue;
            }
            matches.add(child);
        }
        return matches;
    }

    public boolean delete(ResourcePath path) {
        SearchResults results = this.searchFor(path, 0, true);
        if (results.isEmpty()) {
            return false;
        }
        for (SearchResults.Result result : results) {
            this.m_sampleRepository.delete(this.m_context, result.getResource());
            this.m_indexer.delete(this.m_context, result.getResource());
        }
        return true;
    }

    public Set<OnmsAttribute> getAttributes(ResourcePath path) {
        HashSet attributes = Sets.newHashSet();
        Future stringAttributes = ForkJoinPool.commonPool().submit(this.getResourceAttributesCallable(path));
        SearchResults results = this.searchFor(path, 0, true);
        for (SearchResults.Result result : results) {
            String resourceId = result.getResource().getId();
            ResourcePath resultPath = NewtsUtils.toResourcePath(resourceId);
            if (!path.equals((Object)resultPath)) {
                LOG.warn("Encountered non-child resource {} when searching for {} with depth {}. Ignoring resource.", new Object[]{result.getResource(), path, 0});
                continue;
            }
            for (String metric : result.getMetrics()) {
                attributes.add(new RrdGraphAttribute(metric, "", resourceId));
            }
        }
        try {
            ((Map)stringAttributes.get()).entrySet().stream().map(e -> new StringPropertyAttribute((String)e.getKey(), (String)e.getValue())).forEach(attributes::add);
        }
        catch (InterruptedException | ExecutionException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
        return attributes;
    }

    public void setStringAttribute(ResourcePath path, String key, String value) {
        ImmutableMap attributes = new ImmutableMap.Builder().put((Object)key, (Object)value).build();
        Resource resource = new Resource(NewtsUtils.toResourceId(path), Optional.of((Object)attributes));
        Sample sample = NewtsUtils.createSampleForIndexingStrings(this.m_context, resource);
        this.m_newtsWriter.index(Lists.newArrayList((Object[])new Sample[]{sample}));
    }

    public String getStringAttribute(ResourcePath path, String key) {
        return this.getStringAttributes(path).get(key);
    }

    public Map<String, String> getStringAttributes(ResourcePath path) {
        return this.getMetaData(path);
    }

    public Map<String, String> getMetaData(ResourcePath path) {
        return this.m_searcher.getResourceAttributes(this.m_context, NewtsUtils.toResourceId(path));
    }

    private Callable<Map<String, String>> getResourceAttributesCallable(final ResourcePath path) {
        return new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                return NewtsResourceStorageDao.this.m_searcher.getResourceAttributes(NewtsResourceStorageDao.this.m_context, NewtsUtils.toResourceId(path));
            }
        };
    }

    public void updateMetricToResourceMappings(ResourcePath path, Map<String, String> metricsNameToResourceNames) {
    }

    private boolean hasCachedEntry(ResourcePath path, int minDepth, int maxDepth) {
        List<String> cachedResourceIds = this.m_searchableCache.getResourceIdsWithPrefix(this.m_context, NewtsUtils.toResourceId(path));
        for (String resourceId : cachedResourceIds) {
            int relativeDepth = path.relativeDepth(NewtsUtils.toResourcePath(resourceId));
            if (relativeDepth < minDepth || relativeDepth > maxDepth) continue;
            return true;
        }
        return false;
    }

    private SearchResults searchFor(ResourcePath path, int depth, boolean fetchMetrics) {
        Query q = NewtsUtils.findResourcesWithMetricsAtDepth(path, depth);
        LOG.trace("Searching for '{}'.", (Object)q);
        SearchResults results = this.m_searcher.search(this.m_context, q, fetchMetrics);
        LOG.trace("Found {} results.", (Object)results.size());
        return results;
    }

    protected static ResourcePath toChildResourcePath(ResourcePath parent, String resourceId) {
        String[] parentEls;
        ResourcePath child = NewtsUtils.toResourcePath(resourceId);
        String[] childEls = child.elements();
        if (childEls.length <= (parentEls = parent.elements()).length) {
            return null;
        }
        String[] els = new String[parentEls.length + 1];
        for (int i = 0; i <= parentEls.length; ++i) {
            els[i] = childEls[i];
        }
        return ResourcePath.get((String[])els);
    }

    @VisibleForTesting
    protected void setSearchableCache(SearchableResourceMetadataCache searchableCache) {
        this.m_searchableCache = searchableCache;
    }

    @VisibleForTesting
    protected void setSearcher(CassandraSearcher searcher) {
        this.m_searcher = searcher;
    }

    @VisibleForTesting
    protected void setContext(Context context) {
        this.m_context = context;
    }
}

