/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.cli;

import java.io.OutputStream;
import java.util.ServiceLoader;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opennms.netmgt.newts.cli.Command;
import org.opennms.newts.cassandra.Schema;
import org.opennms.newts.cassandra.SchemaManager;

public class Init
implements Command {
    private static ServiceLoader<Schema> s_schemas = ServiceLoader.load(Schema.class);
    @Option(name="-h", aliases={"--help"}, help=true)
    boolean showHelp = false;
    @Option(name="-p", aliases={"--print-only"}, usage="Prints the CQL statements instead of executing them.")
    boolean printOnly = false;
    @Option(name="-r", aliases={"--replication-factor"}, usage="Sets the replication factor to use when creating the keyspace.")
    int replicationFactor = 1;

    @Override
    public void execute() throws Exception {
        if (this.showHelp) {
            System.out.println("Usage: $OPENNMS_HOME/bin/newts init");
            CmdLineParser parser = new CmdLineParser((Object)new Init());
            parser.printUsage((OutputStream)System.out);
            return;
        }
        String keyspace = System.getProperty("org.opennms.newts.config.keyspace", "newts");
        String hostname = System.getProperty("org.opennms.newts.config.hostname", "localhost");
        int port = Integer.getInteger("org.opennms.newts.config.port", 9042);
        String username = System.getProperty("org.opennms.newts.config.username");
        String password = System.getProperty("org.opennms.newts.config.password");
        boolean ssl = Boolean.getBoolean("org.opennms.newts.config.ssl");
        System.out.println(String.format("Initializing the '%s' keyspaces on %s:%d", keyspace, hostname, port));
        try (SchemaManager m = new SchemaManager(keyspace, hostname, port, username, password, ssl);){
            m.setReplicationFactor(this.replicationFactor);
            for (Schema s : s_schemas) {
                m.create(s, true, this.printOnly);
            }
        }
        if (!this.printOnly) {
            System.out.println("The keyspace was succesfully created.");
        }
    }
}

