/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.newts;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.PersistOperationBuilder;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.DefaultTimeKeeper;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.newts.NewtsWriter;
import org.opennms.netmgt.newts.support.NewtsUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewtsPersistOperationBuilder
implements PersistOperationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(NewtsPersistOperationBuilder.class);
    private final NewtsWriter m_newtsWriter;
    private final RrdRepository m_repository;
    private final Context m_context;
    private final String m_name;
    private final ResourceIdentifier m_resource;
    private final Map<CollectionAttributeType, Number> m_declarations = Maps.newLinkedHashMap();
    private final Map<String, String> m_metaData = Maps.newLinkedHashMap();
    private final Map<ResourcePath, Map<String, String>> m_stringAttributesByPath = Maps.newLinkedHashMap();
    private TimeKeeper m_timeKeeper = new DefaultTimeKeeper();

    public NewtsPersistOperationBuilder(NewtsWriter newtsWriter, Context context, RrdRepository repository, ResourceIdentifier resource, String name) {
        this.m_newtsWriter = newtsWriter;
        this.m_context = context;
        this.m_repository = repository;
        this.m_resource = resource;
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setAttributeValue(CollectionAttributeType attributeType, Number value) {
        this.m_declarations.put(attributeType, value);
    }

    public void persistStringAttribute(ResourcePath path, String key, String value) {
        LinkedHashMap stringAttributesForPath = this.m_stringAttributesByPath.get(path);
        if (stringAttributesForPath == null) {
            stringAttributesForPath = Maps.newLinkedHashMap();
            this.m_stringAttributesByPath.put(path, stringAttributesForPath);
        }
        stringAttributesForPath.put(key, value);
    }

    public void setAttributeMetadata(String metricIdentifier, String name) {
        if (metricIdentifier == null) {
            if (name == null) {
                LOG.warn("Cannot set attribute metadata with null key and null value");
            } else {
                LOG.warn("Cannot set attribute metadata with null key and value of: {}", (Object)name);
            }
        } else {
            this.m_metaData.put(metricIdentifier, name);
        }
    }

    public void commit() throws PersistException {
        this.m_newtsWriter.insert(this.getSamplesToInsert());
        this.m_newtsWriter.index(this.getSamplesToIndex());
    }

    public List<Sample> getSamplesToInsert() {
        LinkedList samples = Lists.newLinkedList();
        ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.m_repository, (Path)this.m_resource.getPath().resolve(this.m_name));
        NewtsUtils.addIndicesToAttributes(path, this.m_metaData);
        Resource resource = new Resource(NewtsUtils.toResourceId(path), Optional.of(this.m_metaData));
        Timestamp timestamp = Timestamp.fromEpochMillis((long)this.m_timeKeeper.getCurrentTime());
        for (Map.Entry<CollectionAttributeType, Number> entry : this.m_declarations.entrySet()) {
            Number value;
            CollectionAttributeType attrType = entry.getKey();
            MetricType type = NewtsPersistOperationBuilder.mapType(attrType.getType());
            if (type == null || (value = entry.getValue()) == null) continue;
            samples.add(new Sample(timestamp, this.m_context, resource, attrType.getName(), type, ValueType.compose((Number)entry.getValue(), (MetricType)type)));
        }
        return samples;
    }

    public List<Sample> getSamplesToIndex() {
        LinkedList samples = Lists.newLinkedList();
        for (Map.Entry<ResourcePath, Map<String, String>> entry : this.m_stringAttributesByPath.entrySet()) {
            Resource resource = new Resource(NewtsUtils.toResourceId(entry.getKey()), Optional.of(entry.getValue()));
            samples.add(NewtsUtils.createSampleForIndexingStrings(this.m_context, resource));
        }
        return samples;
    }

    public static MetricType mapType(AttributeType type) {
        switch (type) {
            case COUNTER: {
                return MetricType.COUNTER;
            }
            case GAUGE: {
                return MetricType.GAUGE;
            }
            case STRING: {
                return null;
            }
        }
        return MetricType.GAUGE;
    }

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }
}

