/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.api.search.BooleanQuery;
import org.opennms.newts.api.search.Operator;
import org.opennms.newts.api.search.Query;
import org.opennms.newts.api.search.Term;
import org.opennms.newts.api.search.TermQuery;
import org.opennms.newts.cassandra.search.CassandraIndexingOptions;
import org.opennms.newts.cassandra.search.EscapableResourceIdSplitter;
import org.opennms.newts.cassandra.search.ResourceIdSplitter;

public abstract class NewtsUtils {
    public static final boolean DISABLE_INDEXING = Boolean.getBoolean("org.opennms.newts.disable.indexing");
    public static final int MAX_BATCH_SIZE = Integer.getInteger("org.opennms.newts.config.max_batch_size", 16);
    public static final int TTL = Integer.getInteger("org.opennms.newts.config.ttl", 31536000);
    public static final String HOSTNAME_PROPERTY = "org.opennms.newts.config.hostname";
    public static final String KEYSPACE_PROPERTY = "org.opennms.newts.config.keyspace";
    public static final String PORT_PROPERTY = "org.opennms.newts.config.port";
    public static final String TTL_PROPERTY = "org.opennms.newts.config.ttl";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_KEYSPACE = "newts";
    public static final String DEFAULT_PORT = "9043";
    public static final String DEFAULT_TTL = "31536000";
    public static final CassandraIndexingOptions INDEXING_OPTIONS = new CassandraIndexingOptions.Builder().withHierarchicalIndexing(false).withIndexResourceTerms(false).withIndexUsingDefaultTerm(false).withMaxBatchSize(MAX_BATCH_SIZE).build();
    private static final ResourceIdSplitter s_splitter = new EscapableResourceIdSplitter();
    private static final Timestamp EPOCH = Timestamp.fromEpochMillis((long)0L);
    private static final ValueType<?> ZERO = ValueType.compose((Number)0, (MetricType)MetricType.GAUGE);

    public static void addIndicesToAttributes(ResourcePath path, Map<String, String> attributes) {
        List<String> els = Arrays.asList(path.elements());
        int N = els.size();
        for (int i = 0; i < N; ++i) {
            String id = s_splitter.joinElementsToId(els.subList(0, i + 1));
            attributes.put("_idx" + i, String.format("(%s,%d)", id, N));
        }
    }

    public static Query findResourcesWithMetricsAtDepth(ResourcePath path, int depth) {
        int idxSuffix = path.elements().length - 1;
        int targetLen = idxSuffix + depth + 2;
        TermQuery tq = new TermQuery(new Term("_idx" + idxSuffix, String.format("(%s,%d)", NewtsUtils.toResourceId(path), targetLen)));
        BooleanQuery q = new BooleanQuery();
        q.add((Query)tq, Operator.OR);
        return q;
    }

    public static String toResourceId(ResourcePath path) {
        return s_splitter.joinElementsToId(Arrays.asList(path.elements()));
    }

    public static ResourcePath toResourcePath(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        List els = s_splitter.splitIdIntoElements(resourceId);
        return ResourcePath.get(els.subList(0, els.size() - 1));
    }

    public static Sample createSampleForIndexingStrings(Context context, Resource resource) {
        return new Sample(EPOCH, context, resource, "strings", MetricType.GAUGE, ZERO);
    }
}

