/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support;

import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.newts.support.GuavaSearchableResourceMetadataCache;
import org.opennms.newts.api.Context;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.search.CassandraCachePrimer;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class CachePrimer
implements InitializingBean,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CachePrimer.class);
    @Autowired(required=false)
    private GuavaSearchableResourceMetadataCache resourceMetadataCache;
    @Autowired
    private CassandraSession session;
    @Autowired
    private Context context;
    private static final boolean primingEnabled = Boolean.getBoolean("org.opennms.newts.config.cache.priming.enable");
    private static final long blockWhilePrimingMs = Long.getLong("org.opennms.newts.config.cache.priming.block_ms", TimeUnit.MINUTES.toMillis(2L));
    private static final int fetchSize = Integer.getInteger("org.opennms.newts.config.cache.priming.fetch_size", 10000);
    private static final int fetchMoreThreshold = Integer.getInteger("org.opennms.newts.config.cache.priming.fetch_more_threshold", 1000);

    public void afterPropertiesSet() {
        if (!primingEnabled) {
            LOG.debug("Cache priming disabled. Skipping cache priming.");
            return;
        }
        if (this.resourceMetadataCache == null) {
            LOG.debug("Resource meta-data cache is not of type {}. Skipping cache priming.", (Object)GuavaSearchableResourceMetadataCache.class.getCanonicalName());
            return;
        }
        Thread thread = new Thread(this);
        thread.setName("Newts-CachePrimer");
        thread.start();
        if (blockWhilePrimingMs >= 0L) {
            try {
                if (blockWhilePrimingMs == 0L) {
                    LOG.info("Blocking startup while waiting for cache to be fully primed.");
                } else {
                    LOG.info("Blocking startup for up-to {}ms while waiting for cache to be primed.", (Object)blockWhilePrimingMs);
                }
                thread.join(blockWhilePrimingMs);
                if (thread.isAlive()) {
                    LOG.info("Cache is not yet done priming after waiting for {}ms. Current size is: {}. The operation will continue in the background.", (Object)blockWhilePrimingMs, (Object)this.resourceMetadataCache.getSize());
                }
            }
            catch (InterruptedException e) {
                LOG.info("Thread was interrupted while waiting for the cache to be primed.");
            }
        }
    }

    @Override
    public void run() {
        CassandraCachePrimer primer = new CassandraCachePrimer(this.session);
        primer.setFetchSize(fetchSize);
        primer.setFetchMoreThreshold(fetchMoreThreshold);
        LOG.info("Starting to prime the cache.");
        primer.prime((ResourceMetadataCache)this.resourceMetadataCache, this.context);
        LOG.info("Done priming cache. Cache size: {}", (Object)this.resourceMetadataCache.getSize());
    }
}

