/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.measurements.utils.Utils;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.SampleSelectCallback;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.AggregationFunction;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.api.query.StandardAggregationFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NewtsFetchStrategy
implements MeasurementFetchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NewtsFetchStrategy.class);
    public static final long MIN_STEP_MS = Long.getLong("org.opennms.newts.query.minimum_step", 300000L);
    public static final int INTERVAL_DIVIDER = Integer.getInteger("org.opennms.newts.query.interval_divider", 2);
    public static final long DEFAULT_HEARTBEAT_MS = Long.getLong("org.opennms.newts.query.heartbeat", 450000L);
    public static final int PARALLELISM = Integer.getInteger("org.opennms.newts.query.parallelism", Runtime.getRuntime().availableProcessors());
    @Autowired
    private Context m_context;
    @Autowired
    private ResourceDao m_resourceDao;
    @Autowired
    private SampleRepository m_sampleRepository;
    private final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("NewtsFetchStrateg-%d").build();
    private final ExecutorService threadPool = Executors.newCachedThreadPool(this.namedThreadFactory);
    private final Semaphore availableAggregationThreads = new Semaphore(PARALLELISM);
    private SampleSelectCallback limitConcurrentAggregationsCallback = new SampleSelectCallback(){

        public void beforeProcess() {
            try {
                NewtsFetchStrategy.this.availableAggregationThreads.acquire();
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void afterProcess() {
            NewtsFetchStrategy.this.availableAggregationThreads.release();
        }
    };

    /*
     * WARNING - void declaration
     */
    public FetchResults fetch(long start, long end, long step, int maxrows, Long interval, Long heartbeat, List<Source> sources, boolean relaxed) {
        void var21_28;
        LateAggregationParams lag = NewtsFetchStrategy.getLagParams(step, interval, heartbeat);
        Optional startTs = Optional.of((Object)Timestamp.fromEpochMillis((long)start));
        Optional endTs = Optional.of((Object)Timestamp.fromEpochMillis((long)end));
        HashMap constants = Maps.newHashMap();
        Map<String, List<Source>> sourcesByResourceId = sources.stream().collect(Collectors.groupingBy(Source::getResourceId));
        HashMap resourceFuturesById = Maps.newHashMapWithExpectedSize((int)sourcesByResourceId.size());
        for (String string : sourcesByResourceId.keySet()) {
            resourceFuturesById.put(string, this.threadPool.submit(this.getResourceByIdCallable(string)));
        }
        HashMap sourcesByResource = Maps.newHashMapWithExpectedSize((int)sourcesByResourceId.size());
        for (Map.Entry entry : resourceFuturesById.entrySet()) {
            try {
                OnmsResource onmsResource = (OnmsResource)((Future)entry.getValue()).get();
                if (onmsResource == null) {
                    if (relaxed) continue;
                    LOG.error("No resource with id: {}", entry.getKey());
                    return null;
                }
                sourcesByResource.put(onmsResource, sourcesByResourceId.get(entry.getKey()));
            }
            catch (InterruptedException | ExecutionException exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        }
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry entry : sourcesByResource.entrySet()) {
            OnmsResource onmsResource = (OnmsResource)entry.getKey();
            for (Source source : (List)entry.getValue()) {
                List listOfSources;
                Utils.convertStringAttributesToConstants((String)source.getLabel(), (Map)onmsResource.getStringPropertyAttributes(), (Map)constants);
                RrdGraphAttribute rrdGraphAttribute = (RrdGraphAttribute)onmsResource.getRrdGraphAttributes().get(source.getAttribute());
                if (rrdGraphAttribute == null && !Strings.isNullOrEmpty((String)source.getFallbackAttribute())) {
                    LOG.error("No attribute with name '{}', using fallback-attribute with name '{}'", (Object)source.getAttribute(), (Object)source.getFallbackAttribute());
                    source.setAttribute(source.getFallbackAttribute());
                    source.setFallbackAttribute(null);
                    rrdGraphAttribute = (RrdGraphAttribute)onmsResource.getRrdGraphAttributes().get(source.getAttribute());
                }
                if (rrdGraphAttribute == null) {
                    if (relaxed) continue;
                    LOG.error("No attribute with name: {}", (Object)source.getAttribute());
                    return null;
                }
                String newtsResourceId = rrdGraphAttribute.getRrdRelativePath();
                if (newtsResourceId.startsWith(File.separator)) {
                    newtsResourceId = newtsResourceId.substring(File.separator.length(), newtsResourceId.length());
                }
                if ((listOfSources = (List)hashMap.get(newtsResourceId)) == null) {
                    listOfSources = Lists.newLinkedList();
                    hashMap.put(newtsResourceId, listOfSources);
                }
                listOfSources.add(source);
            }
        }
        HashMap hashMap2 = Maps.newHashMapWithExpectedSize((int)hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), this.threadPool.submit(this.getMeasurementsForResourceCallable((String)entry.getKey(), (List)entry.getValue(), (Optional<Timestamp>)startTs, (Optional<Timestamp>)endTs, lag)));
        }
        Object var21_27 = null;
        HashMap hashMap3 = Maps.newHashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            int k;
            Collection rows;
            try {
                rows = (Collection)((Future)entry.getValue()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int N = rows.size();
            if (var21_28 == null) {
                long[] lArray = new long[N];
                k = 0;
                for (Results.Row row : rows) {
                    lArray[k] = row.getTimestamp().asMillis();
                    ++k;
                }
            }
            k = 0;
            for (Results.Row row : rows) {
                for (Measurement measurement : row.getElements()) {
                    double[] column = (double[])hashMap3.get(measurement.getName());
                    if (column == null) {
                        column = new double[N];
                        hashMap3.put(measurement.getName(), column);
                    }
                    column[k] = measurement.getValue();
                }
                ++k;
            }
        }
        FetchResults fetchResults = new FetchResults((long[])var21_28, (Map)hashMap3, lag.getStep(), (Map)constants);
        if (relaxed) {
            Utils.fillMissingValues((FetchResults)fetchResults, sources);
        }
        LOG.trace("Fetch results: {}", (Object)fetchResults);
        return fetchResults;
    }

    private Callable<OnmsResource> getResourceByIdCallable(final String resourceId) {
        return new Callable<OnmsResource>(){

            @Override
            public OnmsResource call() throws IllegalArgumentException {
                OnmsResource resource = NewtsFetchStrategy.this.m_resourceDao.getResourceById(resourceId);
                if (resource != null) {
                    resource.getAttributes();
                }
                return resource;
            }
        };
    }

    private Callable<Collection<Results.Row<Measurement>>> getMeasurementsForResourceCallable(final String newtsResourceId, final List<Source> listOfSources, final Optional<Timestamp> start, final Optional<Timestamp> end, final LateAggregationParams lag) {
        return new Callable<Collection<Results.Row<Measurement>>>(){

            @Override
            public Collection<Results.Row<Measurement>> call() throws Exception {
                ResultDescriptor resultDescriptor = new ResultDescriptor(lag.getInterval());
                for (Source source : listOfSources) {
                    String metricName = source.getDataSource() != null ? source.getDataSource() : source.getAttribute();
                    String name = source.getLabel();
                    AggregationFunction fn = NewtsFetchStrategy.toAggregationFunction(source.getAggregation());
                    resultDescriptor.datasource(name, metricName, lag.getHeartbeat(), fn);
                    resultDescriptor.export(new String[]{name});
                }
                LOG.debug("Querying Newts for resource id {} with result descriptor: {}", (Object)newtsResourceId, (Object)resultDescriptor);
                Results results = NewtsFetchStrategy.this.m_sampleRepository.select(NewtsFetchStrategy.this.m_context, new Resource(newtsResourceId), start, end, resultDescriptor, Optional.of((Object)Duration.millis((long)lag.getStep())), NewtsFetchStrategy.this.limitConcurrentAggregationsCallback);
                Collection rows = results.getRows();
                LOG.debug("Found {} rows.", (Object)rows.size());
                return rows;
            }
        };
    }

    private static AggregationFunction toAggregationFunction(String fn) {
        if ("average".equalsIgnoreCase(fn) || "avg".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.AVERAGE;
        }
        if ("max".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MAX;
        }
        if ("min".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MIN;
        }
        throw new IllegalArgumentException("Unsupported aggregation function: " + fn);
    }

    @VisibleForTesting
    protected static LateAggregationParams getLagParams(long step, Long interval, Long heartbeat) {
        long effectiveHeartbeat;
        long effectiveStep = Math.max(MIN_STEP_MS, step);
        if (effectiveStep != step) {
            LOG.warn("Requested step size {} is too small. Using {}.", (Object)step, (Object)effectiveStep);
        }
        long effectiveInterval = 0L;
        if (interval != null && interval < effectiveStep && effectiveStep % interval == 0L) {
            effectiveInterval = interval;
        } else {
            if (effectiveStep % (long)INTERVAL_DIVIDER != 0L) {
                effectiveStep += effectiveStep % (long)INTERVAL_DIVIDER;
            }
            effectiveInterval = effectiveStep / (long)INTERVAL_DIVIDER;
        }
        long l = effectiveHeartbeat = heartbeat != null ? heartbeat : DEFAULT_HEARTBEAT_MS;
        if (effectiveInterval < effectiveHeartbeat) {
            if (effectiveHeartbeat % effectiveInterval != 0L) {
                effectiveHeartbeat += effectiveInterval - effectiveHeartbeat % effectiveInterval;
            }
        } else {
            effectiveHeartbeat = effectiveInterval + 1L;
            effectiveHeartbeat += effectiveHeartbeat % effectiveInterval;
        }
        return new LateAggregationParams(effectiveStep, effectiveInterval, effectiveHeartbeat);
    }

    @VisibleForTesting
    protected void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    @VisibleForTesting
    protected void setSampleRepository(SampleRepository sampleRepository) {
        this.m_sampleRepository = sampleRepository;
    }

    @VisibleForTesting
    protected void setContext(Context context) {
        this.m_context = context;
    }

    @VisibleForTesting
    protected static class LateAggregationParams {
        final long step;
        final long interval;
        final long heartbeat;

        public LateAggregationParams(long step, long interval, long heartbeat) {
            this.step = step;
            this.interval = interval;
            this.heartbeat = heartbeat;
        }

        public long getStep() {
            return this.step;
        }

        public long getInterval() {
            return this.interval;
        }

        public long getHeartbeat() {
            return this.heartbeat;
        }
    }
}

