/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.cli;

import java.util.ServiceLoader;
import org.opennms.netmgt.newts.cli.Command;
import org.opennms.newts.cassandra.Schema;
import org.opennms.newts.cassandra.SchemaManager;

public class Init
implements Command {
    private static ServiceLoader<Schema> s_schemas = ServiceLoader.load(Schema.class);

    @Override
    public void execute() throws Exception {
        String keyspace = System.getProperty("org.opennms.newts.config.keyspace", "newts");
        String hostname = System.getProperty("org.opennms.newts.config.hostname", "localhost");
        int port = Integer.getInteger("org.opennms.newts.config.port", 9042);
        String username = System.getProperty("org.opennms.newts.config.username");
        String password = System.getProperty("org.opennms.newts.config.password");
        System.out.println(String.format("Initializing the '%s' keyspaces on %s:%d", keyspace, hostname, port));
        try (SchemaManager m = new SchemaManager(keyspace, hostname, port, username, password);){
            for (Schema s : s_schemas) {
                m.create(s, true);
            }
        }
        System.out.println("The keyspace was succesfully created.");
    }
}

