/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.netmgt.newts.support.SearchableResourceMetadataCache;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaSearchableResourceMetadataCache
implements SearchableResourceMetadataCache,
RemovalListener<String, ResourceMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaSearchableResourceMetadataCache.class);
    private static final Joiner m_keyJoiner = Joiner.on((char)':');
    private final Cache<String, ResourceMetadata> m_cache;
    private final ConcurrentRadixTree<ResourceMetadata> m_radixTree = new ConcurrentRadixTree((NodeFactory)new DefaultCharArrayNodeFactory());
    private final Meter m_metricReqs;
    private final Meter m_attributeReqs;
    private final Meter m_metricMisses;
    private final Meter m_attributeMisses;

    @Inject
    public GuavaSearchableResourceMetadataCache(final @Named(value="search.resourceMetadata.maxCacheEntries") long maxSize, MetricRegistry registry) {
        LOG.info("Initializing resource metadata cache ({} max entries)", (Object)maxSize);
        this.m_cache = CacheBuilder.newBuilder().maximumSize(maxSize).removalListener((RemovalListener)this).build();
        this.m_metricReqs = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"metric-reqs"}));
        this.m_metricMisses = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"metric-misses"}));
        this.m_attributeReqs = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"attribute-reqs"}));
        this.m_attributeMisses = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"attribute-misses"}));
        registry.register(MetricRegistry.name((String)"cache", (String[])new String[]{"size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return GuavaSearchableResourceMetadataCache.this.m_cache.size();
            }
        });
        registry.register(MetricRegistry.name((String)"cache", (String[])new String[]{"max-size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return maxSize;
            }
        });
    }

    public Optional<ResourceMetadata> get(Context context, Resource resource) {
        ResourceMetadata r = (ResourceMetadata)this.m_cache.getIfPresent((Object)this.key(context, resource.getId()));
        return r != null ? Optional.of((Object)r) : Optional.absent();
    }

    public void delete(Context context, Resource resource) {
        this.m_cache.invalidate((Object)this.key(context, resource.getId()));
    }

    private String key(Context context, String resourceId) {
        return m_keyJoiner.join((Object)context.getId(), (Object)resourceId, new Object[0]);
    }

    private String resourceId(Context context, String key) {
        return key.substring(context.getId().length() + 1);
    }

    public void merge(Context context, Resource resource, ResourceMetadata metadata) {
        Optional<ResourceMetadata> o = this.get(context, resource);
        if (!o.isPresent()) {
            ResourceMetadata newMetadata = new ResourceMetadata(this.m_metricReqs, this.m_attributeReqs, this.m_metricMisses, this.m_attributeMisses);
            newMetadata.merge(metadata);
            String key = this.key(context, resource.getId());
            this.m_cache.put((Object)key, (Object)newMetadata);
            this.m_radixTree.put((CharSequence)key, (Object)newMetadata);
            return;
        }
        ((ResourceMetadata)o.get()).merge(metadata);
    }

    @Override
    public List<String> getResourceIdsWithPrefix(Context context, String resourceIdPrefix) {
        return StreamSupport.stream(this.m_radixTree.getKeysStartingWith((CharSequence)this.key(context, resourceIdPrefix)).spliterator(), false).map(cs -> this.resourceId(context, cs.toString())).collect(Collectors.toList());
    }

    public void onRemoval(RemovalNotification<String, ResourceMetadata> notification) {
        this.m_radixTree.remove((CharSequence)notification.getKey());
    }
}

