/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommandHandler;
import org.kohsuke.args4j.spi.SubCommands;
import org.opennms.netmgt.newts.cli.Command;
import org.opennms.netmgt.newts.cli.Init;

public class Newts {
    @Argument(handler=SubCommandHandler.class, required=true)
    @SubCommands(value={@SubCommand(name="init", impl=Init.class)})
    Command cmd;

    public static void main(String[] args) throws Exception {
        Newts.loadOpenNMSProperties();
        Newts cli = new Newts();
        CmdLineParser parser = new CmdLineParser((Object)cli);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.out.println("Usage: $OPENNMS_HOME/bin/newts init");
            return;
        }
        cli.cmd.execute();
    }

    private static void loadOpenNMSProperties() throws FileNotFoundException, IOException {
        File props = Paths.get(System.getProperty("opennms.home"), "etc", "opennms.properties").toFile();
        if (!props.canRead()) {
            throw new IOException("Cannot read opennms.properties file: " + props);
        }
        try (FileInputStream fis = new FileInputStream(props);){
            Properties p = new Properties();
            p.load(fis);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String propertyName = entry.getKey().toString();
                Object value = entry.getValue();
                if (System.getProperty(propertyName) != null || value == null) continue;
                System.setProperty(propertyName, value.toString());
            }
        }
    }
}

