/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.measurements.utils.Utils;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.AggregationFunction;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.api.query.StandardAggregationFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NewtsFetchStrategy
implements MeasurementFetchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NewtsFetchStrategy.class);
    public static final long MIN_STEP_MS = Long.getLong("org.opennms.newts.query.minimum_step", 30000L);
    public static final int INTERVAL_DIVIDER = Integer.getInteger("org.opennms.newts.query.interval_divider", 2);
    public static final long DEFAULT_HEARTBEAT_MS = Long.getLong("org.opennms.newts.query.heartbeat", 450000L);
    @Autowired
    private Context m_context;
    @Autowired
    private ResourceDao m_resourceDao;
    @Autowired
    private SampleRepository m_sampleRepository;

    public FetchResults fetch(long start, long end, long step, int maxrows, Long interval, Long heartbeat, List<Source> sources) {
        LateAggregationParams lag = NewtsFetchStrategy.getLagParams(step, interval, heartbeat);
        Optional startTs = Optional.of((Object)Timestamp.fromEpochMillis((long)start));
        Optional endTs = Optional.of((Object)Timestamp.fromEpochMillis((long)end));
        HashMap constants = Maps.newHashMap();
        Map<String, List<Source>> sourcesByResourceId = sources.stream().collect(Collectors.groupingBy(Source::getResourceId));
        Map<OnmsResource, List> sourcesByResource = sourcesByResourceId.entrySet().parallelStream().collect(Collectors.toMap(e -> {
            OnmsResource resource = this.m_resourceDao.getResourceById((String)e.getKey());
            if (resource == null) {
                LOG.error("No resource with id: {}", e.getKey());
                throw new IllegalArgumentException("No resource with id: " + (String)e.getKey());
            }
            resource.getAttributes();
            return resource;
        }, e -> (List)e.getValue()));
        HashMap sourcesByNewtsResourceId = Maps.newHashMap();
        for (Map.Entry<OnmsResource, List> entry2 : sourcesByResource.entrySet()) {
            OnmsResource resource = entry2.getKey();
            for (Source source : entry2.getValue()) {
                List listOfSources;
                Utils.convertStringAttributesToConstants((String)source.getLabel(), (Map)resource.getStringPropertyAttributes(), (Map)constants);
                RrdGraphAttribute rrdGraphAttribute = (RrdGraphAttribute)resource.getRrdGraphAttributes().get(source.getAttribute());
                if (rrdGraphAttribute == null && !Strings.isNullOrEmpty((String)source.getFallbackAttribute())) {
                    LOG.error("No attribute with name '{}', using fallback-attribute with name '{}'", (Object)source.getAttribute(), (Object)source.getFallbackAttribute());
                    source.setAttribute(source.getFallbackAttribute());
                    source.setFallbackAttribute(null);
                    rrdGraphAttribute = (RrdGraphAttribute)resource.getRrdGraphAttributes().get(source.getAttribute());
                }
                if (rrdGraphAttribute == null) {
                    LOG.error("No attribute with name: {}", (Object)source.getAttribute());
                    return null;
                }
                String newtsResourceId = rrdGraphAttribute.getRrdRelativePath();
                if (newtsResourceId.startsWith(File.separator)) {
                    newtsResourceId = newtsResourceId.substring(File.separator.length(), newtsResourceId.length());
                }
                if ((listOfSources = (List)sourcesByNewtsResourceId.get(newtsResourceId)) == null) {
                    listOfSources = Lists.newLinkedList();
                    sourcesByNewtsResourceId.put(newtsResourceId, listOfSources);
                }
                listOfSources.add(source);
            }
        }
        AtomicReference timestamps = new AtomicReference();
        ConcurrentMap columns = Maps.newConcurrentMap();
        sourcesByNewtsResourceId.entrySet().parallelStream().forEach(entry -> {
            String newtsResourceId = (String)entry.getKey();
            List listOfSources = (List)entry.getValue();
            ResultDescriptor resultDescriptor = new ResultDescriptor(lag.getInterval());
            for (Source source : listOfSources) {
                String metricName = source.getAttribute();
                String name = source.getLabel();
                AggregationFunction fn = NewtsFetchStrategy.toAggregationFunction(source.getAggregation());
                resultDescriptor.datasource(name, metricName, lag.getHeartbeat(), fn);
                resultDescriptor.export(new String[]{name});
            }
            LOG.debug("Querying Newts for resource id {} with result descriptor: {}", (Object)newtsResourceId, (Object)resultDescriptor);
            Results results = this.m_sampleRepository.select(this.m_context, new Resource(newtsResourceId), startTs, endTs, resultDescriptor, Optional.of((Object)Duration.millis((long)lag.getStep())));
            Collection rows = results.getRows();
            LOG.debug("Found {} rows.", (Object)rows.size());
            int N = rows.size();
            HashMap myColumns = Maps.newHashMap();
            timestamps.updateAndGet(existing -> {
                if (existing == null) {
                    long[] tses = new long[rows.size()];
                    int k = 0;
                    for (Results.Row row : results.getRows()) {
                        tses[k] = row.getTimestamp().asMillis();
                        ++k;
                    }
                    return tses;
                }
                return existing;
            });
            int k = 0;
            for (Results.Row row : results.getRows()) {
                for (Measurement measurement : row.getElements()) {
                    double[] column = (double[])myColumns.get(measurement.getName());
                    if (column == null) {
                        column = new double[N];
                        myColumns.put(measurement.getName(), column);
                    }
                    column[k] = measurement.getValue();
                }
                ++k;
            }
            columns.putAll(myColumns);
        });
        FetchResults fetchResults = new FetchResults((long[])timestamps.get(), (Map)columns, lag.getStep(), (Map)constants);
        LOG.trace("Fetch results: {}", (Object)fetchResults);
        return fetchResults;
    }

    private static AggregationFunction toAggregationFunction(String fn) {
        if ("average".equalsIgnoreCase(fn) || "avg".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.AVERAGE;
        }
        if ("max".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MAX;
        }
        if ("min".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MIN;
        }
        throw new IllegalArgumentException("Unsupported aggregation function: " + fn);
    }

    @VisibleForTesting
    protected static LateAggregationParams getLagParams(long step, Long interval, Long heartbeat) {
        long effectiveHeartbeat;
        long effectiveStep = Math.max(MIN_STEP_MS, step);
        if (effectiveStep != step) {
            LOG.warn("Requested step size {} is too small. Using {}.", (Object)step, (Object)effectiveStep);
        }
        long effectiveInterval = 0L;
        if (interval != null && interval < effectiveStep && effectiveStep % interval == 0L) {
            effectiveInterval = interval;
        } else {
            if (effectiveStep % (long)INTERVAL_DIVIDER != 0L) {
                effectiveStep += effectiveStep % (long)INTERVAL_DIVIDER;
            }
            effectiveInterval = effectiveStep / (long)INTERVAL_DIVIDER;
        }
        long l = effectiveHeartbeat = heartbeat != null ? heartbeat : DEFAULT_HEARTBEAT_MS;
        if (effectiveInterval < effectiveHeartbeat) {
            if (effectiveHeartbeat % effectiveInterval != 0L) {
                effectiveHeartbeat += effectiveHeartbeat % effectiveInterval;
            }
        } else {
            effectiveHeartbeat = effectiveInterval + 1L;
            effectiveHeartbeat += effectiveHeartbeat % effectiveInterval;
        }
        return new LateAggregationParams(effectiveStep, effectiveInterval, effectiveHeartbeat);
    }

    @VisibleForTesting
    protected void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    @VisibleForTesting
    protected void setSampleRepository(SampleRepository sampleRepository) {
        this.m_sampleRepository = sampleRepository;
    }

    @VisibleForTesting
    protected void setContext(Context context) {
        this.m_context = context;
    }

    @VisibleForTesting
    protected static class LateAggregationParams {
        final long step;
        final long interval;
        final long heartbeat;

        public LateAggregationParams(long step, long interval, long heartbeat) {
            this.step = step;
            this.interval = interval;
            this.heartbeat = heartbeat;
        }

        public long getStep() {
            return this.step;
        }

        public long getInterval() {
            return this.interval;
        }

        public long getHeartbeat() {
            return this.heartbeat;
        }
    }
}

