/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.nustaq.serialization.FSTConfiguration;
import org.opennms.netmgt.newts.support.SearchableResourceMetadataCache;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.cassandra.search.ResourceIdSplitter;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

public class RedisResourceMetadataCache
implements SearchableResourceMetadataCache {
    private static final String METADATA_PREFIX = "_M";
    private static final String SEARCH_PREFIX = "_S";
    private static final FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
    private static final Joiner m_keyJoiner = Joiner.on((char)':');
    private final ResourceIdSplitter m_resourceIdSplitter;
    private final Jedis m_jedis;
    private final Meter m_metricReqs;
    private final Meter m_attributeReqs;
    private final Meter m_metricMisses;
    private final Meter m_attributeMisses;

    @Inject
    public RedisResourceMetadataCache(@Named(value="redis.hostname") String hostname, @Named(value="redis.port") Integer port, MetricRegistry registry, ResourceIdSplitter resourceIdSplitter) {
        Preconditions.checkNotNull((Object)hostname, (Object)" hostname argument");
        Preconditions.checkNotNull((Object)port, (Object)"port argument");
        this.m_jedis = new Jedis(hostname, port.intValue());
        Preconditions.checkNotNull((Object)registry, (Object)"registry argument");
        this.m_metricReqs = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"metric-reqs"}));
        this.m_metricMisses = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"metric-misses"}));
        this.m_attributeReqs = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"attribute-reqs"}));
        this.m_attributeMisses = registry.meter(MetricRegistry.name((String)"cache", (String[])new String[]{"attribute-misses"}));
        registry.register(MetricRegistry.name((String)"cache", (String[])new String[]{"size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RedisResourceMetadataCache.this.m_jedis.dbSize();
            }
        });
        registry.register(MetricRegistry.name((String)"cache", (String[])new String[]{"max-size"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return 0L;
            }
        });
        this.m_resourceIdSplitter = (ResourceIdSplitter)Preconditions.checkNotNull((Object)resourceIdSplitter, (Object)"resourceIdSplitter argument");
    }

    public void merge(Context context, Resource resource, ResourceMetadata metadata) {
        Optional<ResourceMetadata> o = this.get(context, resource);
        if (!o.isPresent()) {
            ResourceMetadata newMetadata = new ResourceMetadata(this.m_metricReqs, this.m_attributeReqs, this.m_metricMisses, this.m_attributeMisses);
            newMetadata.merge(metadata);
            Transaction t = this.m_jedis.multi();
            byte[] key = RedisResourceMetadataCache.key(METADATA_PREFIX, context.getId(), resource.getId());
            t.set(key, conf.asByteArray((Object)newMetadata));
            ArrayList elements = Lists.newArrayList((Object[])new String[]{SEARCH_PREFIX, context.getId()});
            for (String el : this.m_resourceIdSplitter.splitIdIntoElements(resource.getId())) {
                elements.add(el);
                t.lpush(this.m_resourceIdSplitter.joinElementsToId((List)elements).getBytes(), (byte[][])new byte[][]{key});
            }
            t.exec();
        } else if (((ResourceMetadata)o.get()).merge(metadata)) {
            this.m_jedis.set(RedisResourceMetadataCache.key(METADATA_PREFIX, context.getId(), resource.getId()), conf.asByteArray((Object)metadata));
        }
    }

    public Optional<ResourceMetadata> get(Context context, Resource resource) {
        byte[] bytes = this.m_jedis.get(RedisResourceMetadataCache.key(METADATA_PREFIX, context.getId(), resource.getId()));
        return bytes != null ? Optional.of((Object)((ResourceMetadata)conf.asObject(bytes))) : Optional.absent();
    }

    public void delete(Context context, Resource resource) {
        this.m_jedis.del(RedisResourceMetadataCache.key(METADATA_PREFIX, context.getId(), resource.getId()));
    }

    @Override
    public List<String> getResourceIdsWithPrefix(Context context, String resourceIdPrefix) {
        ArrayList elements = Lists.newArrayList((Object[])new String[]{SEARCH_PREFIX, context.getId()});
        elements.addAll(this.m_resourceIdSplitter.splitIdIntoElements(resourceIdPrefix));
        return this.m_jedis.lrange(this.m_resourceIdSplitter.joinElementsToId((List)elements).getBytes(), 0L, -1L).stream().map(bytes -> this.resourceId(METADATA_PREFIX, context.getId(), (byte[])bytes)).collect(Collectors.toList());
    }

    private static byte[] key(String prefix, String contextId, String resourceId) {
        return m_keyJoiner.join((Object)prefix, (Object)contextId, new Object[]{resourceId}).getBytes();
    }

    private String resourceId(String prefix, String contextId, byte[] key) {
        return new String(key).substring(prefix.length() + contextId.length() + 2);
    }
}

