/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.measurements.utils.Utils;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.AggregationFunction;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.api.query.StandardAggregationFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NewtsFetchStrategy
implements MeasurementFetchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NewtsFetchStrategy.class);
    private static final int HEARTBEAT_MULTIPLIER = 3;
    private static final int RESOLUTION_MULTIPLIER = 2;
    private static final int STEP_LOWER_BOUND_IN_MS = 30000;
    @Autowired
    private Context m_context;
    @Autowired
    private ResourceDao m_resourceDao;
    @Autowired
    private SampleRepository m_sampleRepository;

    public FetchResults fetch(long start, long end, long step, int maxrows, List<Source> sources) {
        long fetchStep = Math.max(30000L, step);
        if (fetchStep != step) {
            LOG.warn("Requested step size {} is too small. Using {}.", (Object)step, (Object)fetchStep);
        }
        Optional startTs = Optional.of((Object)Timestamp.fromEpochMillis((long)start));
        Optional endTs = Optional.of((Object)Timestamp.fromEpochMillis((long)end));
        HashMap constants = Maps.newHashMap();
        Map<String, List<Source>> sourcesByResourceId = sources.stream().collect(Collectors.groupingBy(Source::getResourceId));
        Map<OnmsResource, List> sourcesByResource = sourcesByResourceId.entrySet().parallelStream().collect(Collectors.toMap(e -> {
            OnmsResource resource = this.m_resourceDao.getResourceById((String)e.getKey());
            if (resource == null) {
                LOG.error("No resource with id: {}", e.getKey());
                throw new IllegalArgumentException("No resource with id: " + (String)e.getKey());
            }
            resource.getAttributes();
            return resource;
        }, e -> (List)e.getValue()));
        HashMap sourcesByNewtsResourceId = Maps.newHashMap();
        for (Map.Entry<OnmsResource, List> entry2 : sourcesByResource.entrySet()) {
            OnmsResource resource = entry2.getKey();
            for (Source source : entry2.getValue()) {
                List listOfSources;
                Utils.convertStringAttributesToConstants((String)source.getLabel(), (Map)resource.getStringPropertyAttributes(), (Map)constants);
                RrdGraphAttribute rrdGraphAttribute = (RrdGraphAttribute)resource.getRrdGraphAttributes().get(source.getAttribute());
                if (rrdGraphAttribute == null && !Strings.isNullOrEmpty((String)source.getFallbackAttribute())) {
                    LOG.error("No attribute with name '{}', using fallback-attribute with name '{}'", (Object)source.getAttribute(), (Object)source.getFallbackAttribute());
                    source.setAttribute(source.getFallbackAttribute());
                    source.setFallbackAttribute(null);
                    rrdGraphAttribute = (RrdGraphAttribute)resource.getRrdGraphAttributes().get(source.getAttribute());
                }
                if (rrdGraphAttribute == null) {
                    LOG.error("No attribute with name: {}", (Object)source.getAttribute());
                    return null;
                }
                String newtsResourceId = rrdGraphAttribute.getRrdRelativePath();
                if (newtsResourceId.startsWith(File.separator)) {
                    newtsResourceId = newtsResourceId.substring(File.separator.length(), newtsResourceId.length());
                }
                if ((listOfSources = (List)sourcesByNewtsResourceId.get(newtsResourceId)) == null) {
                    listOfSources = Lists.newLinkedList();
                    sourcesByNewtsResourceId.put(newtsResourceId, listOfSources);
                }
                listOfSources.add(source);
            }
        }
        AtomicReference timestamps = new AtomicReference();
        ConcurrentMap columns = Maps.newConcurrentMap();
        sourcesByNewtsResourceId.entrySet().parallelStream().forEach(entry -> {
            String newtsResourceId = (String)entry.getKey();
            List listOfSources = (List)entry.getValue();
            ResultDescriptor resultDescriptor = new ResultDescriptor(fetchStep);
            for (Source source : listOfSources) {
                String metricName = source.getAttribute();
                String name = source.getLabel();
                AggregationFunction fn = NewtsFetchStrategy.toAggregationFunction(source.getAggregation());
                resultDescriptor.datasource(name, metricName, 3L * fetchStep, fn);
                resultDescriptor.export(new String[]{name});
            }
            LOG.debug("Querying Newts for resource id {} with result descriptor: {}", (Object)newtsResourceId, (Object)resultDescriptor);
            Results results = this.m_sampleRepository.select(this.m_context, new Resource(newtsResourceId), startTs, endTs, resultDescriptor, Optional.of((Object)Duration.millis((long)(2L * fetchStep))));
            Collection rows = results.getRows();
            LOG.debug("Found {} rows.", (Object)rows.size());
            int N = rows.size();
            HashMap myColumns = Maps.newHashMap();
            timestamps.updateAndGet(existing -> {
                if (existing == null) {
                    long[] tses = new long[rows.size()];
                    int k = 0;
                    for (Results.Row row : results.getRows()) {
                        tses[k] = row.getTimestamp().asMillis();
                        ++k;
                    }
                    return tses;
                }
                return existing;
            });
            int k = 0;
            for (Results.Row row : results.getRows()) {
                for (Measurement measurement : row.getElements()) {
                    double[] column = (double[])myColumns.get(measurement.getName());
                    if (column == null) {
                        column = new double[N];
                        myColumns.put(measurement.getName(), column);
                    }
                    column[k] = measurement.getValue();
                }
                ++k;
            }
            columns.putAll(myColumns);
        });
        FetchResults fetchResults = new FetchResults((long[])timestamps.get(), (Map)columns, fetchStep, (Map)constants);
        LOG.debug("Fetch results: {}", (Object)fetchResults);
        return fetchResults;
    }

    private static AggregationFunction toAggregationFunction(String fn) {
        if ("average".equalsIgnoreCase(fn) || "avg".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.AVERAGE;
        }
        if ("max".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MAX;
        }
        if ("min".equalsIgnoreCase(fn)) {
            return StandardAggregationFunctions.MIN;
        }
        throw new IllegalArgumentException("Unsupported aggregation function: " + fn);
    }

    @VisibleForTesting
    protected void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    @VisibleForTesting
    protected void setSampleRepository(SampleRepository sampleRepository) {
        this.m_sampleRepository = sampleRepository;
    }

    @VisibleForTesting
    protected void setContext(Context context) {
        this.m_context = context;
    }
}

