/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.namecutter;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameCutter {
    private static final Logger logger = LoggerFactory.getLogger(NameCutter.class);
    private Map<String, String> dictionary = new HashMap<String, String>();

    public String trimByCamelCase(String name, Integer maxLength) {
        String result = "";
        String[] nameParts = StringUtils.splitByCharacterTypeCamelCase((String)name);
        Integer charsOver = name.length() - maxLength;
        for (int i = 0; i < charsOver; ++i) {
            Integer largest = 0;
            Integer index = 0;
            for (int j = 0; j < nameParts.length; ++j) {
                if (nameParts[j].length() <= largest) continue;
                largest = nameParts[j].length();
                index = j;
            }
            nameParts[index.intValue()] = StringUtils.chop((String)nameParts[index]);
        }
        for (String namePart : nameParts) {
            result = result + namePart;
        }
        return result;
    }

    public String trimByDictionary(String name) {
        String result = "";
        String[] nameParts = StringUtils.splitByCharacterTypeCamelCase((String)name);
        for (int i = 0; i < nameParts.length; ++i) {
            String namePart = nameParts[i];
            for (String word : this.dictionary.keySet()) {
                if (!namePart.equalsIgnoreCase(word)) continue;
                logger.debug("dictionary Hit at '{}' result '{}'", (Object)name, (Object)name.replaceAll(word, this.dictionary.get(word)));
                nameParts[i] = this.dictionary.get(word);
            }
        }
        for (String namePart : nameParts) {
            result = result + namePart;
        }
        return result;
    }

    public Map<String, String> getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(Map<String, String> dictionary) {
        this.dictionary = dictionary;
    }
}

