/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.mibcompiler.services;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsmiparser.parser.SmiDefaultParser;
import org.jsmiparser.smi.Notification;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiNotificationType;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiRow;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiVariable;
import org.opennms.features.mibcompiler.api.MibParser;
import org.opennms.features.mibcompiler.services.OnmsProblemEventHandler;
import org.opennms.features.namecutter.NameCutter;
import org.opennms.netmgt.collection.support.IndexStorageStrategy;
import org.opennms.netmgt.config.datacollection.DatacollectionGroup;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.xml.eventconf.Decode;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.netmgt.xml.eventconf.LogDestType;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.netmgt.xml.eventconf.Mask;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.opennms.netmgt.xml.eventconf.Varbindsdecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsmiMibParser
implements MibParser,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(JsmiMibParser.class);
    private static final String[] MIB_SUFFIXES = new String[]{"", ".txt", ".mib", ".my"};
    private static final Pattern TRAP_OID_PATTERN = Pattern.compile("(.*)\\.(\\d+)$");
    private File mibDirectory;
    private SmiDefaultParser parser;
    private SmiModule module;
    private OnmsProblemEventHandler errorHandler;
    private List<String> missingDependencies = new ArrayList<String>();

    public JsmiMibParser() {
        this.parser = new SmiDefaultParser();
        this.errorHandler = new OnmsProblemEventHandler(this.parser);
    }

    @Override
    public void setMibDirectory(File mibDirectory) {
        this.mibDirectory = mibDirectory;
    }

    @Override
    public boolean parseMib(File mibFile) {
        if (this.mibDirectory == null || !this.mibDirectory.isDirectory()) {
            this.errorHandler.addError("MIB directory has not been set.");
            return false;
        }
        this.missingDependencies.clear();
        ArrayList<URL> queue = new ArrayList<URL>();
        this.parser.getFileParserPhase().setInputUrls(queue);
        HashMap<String, File> mibDirectoryFiles = new HashMap<String, File>();
        for (File file : this.mibDirectory.listFiles()) {
            mibDirectoryFiles.put(file.getName().toLowerCase(), file);
        }
        LOG.debug("Parsing {}", (Object)mibFile.getAbsolutePath());
        SmiMib mib = null;
        this.addFileToQueue(queue, mibFile);
        do {
            List<String> dependencies;
            this.errorHandler.reset();
            try {
                mib = this.parser.parse();
            }
            catch (Exception e) {
                LOG.error("Can't compile {}", (Object)mibFile, (Object)e);
                this.errorHandler.addError(e.getMessage());
            }
            if (this.errorHandler.isOk() || (dependencies = this.errorHandler.getDependencies()).isEmpty()) break;
            this.missingDependencies.addAll(dependencies);
        } while (this.addDependencyToQueue(queue, mibDirectoryFiles));
        if (this.errorHandler.isNotOk() || mib == null) {
            return false;
        }
        LOG.info("The MIB {} has been parsed successfully.", (Object)mibFile.getAbsolutePath());
        this.module = this.getModule(mib, mibFile);
        return this.module != null;
    }

    @Override
    public String getFormattedErrors() {
        return this.errorHandler.getMessages();
    }

    @Override
    public List<String> getMissingDependencies() {
        return this.missingDependencies;
    }

    @Override
    public String getMibName() {
        return this.module.getId();
    }

    @Override
    public Events getEvents(String ueibase) {
        if (this.module == null) {
            return null;
        }
        LOG.info("Generating events for {} using the following UEI Base: {}", (Object)this.module.getId(), (Object)ueibase);
        try {
            return this.convertMibToEvents(this.module, ueibase);
        }
        catch (Throwable e) {
            String errors = e.getMessage();
            if (errors == null || errors.trim().equals("")) {
                errors = "An unknown error accured when generating events objects from the MIB " + this.module.getId();
            }
            LOG.error("Event parsing error: {}", (Object)errors, (Object)e);
            this.errorHandler.addError(errors);
            return null;
        }
    }

    @Override
    public DatacollectionGroup getDataCollection() {
        if (this.module == null) {
            return null;
        }
        LOG.info("Generating data collection configuration for {}", (Object)this.module.getId());
        DatacollectionGroup dcGroup = new DatacollectionGroup();
        dcGroup.setName(this.module.getId());
        NameCutter cutter = new NameCutter();
        try {
            for (SmiVariable v : this.module.getVariables()) {
                String groupName = this.getGroupName(v);
                String resourceType = this.getResourceType(v);
                Group group = this.getGroup(dcGroup, groupName, resourceType);
                String typeName = this.getMetricType(v.getType().getPrimitiveType());
                if (typeName == null) continue;
                String alias = cutter.trimByCamelCase(v.getId(), 19);
                MibObj mibObj = new MibObj();
                mibObj.setOid('.' + v.getOidStr());
                mibObj.setInstance(resourceType == null ? "0" : resourceType);
                mibObj.setAlias(alias);
                mibObj.setType(typeName);
                group.addMibObj(mibObj);
                if (!typeName.equals("string") || resourceType == null) continue;
                for (ResourceType rs : dcGroup.getResourceTypes()) {
                    if (!rs.getName().equals(resourceType) || !rs.getResourceLabel().equals("${index}")) continue;
                    rs.setResourceLabel("${" + v.getId() + "} (${index})");
                }
            }
        }
        catch (Throwable e) {
            String errors = e.getMessage();
            if (errors == null || errors.trim().equals("")) {
                errors = "An unknown error accured when generating data collection objects from the MIB " + this.module.getId();
            }
            LOG.error("Data Collection parsing error: {}", (Object)errors, (Object)e);
            this.errorHandler.addError(errors);
            return null;
        }
        return dcGroup;
    }

    @Override
    public List<PrefabGraph> getPrefabGraphs() {
        if (this.module == null) {
            return null;
        }
        String color = System.getProperty("org.opennms.snmp.mib-compiler.default-graph-template.color", "#00ccff");
        ArrayList<PrefabGraph> graphs = new ArrayList<PrefabGraph>();
        LOG.info("Generating graph templates for {}", (Object)this.module.getId());
        NameCutter cutter = new NameCutter();
        try {
            for (SmiVariable v : this.module.getVariables()) {
                String groupName = this.getGroupName(v);
                String resourceType = this.getResourceType(v);
                if (resourceType == null) {
                    resourceType = "nodeSnmp";
                }
                String typeName = this.getMetricType(v.getType().getPrimitiveType());
                if (v.getId().contains("Index")) {
                    typeName = "string";
                }
                int order = 1;
                if (typeName == null || typeName.toLowerCase().contains("string")) continue;
                String name = groupName + '.' + v.getId();
                String title = this.getMibName() + "::" + groupName + "::" + v.getId();
                String alias = cutter.trimByCamelCase(v.getId(), 19);
                String descr = v.getDescription().replaceAll("[\n\r]", "").replaceAll("\\s+", " ");
                StringBuilder sb = new StringBuilder();
                sb.append("--title=\"").append(title).append("\" \\\n");
                sb.append(" DEF:var={rrd1}:").append(alias).append(":AVERAGE \\\n");
                sb.append(" LINE1:var").append(color).append(":\"").append(v.getId()).append("\" \\\n");
                sb.append(" GPRINT:var:AVERAGE:\"Avg\\\\: %8.2lf %s\" \\\n");
                sb.append(" GPRINT:var:MIN:\"Min\\\\: %8.2lf %s\" \\\n");
                sb.append(" GPRINT:var:MAX:\"Max\\\\: %8.2lf %s\\\\n\"");
                sb.append("\n\n");
                PrefabGraph graph = new PrefabGraph(name, title, new String[]{alias}, sb.toString(), new String[0], new String[0], order++, new String[]{resourceType}, descr, null, null, new String[0]);
                graphs.add(graph);
            }
        }
        catch (Throwable e) {
            String errors = e.getMessage();
            if (errors == null || errors.trim().equals("")) {
                errors = "An unknown error accured when generating graph templates from the MIB " + this.module.getId();
            }
            LOG.error("Graph templates parsing error: {}", (Object)errors, (Object)e);
            this.errorHandler.addError(errors);
            return null;
        }
        return graphs;
    }

    private String getGroupName(SmiVariable var) {
        if (var.getNode().getParent().getSingleValue() instanceof SmiRow) {
            return var.getNode().getParent().getParent().getSingleValue().getId();
        }
        return var.getNode().getParent().getSingleValue().getId();
    }

    private String getResourceType(SmiVariable var) {
        if (var.getNode().getParent().getSingleValue() instanceof SmiRow) {
            return var.getNode().getParent().getSingleValue().getId();
        }
        return null;
    }

    private void addFileToQueue(List<URL> queue, File mibFile) {
        try {
            URL url = mibFile.toURI().toURL();
            if (!queue.contains(url)) {
                LOG.debug("Adding {} to queue ", (Object)url);
                queue.add(url);
            }
        }
        catch (Exception e) {
            LOG.warn("Can't generate URL from {}", (Object)mibFile.getAbsolutePath());
        }
    }

    private boolean addDependencyToQueue(List<URL> queue, Map<String, File> mibDirectoryFiles) {
        ArrayList<String> dependencies = new ArrayList<String>(this.missingDependencies);
        boolean ok = true;
        for (String dependency : dependencies) {
            boolean found = false;
            for (String suffix : MIB_SUFFIXES) {
                String fileName = (dependency + suffix).toLowerCase();
                if (!mibDirectoryFiles.containsKey(fileName)) continue;
                File f = mibDirectoryFiles.get(fileName);
                LOG.debug("Checking dependency file {}", (Object)f.getAbsolutePath());
                if (!f.exists()) continue;
                LOG.info("Adding dependency file {}", (Object)f.getAbsolutePath());
                this.addFileToQueue(queue, f);
                this.missingDependencies.remove(dependency);
                found = true;
                break;
            }
            if (found) continue;
            LOG.warn("Couldn't find dependency {} on {}", (Object)dependency, (Object)this.mibDirectory);
            ok = false;
        }
        return ok;
    }

    private SmiModule getModule(SmiMib mibObject, File mibFile) {
        for (SmiModule m : mibObject.getModules()) {
            URL source = null;
            try {
                source = new URL(m.getIdToken().getLocation().getSource());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (source == null) continue;
            try {
                File srcFile = new File(source.toURI());
                if (!srcFile.getAbsolutePath().equals(mibFile.getAbsolutePath())) continue;
                return m;
            }
            catch (Exception exception) {
            }
        }
        LOG.error("Can't find the MIB module for " + mibFile);
        this.errorHandler.addError("Can't find the MIB module for " + mibFile);
        return null;
    }

    private String getMetricType(SmiPrimitiveType type) {
        if (type == null) {
            return null;
        }
        if (type.equals((Object)SmiPrimitiveType.ENUM)) {
            return "string";
        }
        if (type.equals((Object)SmiPrimitiveType.OBJECT_IDENTIFIER)) {
            return "string";
        }
        if (type.equals((Object)SmiPrimitiveType.UNSIGNED_32)) {
            return "integer";
        }
        return type.toString().replaceAll("_", "").toLowerCase();
    }

    protected Group getGroup(DatacollectionGroup data, String groupName, String resourceType) {
        for (Group group : data.getGroups()) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        Group group = new Group();
        group.setName(groupName);
        group.setIfType(resourceType == null ? "ignore" : "all");
        if (resourceType != null) {
            ResourceType type = new ResourceType();
            type.setName(resourceType);
            type.setLabel(resourceType);
            type.setResourceLabel("${index}");
            type.setPersistenceSelectorStrategy(new PersistenceSelectorStrategy("org.opennms.netmgt.collection.support.PersistAllSelectorStrategy"));
            type.setStorageStrategy(new StorageStrategy(IndexStorageStrategy.class.getName()));
            data.addResourceType(type);
        }
        data.addGroup(group);
        return group;
    }

    protected Events convertMibToEvents(SmiModule module, String ueibase) {
        Events events = new Events();
        for (SmiNotificationType trap : module.getNotificationTypes()) {
            events.addEvent(this.getTrapEvent((Notification)trap, ueibase));
        }
        for (SmiNotificationType trap : module.getTrapTypes()) {
            events.addEvent(this.getTrapEvent((Notification)trap, ueibase));
        }
        return events;
    }

    protected Event getTrapEvent(Notification trap, String ueibase) {
        String severity = OnmsSeverity.INDETERMINATE.toString();
        severity = severity.substring(0, 1).toUpperCase() + severity.substring(1).toLowerCase();
        Event evt = new Event();
        evt.setUei(this.getTrapEventUEI(trap, ueibase));
        evt.setEventLabel(this.getTrapEventLabel(trap));
        evt.setLogmsg(this.getTrapEventLogmsg(trap));
        evt.setSeverity(severity);
        evt.setDescr(this.getTrapEventDescr(trap));
        List<Varbindsdecode> decode = this.getTrapVarbindsDecode(trap);
        if (!decode.isEmpty()) {
            evt.setVarbindsdecodes(decode);
        }
        evt.setMask(new Mask());
        this.addMaskElement(evt, "id", this.getTrapEnterprise(trap));
        this.addMaskElement(evt, "generic", "6");
        this.addMaskElement(evt, "specific", this.getTrapSpecificType(trap));
        return evt;
    }

    protected String getTrapEventUEI(Notification trap, String ueibase) {
        StringBuilder buf = new StringBuilder(ueibase);
        if (!ueibase.endsWith("/")) {
            buf.append("/");
        }
        buf.append(trap.getId());
        return buf.toString();
    }

    protected String getTrapEventLabel(Notification trap) {
        StringBuilder buf = new StringBuilder();
        buf.append(trap.getModule().getId());
        buf.append(" defined trap event: ");
        buf.append(trap.getId());
        return buf.toString();
    }

    protected Logmsg getTrapEventLogmsg(Notification trap) {
        Logmsg msg = new Logmsg();
        msg.setDest(LogDestType.LOGNDISPLAY);
        StringBuilder dbuf = new StringBuilder();
        dbuf.append("<p>");
        dbuf.append("\n");
        dbuf.append("\t").append(trap.getId()).append(" trap received\n");
        int vbNum = 1;
        for (SmiVariable var : trap.getObjects()) {
            dbuf.append("\t").append(var.getId()).append("=%parm[#").append(vbNum).append("]%\n");
            ++vbNum;
        }
        if (dbuf.charAt(dbuf.length() - 1) == '\n') {
            dbuf.deleteCharAt(dbuf.length() - 1);
        }
        dbuf.append("</p>\n\t");
        msg.setContent(dbuf.toString());
        return msg;
    }

    protected String getTrapEventDescr(Notification trap) {
        String descrEndingNewlines;
        StringBuffer dbuf;
        String description = trap.getDescription();
        if (description == null) {
            LOG.warn("The trap {} doesn't have a description field", (Object)trap.getOidStr());
        }
        if ((dbuf = new StringBuffer(descrEndingNewlines = description == null ? "No Description." : description.replaceAll("^", "\n<p>").replaceAll("$", "</p>\n"))).charAt(dbuf.length() - 1) == '\n') {
            dbuf.deleteCharAt(dbuf.length() - 1);
        }
        dbuf.append("<table>");
        dbuf.append("\n");
        int vbNum = 1;
        for (SmiVariable var : trap.getObjects()) {
            dbuf.append("\t<tr><td><b>\n\n\t").append(var.getId());
            dbuf.append("</b></td><td>\n\t%parm[#").append(vbNum).append("]%;</td><td><p>");
            SmiPrimitiveType type = var.getType().getPrimitiveType();
            if (type.equals((Object)SmiPrimitiveType.ENUM)) {
                TreeMap<BigInteger, String> map = new TreeMap<BigInteger, String>();
                SmiType t = var.getType();
                while (t.getEnumValues() == null) {
                    t = t.getBaseType();
                }
                List enumValues = t.getEnumValues();
                if (enumValues != null) {
                    for (SmiNamedNumber smiNamedNumber : enumValues) {
                        map.put(smiNamedNumber.getValue(), smiNamedNumber.getId());
                    }
                } else {
                    map.put(new BigInteger("0"), "Unable to derive list of possible values.");
                }
                dbuf.append("\n");
                for (Map.Entry entry : map.entrySet()) {
                    dbuf.append("\t\t").append((String)entry.getValue()).append("(").append(entry.getKey()).append(")\n");
                }
                dbuf.append("\t");
            }
            dbuf.append("</p></td></tr>\n");
            ++vbNum;
        }
        if (dbuf.charAt(dbuf.length() - 1) == '\n') {
            dbuf.deleteCharAt(dbuf.length() - 1);
        }
        dbuf.append("</table>\n\t");
        return dbuf.toString();
    }

    protected List<Varbindsdecode> getTrapVarbindsDecode(Notification trap) {
        LinkedHashMap<String, Varbindsdecode> decode = new LinkedHashMap<String, Varbindsdecode>();
        int vbNum = 1;
        for (SmiVariable var : trap.getObjects()) {
            String parmName = "parm[#" + vbNum + "]";
            SmiPrimitiveType type = var.getType().getPrimitiveType();
            if (type.equals((Object)SmiPrimitiveType.ENUM)) {
                TreeMap<BigInteger, String> map = new TreeMap<BigInteger, String>();
                SmiType t = var.getType();
                while (t.getEnumValues() == null) {
                    t = t.getBaseType();
                }
                List enumValues = t.getEnumValues();
                if (enumValues != null) {
                    for (SmiNamedNumber smiNamedNumber : enumValues) {
                        map.put(smiNamedNumber.getValue(), smiNamedNumber.getId());
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        if (!decode.containsKey(parmName)) {
                            Varbindsdecode newVarbind = new Varbindsdecode();
                            newVarbind.setParmid(parmName);
                            decode.put(newVarbind.getParmid(), newVarbind);
                        }
                        Decode d = new Decode();
                        d.setVarbinddecodedstring((String)entry.getValue());
                        d.setVarbindvalue(((BigInteger)entry.getKey()).toString());
                        ((Varbindsdecode)decode.get(parmName)).addDecode(d);
                    }
                }
            }
            ++vbNum;
        }
        return new ArrayList<Varbindsdecode>(decode.values());
    }

    private String getTrapEnterprise(Notification trap) {
        String trapOid = this.getMatcherForOid(this.getTrapOid(trap)).group(1);
        if (trapOid.endsWith(".0")) {
            trapOid = trapOid.substring(0, trapOid.length() - 2);
        }
        return trapOid;
    }

    private String getTrapSpecificType(Notification trap) {
        return this.getMatcherForOid(this.getTrapOid(trap)).group(2);
    }

    private Matcher getMatcherForOid(String trapOid) {
        Matcher m = TRAP_OID_PATTERN.matcher(trapOid);
        if (!m.matches()) {
            throw new IllegalStateException("Could not match the trap OID '" + trapOid + "' against '" + m.pattern().pattern() + "'");
        }
        return m;
    }

    private String getTrapOid(Notification trap) {
        return '.' + trap.getOidStr();
    }

    private void addMaskElement(Event event, String name, String value) {
        if (event.getMask() == null) {
            throw new IllegalStateException("Event mask is not present, must have been set before this method was called");
        }
        Maskelement me = new Maskelement();
        me.setMename(name);
        me.addMevalue(value);
        event.getMask().addMaskelement(me);
    }
}

