/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.mibcompiler.services;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.model.PrefabGraph;

public class PrefabGraphDumper {
    public void dump(List<PrefabGraph> graphs, Writer writer) throws IOException {
        ArrayList<String> templates = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (PrefabGraph graph : graphs) {
            String name = "report." + graph.getName();
            templates.add(graph.getName());
            sb.append(name).append(".name=").append(graph.getTitle()).append("\n");
            sb.append(name).append(".columns=").append(StringUtils.join((Object[])graph.getColumns(), (String)",")).append("\n");
            sb.append(name).append(".type=").append(StringUtils.join((Object[])graph.getTypes(), (String)",")).append("\n");
            sb.append(name).append(".description=").append(graph.getDescription()).append("\n");
            sb.append(name).append(".command=").append(graph.getCommand());
        }
        writer.write("reports=" + StringUtils.join(templates, (String)", \\\n") + "\n\n");
        writer.write(sb.toString());
    }
}

