/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.jdbc.JdbcAgentState;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.jdbc.JdbcColumn;
import org.opennms.netmgt.config.jdbc.JdbcDataCollection;
import org.opennms.netmgt.config.jdbc.JdbcQuery;
import org.opennms.netmgt.dao.JdbcDataCollectionConfigDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCollector
extends AbstractRemoteServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCollector.class);
    private static final String JDBC_COLLECTION_KEY = "jdbcCollection";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<JdbcDataCollection>>("jdbcCollection", JdbcDataCollection.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));
    private JdbcDataCollectionConfigDao m_jdbcCollectionDao;

    public JdbcCollector() {
        super(TYPE_MAP);
    }

    public void initialize() {
        LOG.debug("initialize: Initializing JdbcCollector.");
        if (this.m_jdbcCollectionDao == null) {
            this.m_jdbcCollectionDao = (JdbcDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"jdbcDataCollectionConfigDao", JdbcDataCollectionConfigDao.class);
        }
    }

    private static void initDatabaseConnectionFactory(String dataSourceName) {
        DataSourceFactory.init((String)dataSourceName);
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"jdbc-collection", null));
        JdbcDataCollection collection = this.m_jdbcCollectionDao.getDataCollectionByName(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException(String.format("JdbcCollector: No collection found with name '%s'.", collectionName));
        }
        runtimeAttributes.put(JDBC_COLLECTION_KEY, collection);
        return runtimeAttributes;
    }

    protected JdbcAgentState createAgentState(InetAddress address, Map<String, Object> parameters) {
        return new JdbcAgentState(address, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        JdbcDataCollection collection = (JdbcDataCollection)parameters.get(JDBC_COLLECTION_KEY);
        JdbcAgentState agentState = null;
        Connection con = null;
        ResultSet results = null;
        Statement stmt = null;
        try {
            agentState = this.createAgentState((InetAddress)agent.getAddress(), parameters);
            agentState.setupDatabaseConnections(parameters);
            CollectionSetBuilder builder = new CollectionSetBuilder(agent);
            NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
            for (JdbcQuery query : collection.getQueries()) {
                block21: {
                    block22: {
                        if (agentState.shouldCheckAvailability(query.getQueryName(), query.getRecheckInterval()) && !JdbcCollector.isGroupAvailable(agentState, query)) {
                            LOG.warn("Group is not available.");
                            continue;
                        }
                        if (!agentState.groupIsAvailable(query.getQueryName())) break block21;
                        if (agentState.getUseDataSourceName()) {
                            JdbcCollector.initDatabaseConnectionFactory(agentState.getDataSourceName());
                            con = DataSourceFactory.getInstance((String)agentState.getDataSourceName()).getConnection();
                        } else {
                            con = agentState.getJdbcConnection();
                        }
                        stmt = agentState.createStatement(con);
                        results = agentState.executeJdbcQuery(stmt, query);
                        if (!results.isBeforeFirst() || !results.isAfterLast()) break block22;
                        LOG.warn("Query '{}' returned no results.", (Object)query.getQueryName());
                        agentState.closeResultSet(results);
                        agentState.closeStmt(stmt);
                        agentState.closeResultSet(results);
                        agentState.closeStmt(stmt);
                        agentState.closeConnection(con);
                        continue;
                    }
                    try {
                        results.last();
                        boolean singleInstance = results.getRow() == 1;
                        results.beforeFirst();
                        while (results.next()) {
                            NodeLevelResource resource = null;
                            if (singleInstance) {
                                resource = nodeResource;
                            } else {
                                String instance = results.getString(query.getInstanceColumn());
                                resource = new DeferredGenericTypeResource(nodeResource, query.getResourceType(), instance);
                            }
                            for (JdbcColumn curColumn : query.getJdbcColumns()) {
                                AttributeType type = curColumn.getDataType();
                                String columnName = null;
                                columnName = curColumn.getDataSourceName() != null && curColumn.getDataSourceName().length() != 0 ? curColumn.getDataSourceName() : curColumn.getColumnName();
                                String columnValue = results.getString(columnName);
                                if (columnValue == null) {
                                    LOG.debug("Skipping column named '{}' with null value.", (Object)curColumn.getColumnName());
                                    continue;
                                }
                                if (type.isNumeric()) {
                                    Double numericValue = Double.NaN;
                                    try {
                                        numericValue = Double.parseDouble(columnValue);
                                    }
                                    catch (NumberFormatException e) {
                                        LOG.warn("Value '{}' for column named '{}' cannot be converted to a number. Skipping.", (Object)columnValue, (Object)curColumn.getColumnName());
                                        continue;
                                    }
                                    builder.withNumericAttribute((Resource)resource, query.getQueryName(), curColumn.getAlias(), (Number)numericValue, type);
                                    continue;
                                }
                                builder.withStringAttribute((Resource)resource, query.getQueryName(), curColumn.getAlias(), columnValue);
                            }
                        }
                    }
                    catch (SQLException e) {
                        try {
                            LOG.warn("There was a problem executing query '{}' Please review the query or configuration. Reason: {}", (Object)query.getQueryName(), (Object)e.getMessage());
                            agentState.closeResultSet(results);
                            agentState.closeStmt(stmt);
                            agentState.closeConnection(con);
                            continue;
                        }
                        catch (Throwable throwable) {
                            agentState.closeResultSet(results);
                            agentState.closeStmt(stmt);
                            agentState.closeConnection(con);
                            throw throwable;
                        }
                    }
                }
                agentState.closeResultSet(results);
                agentState.closeStmt(stmt);
                agentState.closeConnection(con);
            }
            builder.withStatus(CollectionStatus.SUCCEEDED);
            CollectionSetDTO collectionSetDTO = builder.build();
            return collectionSetDTO;
        }
        finally {
            if (agentState != null) {
                agentState.closeResultSet(results);
                agentState.closeStmt(stmt);
                agentState.closeConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isGroupAvailable(JdbcAgentState agentState, JdbcQuery query) {
        LOG.debug("Checking availability of group {}", (Object)query.getQueryName());
        boolean status = false;
        ResultSet resultset = null;
        Connection con = null;
        try {
            if (agentState.getUseDataSourceName()) {
                JdbcCollector.initDatabaseConnectionFactory(agentState.getDataSourceName());
                con = DataSourceFactory.getInstance((String)agentState.getDataSourceName()).getConnection();
            } else {
                con = agentState.getJdbcConnection();
            }
            DatabaseMetaData metadata = con.getMetaData();
            resultset = metadata.getCatalogs();
            while (resultset.next()) {
                resultset.getString(1);
            }
            if (resultset != null) {
                status = true;
            }
            agentState.closeResultSet(resultset);
            agentState.closeConnection(con);
        }
        catch (SQLException sqlEx) {
            try {
                LOG.warn("Error checking group ({}) availability", (Object)query.getQueryName(), (Object)sqlEx);
                agentState.setGroupIsAvailable(query.getQueryName(), status);
                status = false;
                agentState.closeResultSet(resultset);
                agentState.closeConnection(con);
            }
            catch (Throwable throwable) {
                agentState.closeResultSet(resultset);
                agentState.closeConnection(con);
                throw throwable;
            }
        }
        LOG.debug("Group {} is {} available", (Object)query.getQueryName(), (Object)(status ? "" : "not"));
        agentState.setGroupIsAvailable(query.getQueryName(), status);
        return status;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_jdbcCollectionDao.getConfig().buildRrdRepository(collectionName);
    }

    public JdbcDataCollectionConfigDao getJdbcCollectionDao() {
        return this.m_jdbcCollectionDao;
    }

    public void setJdbcCollectionDao(JdbcDataCollectionConfigDao jdbcCollectionDao) {
        this.m_jdbcCollectionDao = jdbcCollectionDao;
    }
}

