/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.InputStream;
import junit.framework.TestCase;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.dao.jaxb.JdbcDataCollectionConfigDaoJaxb;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class JdbcDataCollectionConfigDaoJaxbTest
extends TestCase {
    public void testAfterPropertiesSetWithNoConfigSet() {
        JdbcDataCollectionConfigDaoJaxb dao = new JdbcDataCollectionConfigDaoJaxb();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property configResource must be set and be non-null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetWithBogusFileResource() throws Exception {
        FileSystemResource resource = new FileSystemResource("/bogus-file");
        JdbcDataCollectionConfigDaoJaxb dao = new JdbcDataCollectionConfigDaoJaxb();
        dao.setConfigResource((Resource)resource);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new MarshallingResourceFailureException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetWithGoodConfigFile() throws Exception {
        JdbcDataCollectionConfigDaoJaxb dao = new JdbcDataCollectionConfigDaoJaxb();
        InputStream in = ConfigurationTestUtils.getInputStreamForConfigFile((String)"jdbc-datacollection-config.xml");
        dao.setConfigResource((Resource)new InputStreamResource(in));
        dao.afterPropertiesSet();
        JdbcDataCollectionConfigDaoJaxbTest.assertNotNull((String)"jdbc data collection should not be null", (Object)dao.getConfig());
    }
}

