/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.InputStream;
import junit.framework.TestCase;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.config.jdbc.JdbcDataCollectionConfig;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class AbstractJaxbConfigDaoTest
extends TestCase {
    public void testAfterPropertiesSetWithNoConfigSet() {
        TestJaxbConfigDao dao = new TestJaxbConfigDao();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property configResource must be set and be non-null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetWithBogusFileResource() throws Exception {
        FileSystemResource resource = new FileSystemResource("/bogus-file");
        TestJaxbConfigDao dao = new TestJaxbConfigDao();
        dao.setConfigResource((Resource)resource);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new MarshallingResourceFailureException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetWithGoodConfigFile() throws Exception {
        TestJaxbConfigDao dao = new TestJaxbConfigDao();
        InputStream in = ConfigurationTestUtils.getInputStreamForConfigFile((String)"jdbc-datacollection-config.xml");
        dao.setConfigResource((Resource)new InputStreamResource(in));
        dao.afterPropertiesSet();
        AbstractJaxbConfigDaoTest.assertNotNull((String)"jdbc data collection should not be null", (Object)dao.getDataCollectionConfig());
    }

    public static class TestJaxbConfigDao
    extends AbstractJaxbConfigDao<JdbcDataCollectionConfig, JdbcDataCollectionConfig> {
        public TestJaxbConfigDao() {
            super(JdbcDataCollectionConfig.class, "jdbc data collection configuration");
        }

        protected JdbcDataCollectionConfig translateConfig(JdbcDataCollectionConfig jaxbConfig) {
            return jaxbConfig;
        }

        public JdbcDataCollectionConfig getDataCollectionConfig() {
            return (JdbcDataCollectionConfig)this.getContainer().getObject();
        }
    }
}

