/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.jdbc.JdbcAgentState;
import org.opennms.netmgt.collectd.jdbc.JdbcCollectionAttributeType;
import org.opennms.netmgt.collectd.jdbc.JdbcCollectionResource;
import org.opennms.netmgt.collectd.jdbc.JdbcCollectionSet;
import org.opennms.netmgt.collectd.jdbc.JdbcMultiInstanceCollectionResource;
import org.opennms.netmgt.collectd.jdbc.JdbcSingleInstanceCollectionResource;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.config.jdbc.JdbcColumn;
import org.opennms.netmgt.config.jdbc.JdbcDataCollection;
import org.opennms.netmgt.config.jdbc.JdbcQuery;
import org.opennms.netmgt.dao.JdbcDataCollectionConfigDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCollector.class);
    private JdbcDataCollectionConfigDao m_jdbcCollectionDao;
    private final Map<Integer, JdbcAgentState> m_scheduledNodes = new HashMap<Integer, JdbcAgentState>();
    private Map<String, AttributeGroupType> m_groupTypeList = new HashMap<String, AttributeGroupType>();
    private Map<String, JdbcCollectionAttributeType> m_attribTypeList = new HashMap<String, JdbcCollectionAttributeType>();

    public JdbcDataCollectionConfigDao getJdbcCollectionDao() {
        return this.m_jdbcCollectionDao;
    }

    public void setJdbcCollectionDao(JdbcDataCollectionConfigDao jdbcCollectionDao) {
        this.m_jdbcCollectionDao = jdbcCollectionDao;
    }

    private void loadAttributeGroupList(JdbcDataCollection collection) {
        for (JdbcQuery query : collection.getQueries()) {
            AttributeGroupType attribGroupType1 = new AttributeGroupType(query.getQueryName(), query.getIfType());
            this.m_groupTypeList.put(query.getQueryName(), attribGroupType1);
        }
    }

    private void loadAttributeTypeList(JdbcDataCollection collection) {
        for (JdbcQuery query : collection.getQueries()) {
            for (JdbcColumn column : query.getJdbcColumns()) {
                AttributeGroupType attribGroupType = this.m_groupTypeList.get(query.getQueryName());
                JdbcCollectionAttributeType attribType = new JdbcCollectionAttributeType(column, attribGroupType);
                this.m_attribTypeList.put(column.getColumnName(), attribType);
            }
        }
    }

    public void initialize(Map<String, String> parameters) {
        LOG.debug("initialize: Initializing JdbcCollector.");
        this.m_jdbcCollectionDao = (JdbcDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"jdbcDataCollectionConfigDao", JdbcDataCollectionConfigDao.class);
        this.m_scheduledNodes.clear();
        this.initializeRrdDirs();
    }

    private void initializeRrdDirs() {
        LOG.debug("initializeRrdRepository: Initializing RRD repo from JdbcCollector...");
        File f = new File(this.m_jdbcCollectionDao.getConfig().getRrdRepository());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_jdbcCollectionDao.getConfig().getRrdRepository());
        }
    }

    private void initDatabaseConnectionFactory(String dataSourceName) {
        DataSourceFactory.init((String)dataSourceName);
    }

    public void release() {
        this.m_scheduledNodes.clear();
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        LOG.debug("initialize: Initializing JDBC collection for agent: {}", (Object)agent);
        Integer scheduledNodeKey = agent.getNodeId();
        JdbcAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            LOG.info("initialize: Not scheduling interface for JDBC collection: {}", (Object)nodeState.getAddress());
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(" for address: ");
            sb.append(nodeState.getAddress());
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            LOG.debug(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        nodeState = new JdbcAgentState((InetAddress)agent.getAddress(), parameters);
        LOG.info("initialize: Scheduling interface for collection: {}", (Object)nodeState.getAddress());
        this.m_scheduledNodes.put(scheduledNodeKey, nodeState);
    }

    public void release(CollectionAgent agent) {
        Integer scheduledNodeKey = agent.getNodeId();
        JdbcAgentState nodeState = this.m_scheduledNodes.get(scheduledNodeKey);
        if (nodeState != null) {
            this.m_scheduledNodes.remove(scheduledNodeKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        JdbcAgentState agentState = null;
        if (parameters == null) {
            LOG.error("Null parameters is now allowed in JdbcCollector!!");
        }
        Connection con = null;
        ResultSet results = null;
        Statement stmt = null;
        try {
            String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(parameters, (String)"jdbc-collection", null);
            }
            JdbcDataCollection collection = this.m_jdbcCollectionDao.getDataCollectionByName(collectionName);
            agentState = this.m_scheduledNodes.get(agent.getNodeId());
            agentState.setupDatabaseConnections(parameters);
            this.loadAttributeGroupList(collection);
            this.loadAttributeTypeList(collection);
            JdbcCollectionSet collectionSet = new JdbcCollectionSet();
            collectionSet.setCollectionTimestamp(new Date());
            JdbcSingleInstanceCollectionResource nodeResource = new JdbcSingleInstanceCollectionResource(agent);
            for (JdbcQuery query : collection.getQueries()) {
                if (agentState.shouldCheckAvailability(query.getQueryName(), query.getRecheckInterval()) && !this.isGroupAvailable(agentState, query)) {
                    LOG.warn("Group is not available.");
                    continue;
                }
                try {
                    if (!agentState.groupIsAvailable(query.getQueryName())) continue;
                    if (agentState.getUseDataSourceName()) {
                        this.initDatabaseConnectionFactory(agentState.getDataSourceName());
                        con = DataSourceFactory.getInstance((String)agentState.getDataSourceName()).getConnection();
                    } else {
                        con = agentState.getJdbcConnection();
                    }
                    stmt = agentState.createStatement(con);
                    results = agentState.executeJdbcQuery(stmt, query);
                    if (results.isBeforeFirst() && results.isAfterLast()) {
                        LOG.warn("Query '{}' returned no results.", (Object)query.getQueryName());
                        agentState.closeResultSet(results);
                        agentState.closeStmt(stmt);
                        continue;
                    }
                    results.last();
                    boolean singleInstance = results.getRow() == 1;
                    results.beforeFirst();
                    while (results.next()) {
                        JdbcCollectionResource resource = null;
                        if (singleInstance) {
                            resource = nodeResource;
                        } else {
                            String instance = results.getString(query.getInstanceColumn());
                            resource = new JdbcMultiInstanceCollectionResource(agent, instance, query.getResourceType());
                        }
                        for (JdbcColumn curColumn : query.getJdbcColumns()) {
                            String columnName = null;
                            columnName = curColumn.getDataSourceName() != null && curColumn.getDataSourceName().length() != 0 ? curColumn.getDataSourceName() : curColumn.getColumnName();
                            JdbcCollectionAttributeType attribType = this.m_attribTypeList.get(curColumn.getColumnName());
                            resource.setAttributeValue((CollectionAttributeType)attribType, results.getString(columnName));
                        }
                        collectionSet.getCollectionResources().add(resource);
                    }
                }
                catch (SQLException e) {
                    LOG.warn("There was a problem executing query '{}' Please review the query or configuration. Reason: {}", (Object)query.getQueryName(), (Object)e.getMessage());
                    agentState.closeResultSet(results);
                    agentState.closeStmt(stmt);
                    agentState.closeConnection(con);
                }
            }
            collectionSet.setStatus(1);
            Object object = collectionSet;
            return object;
        }
        finally {
            agentState.closeResultSet(results);
            agentState.closeStmt(stmt);
            agentState.closeConnection(con);
            if (agentState != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGroupAvailable(JdbcAgentState agentState, JdbcQuery query) {
        LOG.debug("Checking availability of group {}", (Object)query.getQueryName());
        boolean status = false;
        ResultSet resultset = null;
        Connection con = null;
        try {
            if (agentState.getUseDataSourceName()) {
                this.initDatabaseConnectionFactory(agentState.getDataSourceName());
                con = DataSourceFactory.getInstance((String)agentState.getDataSourceName()).getConnection();
            } else {
                con = agentState.getJdbcConnection();
            }
            DatabaseMetaData metadata = con.getMetaData();
            resultset = metadata.getCatalogs();
            while (resultset.next()) {
                resultset.getString(1);
            }
            if (resultset != null) {
                status = true;
            }
            agentState.closeResultSet(resultset);
            agentState.closeConnection(con);
        }
        catch (SQLException sqlEx) {
            try {
                LOG.warn("Error checking group ({}) availability", (Object)query.getQueryName(), (Object)sqlEx);
                agentState.setGroupIsAvailable(query.getQueryName(), status);
                status = false;
                agentState.closeResultSet(resultset);
                agentState.closeConnection(con);
            }
            catch (Throwable throwable) {
                agentState.closeResultSet(resultset);
                agentState.closeConnection(con);
                throw throwable;
            }
        }
        LOG.debug("Group {} is {} available", (Object)query.getQueryName(), (Object)(status ? "" : "not"));
        agentState.setGroupIsAvailable(query.getQueryName(), status);
        return status;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_jdbcCollectionDao.getConfig().buildRrdRepository(collectionName);
    }
}

