/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.util.ilr;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class Duration
implements Comparable<Duration> {
    private long m_durationInMillis;

    public Duration(Date start, Date end) {
        if (start == null) {
            throw new IllegalArgumentException("startDate may not be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("endDate may not be null");
        }
        if (start.after(end)) {
            throw new IllegalArgumentException("start must preceed end");
        }
        this.m_durationInMillis = end.getTime() - start.getTime();
    }

    public Duration(long duration, TimeUnit units) {
        if (units == null) {
            throw new IllegalArgumentException("timeUnit may not be null");
        }
        this.m_durationInMillis = TimeUnit.MILLISECONDS.convert(duration, units);
    }

    public Duration(long durationInMillis) {
        this.m_durationInMillis = durationInMillis;
    }

    public long millis() {
        return this.m_durationInMillis;
    }

    private long appendUnit(StringBuilder buf, long millisRemaining, long millisPerUnit, String unit) {
        long units = millisRemaining / millisPerUnit;
        if (0L < millisRemaining && (0L < units || millisRemaining < this.millis())) {
            buf.append(units).append(unit);
            millisRemaining -= units * millisPerUnit;
        }
        return millisRemaining;
    }

    public String toString() {
        if (0L == this.millis()) {
            return "0ms";
        }
        StringBuilder buf = new StringBuilder();
        long millis = this.millis();
        millis = this.appendUnit(buf, millis, 86400000L, "d");
        millis = this.appendUnit(buf, millis, 3600000L, "h");
        millis = this.appendUnit(buf, millis, 60000L, "m");
        millis = this.appendUnit(buf, millis, 1000L, "s");
        millis = this.appendUnit(buf, millis, 1L, "ms");
        return buf.toString();
    }

    @Override
    public int compareTo(Duration o) {
        long diff = this.millis() - o.millis();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public int hashCode() {
        return (int)(this.m_durationInMillis ^ this.m_durationInMillis >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Duration) {
            Duration d = (Duration)obj;
            return this.m_durationInMillis == d.m_durationInMillis;
        }
        return false;
    }
}

