/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.util.ilr;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.util.ilr.LogMessage;

public class SimpleLogMessage
implements LogMessage {
    private String m_logMessage;

    public static LogMessage create(String logMessage) {
        return new SimpleLogMessage(logMessage);
    }

    private SimpleLogMessage(String logMessage) {
        this.m_logMessage = logMessage;
    }

    public String getMessage() {
        return this.m_logMessage;
    }

    @Override
    public boolean isEndMessage() {
        return this.getMessage().contains("end");
    }

    public String toString() {
        return this.m_logMessage;
    }

    @Override
    public boolean isPersistMessage() {
        return this.getMessage().contains("persist");
    }

    @Override
    public boolean isPersistBeginMessage() {
        return this.getMessage().contains("persistDataQueueing: begin");
    }

    @Override
    public boolean isPersistEndMessage() {
        return this.getMessage().contains("persistDataQueueing: end");
    }

    @Override
    public boolean isBeginMessage() {
        return this.getMessage().contains("begin");
    }

    @Override
    public boolean isErrorMessage() {
        return this.getMessage().contains("error");
    }

    @Override
    public boolean isCollectorBeginMessage() {
        return this.getMessage().contains("collectData: begin:") || this.getMessage().contains("collector.initialize: begin");
    }

    @Override
    public boolean isCollectorEndMessage() {
        return this.getMessage().contains("collectData: end:") || this.getMessage().contains("collector.initialize: end");
    }

    @Override
    public Date getDate() {
        String regex = "\\d+-\\d+-\\d+\\s*\\d+:\\d+:\\d+,\\d+";
        Pattern timestamp = Pattern.compile(regex);
        Matcher timestampMatcher = timestamp.matcher(this.getMessage());
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,S");
        if (timestampMatcher.find()) {
            try {
                return f.parse(timestampMatcher.group());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Does not match");
    }

    @Override
    public String getServiceID() {
        String regex = "\\d+/\\d+\\.\\d+\\.\\d+\\.\\d+/[\\w-]+";
        Pattern service = Pattern.compile(regex);
        Matcher serviceMatcher = service.matcher(this.getMessage());
        if (serviceMatcher.find()) {
            return serviceMatcher.group();
        }
        return null;
    }

    @Override
    public String getThread() {
        String regex = "\\[\\w+-\\d+\\s\\w+-\\w+\\d+\\]";
        Pattern thread = Pattern.compile(regex);
        Matcher threadMatcher = thread.matcher(this.getMessage());
        if (threadMatcher.find()) {
            return threadMatcher.group();
        }
        return null;
    }
}

