/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.util.ilr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.util.ilr.BaseLogMessage;
import org.opennms.util.ilr.Filter;
import org.opennms.util.ilr.LogMessage;
import org.opennms.util.ilr.ServiceCollector;

public class Collector {
    public static final String SERVICE_TITLE_FORMAT = "%-40s%20s%15s%25s%15s%25s%15s%20s%25s\n";
    public static final String SERVICE_DATA_FORMAT = "%-40s%20s%15s%25s%15.1f%25s%15.1f%20s%25s\n";
    private String m_searchString = null;
    private static boolean s_durationsMs = false;
    SortOrder m_sortOrder = SortOrder.DESCENDING;
    SortColumn m_sortColumn = SortColumn.AVGCOLLECTTIME;
    private Set<String> m_threads = new HashSet<String>();
    private LogMessage m_firstMessage;
    private LogMessage m_lastMessage;
    private Map<String, ServiceCollector> m_serviceCollectors = new HashMap<String, ServiceCollector>();

    public void setSearchString(String searchString) {
        this.m_searchString = searchString;
    }

    public void setSortColumn(SortColumn sortFlag) {
        this.m_sortColumn = sortFlag;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.m_sortOrder = sortOrder;
    }

    public SortColumn getSortColumn() {
        return this.m_sortColumn;
    }

    public String getSearchString() {
        return this.m_searchString;
    }

    public static void setDurationsMs(boolean durationsMs) {
        s_durationsMs = durationsMs;
    }

    public static boolean getDurationsMs() {
        return s_durationsMs;
    }

    public void addLog(String logMessage) {
        BaseLogMessage msg = BaseLogMessage.create(logMessage);
        if (msg != null) {
            if (this.m_firstMessage == null && msg.isBeginMessage()) {
                this.m_firstMessage = msg;
            }
            if (msg.isEndMessage()) {
                this.m_lastMessage = msg;
            }
            this.getServiceCollector(msg.getServiceID()).addMessage(msg);
            this.m_threads.add(msg.getThread());
        }
    }

    public Date getStartTime() {
        LogMessage firstValidLine = this.getFirstValidLogMessage();
        return firstValidLine == null ? null : firstValidLine.getDate();
    }

    public LogMessage getFirstValidLogMessage() {
        return this.m_firstMessage;
    }

    public LogMessage getLastValidLogMessage() {
        return this.m_lastMessage;
    }

    public Date getEndTime() {
        LogMessage logMessage = this.getLastValidLogMessage();
        return logMessage == null ? null : logMessage.getDate();
    }

    public long getDuration() {
        if (this.getEndTime() == null || this.getStartTime() == null) {
            return 0L;
        }
        return this.getEndTime().getTime() - this.getStartTime().getTime();
    }

    public String getFormattedDuration() {
        return Collector.formatDuration(this.getDuration());
    }

    public int getServiceCount() {
        return this.getServices().size();
    }

    public Map<String, ServiceCollector> getm_ServiceCollectors() {
        return this.m_serviceCollectors;
    }

    public int compareLongs(long l1, long l2) {
        Long a = l1;
        Long b = l2;
        return b.compareTo(a);
    }

    public Set<String> getServices() {
        return this.m_serviceCollectors.keySet();
    }

    public List<ServiceCollector> getServiceCollectors() {
        ArrayList collectors = new ArrayList(this.m_serviceCollectors.values());
        Comparator<ServiceCollector> c = this.getColumnComparator();
        c = this.m_sortOrder == SortOrder.DESCENDING ? c : Collections.reverseOrder(c);
        Collections.sort(collectors, c);
        if (this.m_searchString != null) {
            collectors = (ArrayList)Filter.filter(collectors, Filter.byPartialServiceID(this.m_searchString));
        }
        return collectors;
    }

    public Comparator<ServiceCollector> getColumnComparator() {
        Comparator<ServiceCollector> c = null;
        switch (this.m_sortColumn) {
            case TOTALCOLLECTS: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getCollectionCount();
                    }
                };
            }
            case TOTALCOLLECTTIME: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getTotalCollectionTime();
                    }
                };
            }
            case AVGCOLLECTTIME: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getAverageCollectionTime();
                    }
                };
            }
            case AVGTIMEBETWEENCOLLECTS: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getAverageTimeBetweenCollections();
                    }
                };
            }
            case TOTALSUCCESSCOLLECTS: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getSuccessfulCollectionCount();
                    }
                };
            }
            case SUCCESSPERCENTAGE: {
                return new DoubleComparator(){

                    @Override
                    protected double getDouble(ServiceCollector sc) {
                        return sc.getSuccessPercentage();
                    }
                };
            }
            case AVGSUCCESSCOLLECTTIME: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getAverageCollectionTime();
                    }
                };
            }
            case TOTALUNSUCCESSCOLLECTS: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getErrorCollectionCount();
                    }
                };
            }
            case UNSUCCESSPERCENTAGE: {
                return new DoubleComparator(){

                    @Override
                    protected double getDouble(ServiceCollector sc) {
                        return sc.getErrorPercentage();
                    }
                };
            }
            case AVGUNSUCCESSCOLLECTTIME: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getAverageErrorCollectionTime();
                    }
                };
            }
            case TOTALPERSISTTIME: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getTotalPersistTime();
                    }
                };
            }
            case AVERAGEPERSISTTIME: {
                return new LongComparator(){

                    @Override
                    protected long getLong(ServiceCollector sc) {
                        return sc.getAveragePersistTime();
                    }
                };
            }
        }
        return c;
    }

    public int getThreadCount() {
        return this.m_threads.size();
    }

    public int getCollectionsPerService(String serviceID) {
        return this.getServiceCollector(serviceID).getCollectionCount();
    }

    public long getAverageCollectionTimePerService(String serviceID) {
        return this.getServiceCollector(serviceID).getAverageCollectionTime();
    }

    public long getTotalCollectionTimePerService(String serviceID) {
        return this.getServiceCollector(serviceID).getTotalCollectionTime();
    }

    private ServiceCollector getServiceCollector(String serviceID) {
        ServiceCollector serviceCollector = this.m_serviceCollectors.get(serviceID);
        if (serviceCollector == null) {
            serviceCollector = new ServiceCollector(serviceID);
            this.m_serviceCollectors.put(serviceID, serviceCollector);
        }
        return serviceCollector;
    }

    public void readLogMessagesFromFile(String fileName) throws IOException {
        File logFile = new File(fileName);
        BufferedReader r = new BufferedReader(new FileReader(logFile));
        String logMessage = r.readLine();
        while (logMessage != null) {
            this.addLog(logMessage);
            logMessage = r.readLine();
        }
        r.close();
    }

    public void printGlobalStats(PrintWriter out) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,S");
        out.println("Start Time: " + f.format(this.getStartTime()));
        out.println("End Time: " + f.format(this.getEndTime()));
        out.println("Duration: " + Collector.formatDuration(this.getDuration()));
        out.println("Total Services: " + this.getServiceCount());
        out.println("Threads Used: " + this.getThreadCount());
    }

    public static String formatDuration(long millis) {
        if (Collector.getDurationsMs()) {
            return new Long(millis).toString();
        }
        if (millis == 0L) {
            return "0s";
        }
        boolean force = false;
        StringBuilder buf = new StringBuilder();
        if (force || millis >= 86400000L) {
            long d = millis / 86400000L;
            buf.append(d);
            buf.append("d");
            boolean bl = force = (millis %= 86400000L) != 0L;
        }
        if (force || millis >= 3600000L) {
            long h = millis / 3600000L;
            buf.append(h);
            buf.append("h");
            boolean bl = force = (millis %= 3600000L) != 0L;
        }
        if (force || millis >= 60000L) {
            long m = millis / 60000L;
            buf.append(m);
            buf.append("m");
            boolean bl = force = (millis %= 60000L) != 0L;
        }
        if (millis != 0L) {
            long s = millis / 1000L;
            buf.append(s);
            if (millis % 1000L != 0L) {
                buf.append(".");
                buf.append(String.format("%03d", millis % 1000L));
            }
            buf.append("s");
        }
        return buf.toString();
    }

    private void printServiceStats(ServiceCollector serviceCollector, PrintWriter out) {
        out.printf(SERVICE_DATA_FORMAT, serviceCollector.getServiceID(), Collector.formatDuration(serviceCollector.getAverageCollectionTime()), serviceCollector.getCollectionCount(), Collector.formatDuration(serviceCollector.getAverageSuccessfulCollectionTime()), serviceCollector.getSuccessPercentage(), Collector.formatDuration(serviceCollector.getAverageErrorCollectionTime()), serviceCollector.getErrorPercentage(), Collector.formatDuration(serviceCollector.getAverageTimeBetweenCollections()), Collector.formatDuration(serviceCollector.getTotalCollectionTime()));
        Collector.formatDuration(serviceCollector.getTotalPersistTime());
    }

    public void printServiceHeader(PrintWriter out) {
        out.printf(SERVICE_TITLE_FORMAT, "Service", "Avg Collect Time", "# Collections", "Avg Success Time", "% Success", "Avg Error Time", "% Errors", "Avg Time Between", "Total Collection Time", "Total Persist Time");
    }

    public void printReport(PrintWriter out) {
        this.printGlobalStats(out);
        out.println();
        this.printServiceHeader(out);
        for (ServiceCollector serviceCollector : this.getServiceCollectors()) {
            this.printServiceStats(serviceCollector, out);
        }
    }

    public void printServiceStats(String serviceID, PrintWriter out) {
        ServiceCollector collector = this.getServiceCollector(serviceID);
        if (collector != null) {
            this.printServiceStats(collector, out);
        }
    }

    private static abstract class DoubleComparator
    implements Comparator<ServiceCollector> {
        private DoubleComparator() {
        }

        @Override
        public int compare(ServiceCollector o1, ServiceCollector o2) {
            Double a = this.getDouble(o1);
            Double b = this.getDouble(o2);
            return b.compareTo(a);
        }

        protected abstract double getDouble(ServiceCollector var1);
    }

    private static abstract class LongComparator
    implements Comparator<ServiceCollector> {
        private LongComparator() {
        }

        @Override
        public int compare(ServiceCollector o1, ServiceCollector o2) {
            Long a = this.getLong(o1);
            Long b = this.getLong(o2);
            return b.compareTo(a);
        }

        protected abstract long getLong(ServiceCollector var1);
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }

    public static enum SortColumn {
        TOTALCOLLECTS,
        TOTALCOLLECTTIME,
        AVGCOLLECTTIME,
        AVGTIMEBETWEENCOLLECTS,
        TOTALSUCCESSCOLLECTS,
        SUCCESSPERCENTAGE,
        AVGSUCCESSCOLLECTTIME,
        TOTALUNSUCCESSCOLLECTS,
        UNSUCCESSPERCENTAGE,
        AVGUNSUCCESSCOLLECTTIME,
        TOTALPERSISTTIME,
        AVERAGEPERSISTTIME;

    }
}

