/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.ifttt.helper;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfTttTrigger {
    private static final Logger LOG = LoggerFactory.getLogger(IfTttTrigger.class);
    private final String IFTTT_URL = "https://maker.ifttt.com/trigger/%s/with/key/%s";
    private final String IFTTT_JSON = "{\"value1\":\"%s\",\"value2\":\"%s\",\"value3\":\"%s\"}";
    private String key = "key";
    private String event = "event";
    private String value1 = "";
    private String value2 = "";
    private String value3 = "";

    public IfTttTrigger key(String key) {
        this.key = key;
        return this;
    }

    public IfTttTrigger value1(String value1) {
        this.value1 = value1;
        return this;
    }

    public IfTttTrigger value2(String value2) {
        this.value2 = value2;
        return this;
    }

    public IfTttTrigger value3(String value3) {
        this.value3 = value3;
        return this;
    }

    public IfTttTrigger event(String event) {
        this.event = event;
        return this;
    }

    public void trigger() {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            LOG.debug("Sending '" + this.event + "' event to IFTTT.");
            HttpPost httpPost = new HttpPost(String.format("https://maker.ifttt.com/trigger/%s/with/key/%s", this.event, this.key));
            httpPost.setHeader("Content-type", "application/json");
            StringEntity stringEntity = new StringEntity(String.format("{\"value1\":\"%s\",\"value2\":\"%s\",\"value3\":\"%s\"}", this.value1, this.value2, this.value3));
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse closeableHttpResponse = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = closeableHttpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                LOG.warn("Received HTTP Status {} for request to {} with body {}", new Object[]{statusCode, httpPost.getURI(), httpPost.getEntity()});
            }
        }
        catch (IOException e) {
            LOG.error("Error invoking request: {}", (Throwable)e);
        }
    }
}

