/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.ifttt;

import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.ifttt.config.IfTttConfig;
import org.opennms.features.ifttt.config.Trigger;
import org.opennms.features.ifttt.config.TriggerPackage;
import org.opennms.features.ifttt.config.TriggerSet;
import org.opennms.features.ifttt.helper.DefaultVariableNameExpansion;
import org.opennms.features.ifttt.helper.IfTttTrigger;
import org.opennms.features.ifttt.helper.VariableNameExpansion;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public class IfTttDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(IfTttDaemon.class);
    private final AlarmDao alarmDao;
    private final TransactionOperations transactionOperations;
    private final FileReloadContainer<IfTttConfig> m_fileReloadContainer;
    private ScheduledExecutorService m_alarmPoller;
    private final File ifTttConfigFile;

    public IfTttDaemon(AlarmDao alarmDao, TransactionOperations transactionOperations, File ifTttConfigFile) {
        this.alarmDao = alarmDao;
        this.transactionOperations = transactionOperations;
        this.ifTttConfigFile = ifTttConfigFile;
        this.m_fileReloadContainer = new FileReloadContainer(ifTttConfigFile, (object, resource) -> {
            LOG.debug("Reloading configuration file {}.", (Object)resource.getFilename());
            return (IfTttConfig)JaxbUtils.unmarshal(IfTttConfig.class, (File)ifTttConfigFile);
        });
    }

    public IfTttDaemon(AlarmDao alarmDao, TransactionOperations transactionOperations) {
        this(alarmDao, transactionOperations, Paths.get(System.getProperty("opennms.home", ""), "etc", "ifttt-config.xml").toFile());
    }

    public void start() {
        LOG.debug("Starting IFTTT daemon.");
        if (((IfTttConfig)this.m_fileReloadContainer.getObject()).getEnabled().booleanValue()) {
            this.fireIfTttTriggerSet((IfTttConfig)this.m_fileReloadContainer.getObject(), "ON");
        }
        this.startPoller(((IfTttConfig)this.m_fileReloadContainer.getObject()).getPollInterval());
    }

    public void stop() {
        LOG.debug("Stopping IFTTT daemon.");
        if (((IfTttConfig)this.m_fileReloadContainer.getObject()).getEnabled().booleanValue()) {
            this.fireIfTttTriggerSet((IfTttConfig)this.m_fileReloadContainer.getObject(), "OFF");
        }
        this.stopPoller();
    }

    private void startPoller(final long pollInterval) {
        LOG.debug("Starting alarm poller (interval {}s).", (Object)pollInterval);
        this.m_alarmPoller = Executors.newScheduledThreadPool(1);
        this.m_alarmPoller.scheduleWithFixedDelay(new Runnable(){
            private Map<Boolean, Map<String, Integer>> oldAlarmCount = new HashMap<Boolean, Map<String, Integer>>();
            private Map<Boolean, Map<String, OnmsSeverity>> oldSeverity = new HashMap<Boolean, Map<String, OnmsSeverity>>();
            {
                this.oldAlarmCount.put(Boolean.TRUE, new HashMap());
                this.oldAlarmCount.put(Boolean.FALSE, new HashMap());
                this.oldSeverity.put(Boolean.TRUE, new HashMap());
                this.oldSeverity.put(Boolean.FALSE, new HashMap());
            }

            private List<OnmsAlarm> filterAlarms(List<OnmsAlarm> alarms, TriggerPackage triggerPackage) {
                if (triggerPackage.getOnlyUnacknowledged().booleanValue()) {
                    return alarms.stream().filter(alarm -> alarm.getNodeId() != null).filter(alarm -> !alarm.isAcknowledged()).filter(alarm -> Strings.isNullOrEmpty((String)triggerPackage.getCategoryFilter()) || alarm.getNode().getCategories().stream().anyMatch(category -> category.getName().matches(triggerPackage.getCategoryFilter()))).collect(Collectors.toList());
                }
                return alarms.stream().filter(alarm -> alarm.getNodeId() != null).filter(alarm -> Strings.isNullOrEmpty((String)triggerPackage.getCategoryFilter()) || alarm.getNode().getCategories().stream().anyMatch(category -> category.getName().matches(triggerPackage.getCategoryFilter()))).collect(Collectors.toList());
            }

            @Override
            public void run() {
                try {
                    final IfTttConfig ifTttConfig = (IfTttConfig)IfTttDaemon.this.m_fileReloadContainer.getObject();
                    if (ifTttConfig.getPollInterval() != pollInterval) {
                        IfTttDaemon.this.restartPoller(ifTttConfig.getPollInterval());
                        return;
                    }
                    if (!ifTttConfig.getEnabled().booleanValue()) {
                        LOG.debug("Disabled - skipping alarm polling.");
                        return;
                    }
                    IfTttDaemon.this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class).isNotNull("node").gt("severity", (Object)OnmsSeverity.NORMAL);
                            List alarms = IfTttDaemon.this.alarmDao.findMatching(criteriaBuilder.toCriteria());
                            for (TriggerPackage triggerPackage : ifTttConfig.getTriggerPackages()) {
                                if (!((Map)oldSeverity.get(triggerPackage.getOnlyUnacknowledged())).containsKey(triggerPackage.getCategoryFilter())) {
                                    ((Map)oldSeverity.get(triggerPackage.getOnlyUnacknowledged())).put(triggerPackage.getCategoryFilter(), OnmsSeverity.INDETERMINATE);
                                    ((Map)oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged())).put(triggerPackage.getCategoryFilter(), 0);
                                }
                                List filteredAlarms = this.filterAlarms(alarms, triggerPackage);
                                Optional<OnmsSeverity> maxAlarmsSeverity = filteredAlarms.stream().map(OnmsAlarm::getSeverity).max(Comparator.naturalOrder());
                                OnmsSeverity newSeverity = maxAlarmsSeverity.orElse(OnmsSeverity.NORMAL);
                                int newAlarmCount = filteredAlarms.size();
                                LOG.debug("Received {} filtered, {} new severity", (Object)newAlarmCount, (Object)newSeverity);
                                DefaultVariableNameExpansion defaultVariableNameExpansion = new DefaultVariableNameExpansion((OnmsSeverity)((Map)oldSeverity.get(triggerPackage.getOnlyUnacknowledged())).get(triggerPackage.getCategoryFilter()), newSeverity, (Integer)((Map)oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged())).get(triggerPackage.getCategoryFilter()), newAlarmCount);
                                if (!newSeverity.equals(((Map)oldSeverity.get(triggerPackage.getOnlyUnacknowledged())).get(triggerPackage.getCategoryFilter())) || newAlarmCount != (Integer)((Map)oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged())).get(triggerPackage.getCategoryFilter())) {
                                    IfTttDaemon.this.fireIfTttTriggerSet(ifTttConfig, triggerPackage.getCategoryFilter(), newSeverity, defaultVariableNameExpansion);
                                }
                                LOG.debug("Old severity: {}, new severity: {}, old alarm count: {}, new alarm count: {}", new Object[]{((Map)oldSeverity.get(triggerPackage.getOnlyUnacknowledged())).get(triggerPackage.getCategoryFilter()), newSeverity, ((Map)oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged())).get(triggerPackage.getCategoryFilter()), newAlarmCount});
                                ((Map)oldSeverity.get(triggerPackage.getOnlyUnacknowledged())).put(triggerPackage.getCategoryFilter(), newSeverity);
                                ((Map)oldAlarmCount.get(triggerPackage.getOnlyUnacknowledged())).put(triggerPackage.getCategoryFilter(), newAlarmCount);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error("Error while polling alarm table.", (Throwable)e);
                }
                finally {
                    LOG.debug("Run complete. Next poll in {}s.", (Object)pollInterval);
                }
            }
        }, pollInterval, pollInterval, TimeUnit.SECONDS);
    }

    private void restartPoller(long pollInterval) {
        LOG.debug("Restarting alarm poller (interval {}s).", (Object)pollInterval);
        this.stopPoller();
        this.startPoller(pollInterval);
    }

    private void stopPoller() {
        LOG.debug("Stopping alarm poller.");
        if (this.m_alarmPoller != null) {
            this.m_alarmPoller.shutdown();
            this.m_alarmPoller = null;
        }
    }

    private void fireIfTttTriggerSet(IfTttConfig ifTttConfig, String name) {
        if (ifTttConfig == null) {
            return;
        }
        for (TriggerPackage triggerPackage : ifTttConfig.getTriggerPackages()) {
            this.fireIfTttTriggerSet(ifTttConfig, triggerPackage.getCategoryFilter(), name.toUpperCase(), (String string) -> string);
        }
    }

    private void fireIfTttTriggerSet(IfTttConfig ifTttConfig, String categoryFilter, OnmsSeverity newSeverity, VariableNameExpansion variableNameExpansion) {
        this.fireIfTttTriggerSet(ifTttConfig, categoryFilter, newSeverity.getLabel().toUpperCase(), variableNameExpansion);
    }

    protected void fireIfTttTriggerSet(IfTttConfig ifTttConfig, String categoryFilter, String name, VariableNameExpansion variableNameExpansion) {
        if (ifTttConfig == null) {
            return;
        }
        TriggerPackage triggerPackage = ifTttConfig.getTriggerPackageForCategoryFilter(categoryFilter);
        if (triggerPackage != null) {
            TriggerSet triggerSet = triggerPackage.getTriggerSetForName(name);
            if (triggerSet != null) {
                for (Trigger trigger : triggerSet.getTriggers()) {
                    new IfTttTrigger().key(ifTttConfig.getKey()).event(trigger.getEventName()).value1(variableNameExpansion.replace(trigger.getValue1())).value2(variableNameExpansion.replace(trigger.getValue2())).value3(variableNameExpansion.replace(trigger.getValue3())).trigger();
                    try {
                        Thread.sleep(trigger.getDelay());
                    }
                    catch (InterruptedException e) {
                        LOG.error("Error triggering IFTTT event: ", (Throwable)e);
                    }
                }
            } else {
                LOG.debug("No trigger-set with name '{}' defined.", (Object)name);
            }
        } else {
            LOG.error("Error retrieving trigger package for category filter{}.", (Object)categoryFilter);
        }
    }
}

