/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.graphml.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.opennms.features.graphml.model.GraphMLEdge;
import org.opennms.features.graphml.model.GraphMLElement;
import org.opennms.features.graphml.model.GraphMLNode;

public class GraphMLGraph
extends GraphMLElement {
    private final LinkedHashMap<String, GraphMLEdge> edgesById = new LinkedHashMap();
    private final LinkedHashMap<String, GraphMLNode> nodeById = new LinkedHashMap();

    public void addEdge(GraphMLEdge edge) {
        this.edgesById.put(edge.getId(), edge);
    }

    public void addNode(GraphMLNode node) {
        this.nodeById.put(node.getId(), node);
    }

    public Collection<GraphMLEdge> getEdges() {
        return this.edgesById.values();
    }

    public Collection<GraphMLNode> getNodes() {
        return this.nodeById.values();
    }

    public GraphMLNode getNodeById(String id) {
        return this.nodeById.get(id);
    }

    public GraphMLEdge getEdgeById(String id) {
        return this.edgesById.get(id);
    }

    @Override
    public <T> T accept(GraphMLElement.GraphMLElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.edgesById, this.nodeById);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals && obj instanceof GraphMLGraph) {
            GraphMLGraph other = (GraphMLGraph)obj;
            equals = Objects.equals(this.edgesById, other.edgesById) && Objects.equals(this.nodeById, other.nodeById);
            return equals;
        }
        return false;
    }
}

