/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.graphml.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.graphdrawing.graphml.GraphmlType;
import org.opennms.features.graphml.service.GraphmlRepository;

public class InMemoryGraphmlRepository
implements GraphmlRepository {
    private final Map<String, GraphmlType> repository = new HashMap<String, GraphmlType>();

    @Override
    public GraphmlType findByName(String name) throws IOException {
        Objects.requireNonNull(name);
        this.validateExists(name);
        return this.repository.get(name);
    }

    @Override
    public void save(String name, String label, GraphmlType graphmlType) throws IOException {
        if (this.exists(name)) {
            throw new IOException(name + " already exists");
        }
        this.repository.put(name, graphmlType);
    }

    @Override
    public void delete(String name) throws IOException {
        this.validateExists(name);
        this.repository.remove(name);
    }

    @Override
    public boolean exists(String name) {
        return this.repository.get(name) != null;
    }

    private void validateExists(String name) {
        if (!this.exists(name)) {
            throw new NoSuchElementException("No GraphML file found with name  " + name);
        }
    }
}

