/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.graphml.model;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graphdrawing.graphml.DataType;
import org.graphdrawing.graphml.EdgeType;
import org.graphdrawing.graphml.GraphType;
import org.graphdrawing.graphml.GraphmlType;
import org.graphdrawing.graphml.HyperedgeType;
import org.graphdrawing.graphml.KeyForType;
import org.graphdrawing.graphml.KeyType;
import org.graphdrawing.graphml.KeyTypeType;
import org.graphdrawing.graphml.NodeType;
import org.graphdrawing.graphml.PortType;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLEdge;
import org.opennms.features.graphml.model.GraphMLElement;
import org.opennms.features.graphml.model.GraphMLGraph;
import org.opennms.features.graphml.model.GraphMLNode;
import org.opennms.features.graphml.model.InvalidGraphException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLReader {
    private static final Logger LOG = LoggerFactory.getLogger(GraphMLReader.class);

    public static GraphML read(InputStream input) throws InvalidGraphException {
        return GraphMLReader.convert((GraphmlType)JaxbUtils.unmarshal(GraphmlType.class, (InputStream)input));
    }

    public static GraphML convert(GraphmlType input) throws InvalidGraphException {
        HashMap<String, GraphMLGraph> nodeIdToGraphMapping = new HashMap<String, GraphMLGraph>();
        Map<String, KeyType> keyIdToTypeMapping = GraphMLReader.getKeyIdToTypeMapping(input.getKey());
        List<GraphType> graphs = GraphMLReader.filter(input.getGraphOrData(), GraphType.class);
        GraphML convertedGraphML = new GraphML();
        GraphMLReader.addProperties(convertedGraphML, null, keyIdToTypeMapping, GraphMLReader.filter(input.getGraphOrData(), DataType.class));
        for (GraphType eachGraph : graphs) {
            GraphMLGraph convertedGraph = new GraphMLGraph();
            GraphMLReader.addProperties(convertedGraph, eachGraph.getId(), keyIdToTypeMapping, GraphMLReader.filter(eachGraph.getDataOrNodeOrEdge(), DataType.class));
            List<NodeType> nodes = GraphMLReader.filter(eachGraph.getDataOrNodeOrEdge(), NodeType.class);
            Iterator iterator = nodes.iterator();
            while (iterator.hasNext()) {
                NodeType eachNode = (NodeType)iterator.next();
                GraphMLNode convertedNode = new GraphMLNode();
                nodeIdToGraphMapping.put(eachNode.getId(), convertedGraph);
                GraphMLReader.addProperties(convertedNode, eachNode.getId(), keyIdToTypeMapping, GraphMLReader.filter(eachNode.getDataOrPort(), DataType.class));
                List<PortType> ports = GraphMLReader.filter(eachNode.getDataOrPort(), PortType.class);
                if (!ports.isEmpty()) {
                    LOG.warn("Ports are defined for node with id {} but ports are not supported. Ignoring {} defined ports", (Object)eachNode.getId(), (Object)ports.size());
                }
                convertedGraph.addNode(convertedNode);
            }
            convertedGraphML.addGraph(convertedGraph);
        }
        for (GraphType eachGraphType : graphs) {
            List<EdgeType> edges = GraphMLReader.filter(eachGraphType.getDataOrNodeOrEdge(), EdgeType.class);
            for (EdgeType eachEdge : edges) {
                GraphMLEdge convertedEdge = new GraphMLEdge();
                GraphMLGraph sourceGraph = (GraphMLGraph)nodeIdToGraphMapping.get(eachEdge.getSource());
                GraphMLGraph targetGraph = (GraphMLGraph)nodeIdToGraphMapping.get(eachEdge.getTarget());
                if (sourceGraph == null) {
                    throw new InvalidGraphException("No graph found for edge with id " + eachEdge.getSource());
                }
                if (targetGraph == null) {
                    throw new InvalidGraphException("No graph found for edge with id " + eachEdge.getTarget());
                }
                GraphMLNode sourceNode = sourceGraph.getNodeById(eachEdge.getSource());
                GraphMLNode targetNode = targetGraph.getNodeById(eachEdge.getTarget());
                convertedEdge.setSource(sourceNode);
                convertedEdge.setTarget(targetNode);
                GraphMLReader.addProperties(convertedEdge, eachEdge.getId(), keyIdToTypeMapping, GraphMLReader.filter(eachEdge.getData(), DataType.class));
                sourceGraph.addEdge(convertedEdge);
            }
            List<HyperedgeType> hyperEdges = GraphMLReader.filter(eachGraphType.getDataOrNodeOrEdge(), HyperedgeType.class);
            if (hyperEdges.isEmpty()) continue;
            LOG.warn("Hyper Edges are defined for graph with id {} but are not supported. Ignoring {} defined hyper edges", (Object)eachGraphType.getId(), (Object)hyperEdges.size());
        }
        GraphMLReader.validate(convertedGraphML);
        return convertedGraphML;
    }

    private static Map<String, KeyType> getKeyIdToTypeMapping(List<KeyType> key) throws InvalidGraphException {
        HashMap keyTypeIdMap = new HashMap();
        for (KeyType eachKeyType : key) {
            keyTypeIdMap.putIfAbsent(eachKeyType.getId(), new ArrayList());
            ((List)keyTypeIdMap.get(eachKeyType.getId())).add(eachKeyType);
        }
        for (List eachList : keyTypeIdMap.values()) {
            if (eachList.stream().map(e -> e.getAttrType()).collect(Collectors.toSet()).size() <= 1) continue;
            throw new InvalidGraphException("Attribute Type of key with id " + ((KeyType)eachList.get(0)).getId() + " varies.");
        }
        Map<String, KeyType> keyIdToTypeMapping = keyTypeIdMap.values().stream().map(list -> (KeyType)list.get(0)).collect(Collectors.toMap(keyType -> keyType.getId(), Function.identity()));
        if (keyIdToTypeMapping.keySet().stream().filter(keyId -> keyId.equals("id")).findFirst().isPresent()) {
            throw new InvalidGraphException("Property with id cannot be defined");
        }
        return keyIdToTypeMapping;
    }

    private static <T> List<T> filter(List<?> inputList, Class<T> type) {
        return inputList.stream().filter(it -> type.isInstance(it)).map(it -> type.cast(it)).collect(Collectors.toList());
    }

    private static void addProperties(GraphMLElement graphElement, String elementId, Map<String, KeyType> keyIdToTypeMapping, List<DataType> elementData) throws InvalidGraphException {
        for (DataType eachDataElement : elementData) {
            KeyType keyType2 = keyIdToTypeMapping.get(eachDataElement.getKey());
            if (keyType2 == null) {
                throw new InvalidGraphException("Accessing not existing attribute with key " + eachDataElement.getKey());
            }
            if (keyType2.getAttrType() == null) {
                throw new InvalidGraphException("Key with id='" + keyType2.getId() + "' and attribute name '" + keyType2.getAttrName() + "' is null. This is usually caused by an invalid attribute type value. The following values are supported: " + Arrays.stream(KeyTypeType.values()).map(k -> k.value()).collect(Collectors.joining(", ")));
            }
            Object value = GraphMLReader.typeCastValue(eachDataElement.getContent(), keyType2.getAttrType());
            graphElement.setProperty(keyType2.getAttrName(), value);
        }
        keyIdToTypeMapping.values().stream().filter(keyType -> keyType.getDefault() != null).filter(keyType -> !Strings.isNullOrEmpty((String)keyType.getDefault().getContent())).filter(keyType -> graphElement.accept(new GraphMLElement.GraphMLElementVisitor<Boolean>(){

            @Override
            public Boolean visit(GraphMLGraph graph) {
                return Lists.newArrayList((Object[])new KeyForType[]{KeyForType.ALL, KeyForType.GRAPH, KeyForType.GRAPHML}).contains((Object)keyType.getFor());
            }

            @Override
            public Boolean visit(GraphMLNode node) {
                return Lists.newArrayList((Object[])new KeyForType[]{KeyForType.ALL, KeyForType.GRAPH, KeyForType.GRAPHML, KeyForType.NODE}).contains((Object)keyType.getFor());
            }

            @Override
            public Boolean visit(GraphMLEdge edge) {
                return Lists.newArrayList((Object[])new KeyForType[]{KeyForType.ALL, KeyForType.GRAPH, KeyForType.GRAPHML, KeyForType.EDGE}).contains((Object)keyType.getFor());
            }

            @Override
            public Boolean visit(GraphML graphML) {
                return Lists.newArrayList((Object[])new KeyForType[]{KeyForType.ALL, KeyForType.GRAPHML}).contains((Object)keyType.getFor());
            }
        })).forEach(keyType -> {
            if (graphElement.getProperty(keyType.getAttrName()) == null) {
                graphElement.setProperty(keyType.getAttrName(), GraphMLReader.typeCastValue(keyType.getDefault().getContent(), keyType.getAttrType()));
            }
        });
        if (elementId != null) {
            graphElement.setProperty("id", elementId);
        }
    }

    private static Object typeCastValue(String value, KeyTypeType keyType) {
        switch (keyType) {
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
            case FLOAT: {
                return Float.valueOf(value);
            }
            case INT: {
                return Integer.valueOf(value);
            }
            case LONG: {
                return Long.valueOf(value);
            }
        }
        return value;
    }

    private static void validate(GraphML graphML) throws InvalidGraphException {
        HashSet<String> graphIds = new HashSet<String>();
        for (GraphMLGraph eachGraph : graphML.getGraphs()) {
            if (graphIds.contains(eachGraph.getId())) {
                throw new InvalidGraphException("There already exists a graph with id " + eachGraph.getId());
            }
            graphIds.add(eachGraph.getId());
            HashSet<String> nodeIds = new HashSet<String>();
            HashSet<String> edgeIds = new HashSet<String>();
            for (GraphMLNode eachNode : eachGraph.getNodes()) {
                if (nodeIds.contains(eachNode.getId())) {
                    throw new InvalidGraphException("There already exists a node with id " + eachNode.getId() + " in graph with id " + eachGraph.getId());
                }
                nodeIds.add(eachNode.getId());
            }
            for (GraphMLEdge eachEdge : eachGraph.getEdges()) {
                if (edgeIds.contains(eachEdge.getId())) {
                    throw new InvalidGraphException("There already exists an edge with id " + eachEdge.getId() + " in graph with id " + eachGraph.getId());
                }
                edgeIds.add(eachEdge.getId());
            }
        }
    }
}

