/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.eifadapter;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EifParser {
    private static final Logger LOG = LoggerFactory.getLogger(EifParser.class);
    private static final int eifStartOffset = 37;

    public static List<Event> translateEifToOpenNMS(NodeDao nodeDao, StringBuilder eifBuff) {
        ArrayList<Event> translatedEvents = new ArrayList<Event>();
        while (eifBuff.length() > 0 && eifBuff.indexOf(";END") > 1) {
            int eventStart = eifBuff.indexOf("<START>>");
            int eventEnd = eifBuff.indexOf(";END");
            String eifEvent = eifBuff.substring(eventStart + 37, eventEnd);
            eifBuff.delete(0, eventEnd + 4);
            String eifClass = eifEvent.split(";")[0];
            String eifSlots = eifEvent.substring(eifClass.length() + 1, eifEvent.length()).replaceAll(System.getProperty("line.separator"), "");
            Map<String, String> eifSlotMap = EifParser.parseEifSlots(eifSlots);
            ArrayList parmList = new ArrayList();
            eifSlotMap.entrySet().forEach(p -> parmList.add(new Parm((String)p.getKey(), (String)p.getValue())));
            long nodeId = EifParser.connectEifEventToNode(nodeDao, eifSlotMap);
            translatedEvents.add(new EventBuilder("uei.opennms.org/vendor/IBM/EIF/" + eifClass, "eif").setNodeid(nodeId).setSeverity(EifSeverity.valueOf(eifSlotMap.get("severity")).toOnmsSeverity().getLabel()).setParms(parmList).getEvent());
        }
        if (translatedEvents.isEmpty()) {
            LOG.error("Received a zero-length list");
            return null;
        }
        return translatedEvents;
    }

    public static Map<String, String> parseEifSlots(String eifBodyString) {
        HashMap<String, String> mappedEifSlots = new HashMap<String, String>();
        List<String> slotArray = Arrays.asList(eifBodyString.split(";"));
        for (int i = 0; i < slotArray.size(); ++i) {
            String[] slotKeyValue;
            slotArray.get(i).replaceAll("[ ']", "");
            if (slotArray.get(i).length() == 0 || (slotKeyValue = slotArray.get(i).split("=")).length < 2) continue;
            mappedEifSlots.put(slotKeyValue[0], slotKeyValue[1].replaceAll("^\"|^'|\"$|'$", ""));
        }
        return mappedEifSlots;
    }

    private static long connectEifEventToNode(NodeDao nodeDao, Map<String, String> eifSlotMap) {
        String origin;
        long nodeId = 0L;
        String fqdn = "";
        if (!"".equals(eifSlotMap.get("fqhostname")) && eifSlotMap.get("fqhostname") != null) {
            fqdn = eifSlotMap.get("fqhostname");
        } else if (!"".equals(eifSlotMap.get("hostname")) && eifSlotMap.get("hostname") != null) {
            String hostname = eifSlotMap.get("hostname");
            try {
                fqdn = InetAddress.getByName(hostname).getCanonicalHostName();
            }
            catch (UnknownHostException uhe) {
                LOG.error("UnknownHostException while resolving hostname {}", (Object)hostname);
            }
        }
        if ("".equals(fqdn) && !"".equals(eifSlotMap.get("origin")) && eifSlotMap.get("origin") != null && InetAddresses.isInetAddress((String)(origin = eifSlotMap.get("origin")))) {
            try {
                fqdn = InetAddress.getByAddress(origin.getBytes()).getCanonicalHostName();
            }
            catch (UnknownHostException uhe) {
                LOG.error("UnknownHostException while resolving origin {}", (Object)origin);
                fqdn = origin;
            }
        }
        if (!"".equals(fqdn) && !fqdn.equals(null)) {
            OnmsNode firstMatch;
            List matchingNodes = new ArrayList();
            try {
                matchingNodes = nodeDao.findByLabel(fqdn);
            }
            catch (NullPointerException npe) {
                LOG.debug("No node located for {}", (Object)fqdn);
            }
            if (matchingNodes.size() <= 0 && !InetAddresses.isInetAddress((String)fqdn)) {
                try {
                    matchingNodes = nodeDao.findByLabel(fqdn.split("\\.")[0]);
                }
                catch (NullPointerException npe) {
                    LOG.debug("No node located for {}", (Object)fqdn.split("\\.")[0]);
                }
            }
            OnmsNode onmsNode = firstMatch = matchingNodes.size() > 0 ? (OnmsNode)matchingNodes.get(0) : null;
            if (firstMatch != null) {
                nodeId = Long.valueOf(firstMatch.getNodeId());
            }
        }
        if (nodeId == 0L) {
            LOG.debug("connectEifEventToNode : No matching nodes found. Defaulting to nodeId 0.");
        }
        return nodeId;
    }

    static enum EifSeverity {
        FATAL,
        CRITICAL,
        MINOR,
        WARNING,
        OK,
        INFO,
        HARMLESS,
        UNKNOWN;


        public OnmsSeverity toOnmsSeverity() {
            switch (this) {
                case UNKNOWN: {
                    return OnmsSeverity.INDETERMINATE;
                }
                case HARMLESS: 
                case INFO: 
                case OK: {
                    return OnmsSeverity.NORMAL;
                }
                case WARNING: {
                    return OnmsSeverity.WARNING;
                }
                case MINOR: {
                    return OnmsSeverity.MINOR;
                }
                case CRITICAL: {
                    return OnmsSeverity.MAJOR;
                }
                case FATAL: {
                    return OnmsSeverity.CRITICAL;
                }
            }
            throw new IllegalArgumentException("No mapping for " + this.name() + " found");
        }
    }
}

