/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.eifadapter;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.camel.component.netty4.ChannelHandlerFactory;
import org.opennms.features.eifadapter.EifParser;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;

public class EifMessageDecoder
extends MessageToMessageDecoder<ByteBuf>
implements ChannelHandlerFactory {
    private final StringBuilder buffer = new StringBuilder();
    private final Charset charset = Charset.defaultCharset();
    private NodeDao nodeDao;

    public ChannelHandler newChannelHandler() {
        return new EifMessageDecoder();
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        this.buffer.append(msg.toString(this.charset));
        if (this.buffer.toString().contains("<START>>") && this.buffer.toString().contains(";END")) {
            int eifStart = this.buffer.indexOf("<START>>");
            int eifEnd = this.buffer.lastIndexOf(";END");
            StringBuilder eif = new StringBuilder(this.buffer.substring(eifStart, eifEnd + 4));
            this.buffer.delete(eifStart, eifEnd + 4);
            List<Event> e = EifParser.translateEifToOpenNMS(this.nodeDao, eif);
            if (e != null) {
                Log eifEvents = new Log();
                e.forEach(event -> eifEvents.addEvent(event));
                out.add(eifEvents);
            }
        }
    }
}

